/*
 * Decompiled with CFR 0.152.
 */
package brave.internal.recorder;

import brave.Clock;
import brave.Span;
import brave.internal.HexCodec;
import brave.internal.Nullable;
import brave.propagation.TraceContext;
import zipkin2.Endpoint;
import zipkin2.Span;

final class MutableSpan {
    final Clock clock;
    final Span.Builder span;
    boolean finished;
    long timestamp;

    MutableSpan(Clock clock, TraceContext context, Endpoint localEndpoint) {
        this.clock = clock;
        this.span = Span.newBuilder().traceId(context.traceIdString()).parentId(context.parentId() != null ? HexCodec.toLowerHex(context.parentId()) : null).id(HexCodec.toLowerHex(context.spanId())).debug(context.debug() ? Boolean.valueOf(true) : null).shared(context.shared() ? Boolean.valueOf(true) : null).localEndpoint(localEndpoint);
        this.finished = false;
    }

    MutableSpan start() {
        return this.start(this.clock.currentTimeMicroseconds());
    }

    synchronized MutableSpan start(long timestamp) {
        this.timestamp = timestamp;
        this.span.timestamp(Long.valueOf(this.timestamp));
        return this;
    }

    synchronized MutableSpan name(String name) {
        this.span.name(name);
        return this;
    }

    synchronized MutableSpan kind(Span.Kind kind) {
        try {
            this.span.kind(Span.Kind.valueOf((String)kind.name()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return this;
    }

    MutableSpan annotate(String value) {
        return this.annotate(this.clock.currentTimeMicroseconds(), value);
    }

    synchronized MutableSpan annotate(long timestamp, String value) {
        if ("cs".equals(value)) {
            this.timestamp = timestamp;
            this.span.kind(Span.Kind.CLIENT).timestamp(Long.valueOf(this.timestamp));
        } else if ("sr".equals(value)) {
            this.timestamp = timestamp;
            this.span.kind(Span.Kind.SERVER).timestamp(Long.valueOf(this.timestamp));
        } else if ("cr".equals(value)) {
            this.span.kind(Span.Kind.CLIENT);
            this.finish(timestamp);
        } else if ("ss".equals(value)) {
            this.span.kind(Span.Kind.SERVER);
            this.finish(timestamp);
        } else {
            this.span.addAnnotation(timestamp, value);
        }
        return this;
    }

    synchronized MutableSpan tag(String key, String value) {
        this.span.putTag(key, value);
        return this;
    }

    synchronized MutableSpan remoteEndpoint(Endpoint remoteEndpoint) {
        this.span.remoteEndpoint(remoteEndpoint);
        return this;
    }

    synchronized MutableSpan finish(@Nullable Long finishTimestamp) {
        if (this.finished) {
            return this;
        }
        this.finished = true;
        if (this.timestamp != 0L && finishTimestamp != null) {
            this.span.duration(Long.valueOf(Math.max(finishTimestamp - this.timestamp, 1L)));
        }
        return this;
    }

    synchronized Span toSpan() {
        return this.span.build();
    }
}

