/*
 * Decompiled with CFR 0.152.
 */
package brave.propagation;

import brave.Tracing;
import brave.internal.Nullable;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public final class ExtraFieldPropagation<K>
implements Propagation<K> {
    final Propagation<K> delegate;
    final List<K> keys;
    final Map<String, K> nameToKey;

    public static Propagation.Factory newFactory(Propagation.Factory delegate, String ... names) {
        return new Factory(delegate, Arrays.asList(names));
    }

    public static Propagation.Factory newFactory(Propagation.Factory delegate, Collection<String> names) {
        return new Factory(delegate, names);
    }

    @Nullable
    public static String current(String name) {
        Tracing tracing = Tracing.current();
        if (tracing == null) {
            return null;
        }
        TraceContext context = tracing.currentTraceContext().get();
        if (context == null) {
            return null;
        }
        return ExtraFieldPropagation.get(context, name);
    }

    @Nullable
    public static String get(TraceContext context, String name) {
        if (context == null) {
            throw new NullPointerException("context == null");
        }
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        name = name.toLowerCase(Locale.ROOT);
        for (Object extra : context.extra()) {
            if (!(extra instanceof Extra)) continue;
            return ((Extra)extra).get(name);
        }
        return null;
    }

    ExtraFieldPropagation(Propagation<K> delegate, Map<String, K> nameToKey) {
        this.delegate = delegate;
        this.nameToKey = nameToKey;
        ArrayList<K> keys = new ArrayList<K>(delegate.keys());
        keys.addAll(nameToKey.values());
        this.keys = Collections.unmodifiableList(keys);
    }

    @Override
    public List<K> keys() {
        return this.keys;
    }

    @Override
    public <C> TraceContext.Injector<C> injector(Propagation.Setter<C, K> setter) {
        return new ExtraFieldInjector<C, K>(this.delegate.injector(setter), setter, this.nameToKey);
    }

    @Override
    public <C> TraceContext.Extractor<C> extractor(Propagation.Getter<C, K> getter) {
        TraceContext.Extractor<C> extractorDelegate = this.delegate.extractor(getter);
        return new ExtraFieldExtractor<C, K>(extractorDelegate, getter, this.nameToKey);
    }

    static final class ExtraFieldExtractor<C, K>
    implements TraceContext.Extractor<C> {
        final TraceContext.Extractor<C> delegate;
        final Propagation.Getter<C, K> getter;
        final Map<String, K> names;

        ExtraFieldExtractor(TraceContext.Extractor<C> delegate, Propagation.Getter<C, K> getter, Map<String, K> names) {
            this.delegate = delegate;
            this.getter = getter;
            this.names = names;
        }

        @Override
        public TraceContextOrSamplingFlags extract(C carrier) {
            TraceContextOrSamplingFlags result = this.delegate.extract(carrier);
            Extra extra = null;
            for (Map.Entry<String, K> field : this.names.entrySet()) {
                String maybeValue = this.getter.get(carrier, field.getValue());
                if (maybeValue == null) continue;
                if (extra == null) {
                    extra = new One();
                } else if (extra instanceof One) {
                    One one = extra;
                    extra = new Many();
                    extra.put(one.name, one.value);
                }
                extra.put(field.getKey(), maybeValue);
            }
            if (extra == null) {
                return result;
            }
            return result.toBuilder().addExtra(extra).build();
        }
    }

    static final class ExtraFieldInjector<C, K>
    implements TraceContext.Injector<C> {
        final TraceContext.Injector<C> delegate;
        final Propagation.Setter<C, K> setter;
        final Map<String, K> nameToKey;

        ExtraFieldInjector(TraceContext.Injector<C> delegate, Propagation.Setter<C, K> setter, Map<String, K> nameToKey) {
            this.delegate = delegate;
            this.setter = setter;
            this.nameToKey = nameToKey;
        }

        @Override
        public void inject(TraceContext traceContext, C carrier) {
            for (Object extra : traceContext.extra()) {
                if (!(extra instanceof Extra)) continue;
                ((Extra)extra).setAll(carrier, this.setter, this.nameToKey);
                break;
            }
            this.delegate.inject(traceContext, carrier);
        }
    }

    static final class Many
    extends Extra {
        final LinkedHashMap<String, String> fields = new LinkedHashMap();

        Many() {
        }

        @Override
        void put(String name, String value) {
            this.fields.put(name, value);
        }

        @Override
        String get(String name) {
            return this.fields.get(name);
        }

        @Override
        <C, K> void setAll(C carrier, Propagation.Setter<C, K> setter, Map<String, K> nameToKey) {
            for (Map.Entry<String, String> field : this.fields.entrySet()) {
                K key = nameToKey.get(field.getKey());
                if (key == null) continue;
                setter.put(carrier, nameToKey.get(field.getKey()), field.getValue());
            }
        }

        public String toString() {
            return "ExtraFieldPropagation" + this.fields;
        }
    }

    static final class One
    extends Extra {
        String name;
        String value;

        One() {
        }

        @Override
        void put(String name, String value) {
            this.name = name;
            this.value = value;
        }

        @Override
        String get(String name) {
            return name.equals(this.name) ? this.value : null;
        }

        @Override
        <C, K> void setAll(C carrier, Propagation.Setter<C, K> setter, Map<String, K> nameToKey) {
            K key = nameToKey.get(this.name);
            if (key == null) {
                return;
            }
            setter.put(carrier, key, this.value);
        }

        public String toString() {
            return "ExtraFieldPropagation{" + this.name + "=" + this.value + "}";
        }
    }

    static abstract class Extra {
        Extra() {
        }

        abstract void put(String var1, String var2);

        abstract String get(String var1);

        abstract <C, K> void setAll(C var1, Propagation.Setter<C, K> var2, Map<String, K> var3);
    }

    static final class Factory
    extends Propagation.Factory {
        final Propagation.Factory delegate;
        final List<String> names;

        Factory(Propagation.Factory delegate, Collection<String> names) {
            if (delegate == null) {
                throw new NullPointerException("field == null");
            }
            if (names == null) {
                throw new NullPointerException("names == null");
            }
            if (names.isEmpty()) {
                throw new NullPointerException("names.length == 0");
            }
            this.delegate = delegate;
            this.names = new ArrayList<String>();
            for (String name : names) {
                this.names.add(name.toLowerCase(Locale.ROOT));
            }
        }

        @Override
        public boolean supportsJoin() {
            return this.delegate.supportsJoin();
        }

        @Override
        public boolean requires128BitTraceId() {
            return this.delegate.requires128BitTraceId();
        }

        @Override
        public final <K> Propagation<K> create(Propagation.KeyFactory<K> keyFactory) {
            LinkedHashMap<String, K> names = new LinkedHashMap<String, K>();
            for (String name : this.names) {
                names.put(name, keyFactory.create(name));
            }
            return new ExtraFieldPropagation<K>(this.delegate.create(keyFactory), names);
        }
    }
}

