/*
 * Decompiled with CFR 0.152.
 */
package brave.propagation;

import brave.internal.Nullable;

public abstract class SamplingFlags {
    public static final SamplingFlags EMPTY = new SamplingFlagsImpl(null, false);
    public static final SamplingFlags SAMPLED = new SamplingFlagsImpl(true, false);
    public static final SamplingFlags NOT_SAMPLED = new SamplingFlagsImpl(false, false);
    public static final SamplingFlags DEBUG = new SamplingFlagsImpl(true, true);

    @Nullable
    public abstract Boolean sampled();

    public abstract boolean debug();

    SamplingFlags() {
    }

    static final class SamplingFlagsImpl
    extends SamplingFlags {
        final Boolean sampled;
        final boolean debug;

        SamplingFlagsImpl(Boolean sampled, boolean debug) {
            this.sampled = sampled;
            this.debug = debug;
        }

        @Override
        public Boolean sampled() {
            return this.sampled;
        }

        @Override
        public boolean debug() {
            return this.debug;
        }

        public String toString() {
            return "SamplingFlags(sampled=" + this.sampled + ", debug=" + this.debug + ")";
        }
    }

    public static final class Builder {
        Boolean sampled;
        boolean debug = false;

        public Builder sampled(@Nullable Boolean sampled) {
            this.sampled = sampled;
            return this;
        }

        public Builder debug(boolean debug) {
            this.debug = debug;
            if (debug) {
                this.sampled(true);
            }
            return this;
        }

        public static SamplingFlags build(@Nullable Boolean sampled) {
            if (sampled != null) {
                return sampled != false ? SAMPLED : NOT_SAMPLED;
            }
            return EMPTY;
        }

        public SamplingFlags build() {
            if (this.debug) {
                return DEBUG;
            }
            return Builder.build(this.sampled);
        }
    }
}

