/*
 * Decompiled with CFR 0.152.
 */
package brave.propagation;

import brave.Span;
import brave.Tracer;
import brave.Tracing;
import brave.internal.Nullable;
import brave.propagation.AutoValue_ThreadLocalSpan;
import com.google.auto.value.AutoValue;

@AutoValue
public abstract class ThreadLocalSpan {
    public static final ThreadLocalSpan CURRENT_TRACER = new ThreadLocalSpan(){

        @Override
        Tracer tracer() {
            return Tracing.currentTracer();
        }
    };
    final ThreadLocal<Tracer.SpanInScope> currentSpanInScope = new ThreadLocal();

    public static ThreadLocalSpan create(Tracer tracer) {
        return new AutoValue_ThreadLocalSpan(tracer);
    }

    abstract Tracer tracer();

    @Nullable
    public Span next() {
        Tracer tracer = this.tracer();
        if (tracer == null) {
            return null;
        }
        Span next = tracer.nextSpan();
        this.currentSpanInScope.set(tracer.withSpanInScope(next));
        return next;
    }

    @Nullable
    public Span remove() {
        Tracer tracer = this.tracer();
        Span span = tracer != null ? tracer.currentSpan() : null;
        Tracer.SpanInScope scope = this.currentSpanInScope.get();
        if (scope != null) {
            scope.close();
            this.currentSpanInScope.remove();
        }
        return span;
    }

    ThreadLocalSpan() {
    }
}

