/*
 * Decompiled with CFR 0.152.
 */
package brave.propagation;

import brave.internal.HexCodec;
import brave.internal.Nullable;
import brave.propagation.AutoValue_TraceContext;
import brave.propagation.SamplingFlags;
import brave.propagation.TraceContextOrSamplingFlags;
import com.google.auto.value.AutoValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@AutoValue
public abstract class TraceContext
extends SamplingFlags {
    public static Builder newBuilder() {
        return new AutoValue_TraceContext.Builder().traceIdHigh(0L).debug(false).shared(false).extra(Collections.<Object>emptyList());
    }

    public abstract long traceIdHigh();

    public abstract long traceId();

    @Nullable
    public abstract Long parentId();

    @Override
    @Nullable
    public abstract Boolean sampled();

    public abstract long spanId();

    public abstract boolean shared();

    public abstract List<Object> extra();

    public abstract Builder toBuilder();

    public String traceIdString() {
        if (this.traceIdHigh() != 0L) {
            char[] result = new char[32];
            HexCodec.writeHexLong(result, 0, this.traceIdHigh());
            HexCodec.writeHexLong(result, 16, this.traceId());
            return new String(result);
        }
        char[] result = new char[16];
        HexCodec.writeHexLong(result, 0, this.traceId());
        return new String(result);
    }

    public String toString() {
        boolean traceHi = this.traceIdHigh() != 0L;
        char[] result = new char[(traceHi ? 3 : 2) * 16 + 1];
        int pos = 0;
        if (traceHi) {
            HexCodec.writeHexLong(result, pos, this.traceIdHigh());
            pos += 16;
        }
        HexCodec.writeHexLong(result, pos, this.traceId());
        pos += 16;
        result[pos++] = 47;
        HexCodec.writeHexLong(result, pos, this.spanId());
        return new String(result);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TraceContext)) {
            return false;
        }
        TraceContext that = (TraceContext)o;
        return this.traceIdHigh() == that.traceIdHigh() && this.traceId() == that.traceId() && this.spanId() == that.spanId();
    }

    public int hashCode() {
        long traceIdHigh = this.traceIdHigh();
        long traceId = this.traceId();
        long spanId = this.spanId();
        int h = 1;
        h *= 1000003;
        h ^= (int)(traceIdHigh >>> 32 ^ traceIdHigh);
        h *= 1000003;
        h ^= (int)(traceId >>> 32 ^ traceId);
        h *= 1000003;
        return h ^= (int)(spanId >>> 32 ^ spanId);
    }

    TraceContext() {
    }

    static List<Object> ensureImmutable(List<Object> extra) {
        if (extra == Collections.EMPTY_LIST) {
            return extra;
        }
        if (extra.size() == 1) {
            return Collections.singletonList(extra.get(0));
        }
        return Collections.unmodifiableList(new ArrayList<Object>(extra));
    }

    public static abstract class Builder {
        public abstract Builder traceIdHigh(long var1);

        public abstract Builder traceId(long var1);

        public abstract Builder parentId(@Nullable Long var1);

        public abstract Builder spanId(long var1);

        public abstract Builder sampled(@Nullable Boolean var1);

        public abstract Builder debug(boolean var1);

        public abstract Builder shared(boolean var1);

        public abstract Builder extra(List<Object> var1);

        abstract List<Object> extra();

        public abstract TraceContext autoBuild();

        public final TraceContext build() {
            return this.extra(TraceContext.ensureImmutable(this.extra())).autoBuild();
        }

        @Nullable
        abstract Boolean sampled();

        abstract boolean debug();

        Builder() {
        }
    }

    public static interface Extractor<C> {
        public TraceContextOrSamplingFlags extract(C var1);
    }

    public static interface Injector<C> {
        public void inject(TraceContext var1, C var2);
    }
}

