/*
 * Decompiled with CFR 0.152.
 */
package brave.propagation;

import brave.internal.Nullable;
import brave.propagation.SamplingFlags;
import brave.propagation.TraceContext;
import brave.propagation.TraceIdContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class TraceContextOrSamplingFlags {
    public static final TraceContextOrSamplingFlags EMPTY = TraceContextOrSamplingFlags.create(SamplingFlags.EMPTY);
    final int type;
    final SamplingFlags value;
    final List<Object> extra;

    public static Builder newBuilder() {
        return new Builder();
    }

    @Nullable
    public Boolean sampled() {
        return this.value.sampled();
    }

    public TraceContextOrSamplingFlags sampled(@Nullable Boolean sampled) {
        switch (this.type) {
            case 1: {
                return new TraceContextOrSamplingFlags(this.type, ((TraceContext)this.value).toBuilder().sampled(sampled).build(), this.extra);
            }
            case 2: {
                return new TraceContextOrSamplingFlags(this.type, ((TraceIdContext)this.value).toBuilder().sampled(sampled).build(), this.extra);
            }
            case 3: {
                return new TraceContextOrSamplingFlags(this.type, new SamplingFlags.Builder().sampled(sampled).debug(this.value.debug()).build(), this.extra);
            }
        }
        throw new AssertionError((Object)"programming error");
    }

    @Nullable
    public TraceContext context() {
        return this.type == 1 ? (TraceContext)this.value : null;
    }

    @Nullable
    public TraceIdContext traceIdContext() {
        return this.type == 2 ? (TraceIdContext)this.value : null;
    }

    @Nullable
    public SamplingFlags samplingFlags() {
        return this.type == 3 ? this.value : null;
    }

    public final List<Object> extra() {
        return this.extra;
    }

    public final Builder toBuilder() {
        Builder result = new Builder();
        result.type = this.type;
        result.value = this.value;
        result.extra = this.extra;
        return result;
    }

    public String toString() {
        return "{value=" + this.value + ", extra=" + this.extra + "}";
    }

    public static TraceContextOrSamplingFlags create(TraceContext context) {
        return new TraceContextOrSamplingFlags(1, context, Collections.<Object>emptyList());
    }

    public static TraceContextOrSamplingFlags create(TraceIdContext traceIdContext) {
        return new TraceContextOrSamplingFlags(2, traceIdContext, Collections.<Object>emptyList());
    }

    public static TraceContextOrSamplingFlags create(SamplingFlags flags) {
        return new TraceContextOrSamplingFlags(3, flags, Collections.<Object>emptyList());
    }

    @Deprecated
    public static TraceContextOrSamplingFlags create(TraceContext.Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder == null");
        }
        try {
            return TraceContextOrSamplingFlags.create(builder.build());
        }
        catch (IllegalStateException e) {
            SamplingFlags flags = new SamplingFlags.Builder().sampled(builder.sampled()).debug(builder.debug()).build();
            return TraceContextOrSamplingFlags.create(flags);
        }
    }

    TraceContextOrSamplingFlags(int type, SamplingFlags value, List<Object> extra) {
        if (value == null) {
            throw new NullPointerException("value == null");
        }
        if (extra == null) {
            throw new NullPointerException("extra == null");
        }
        this.type = type;
        this.value = value;
        this.extra = TraceContext.ensureImmutable(extra);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TraceContextOrSamplingFlags)) {
            return false;
        }
        TraceContextOrSamplingFlags that = (TraceContextOrSamplingFlags)o;
        return this.type == that.type && this.value.equals(that.value) && this.extra.equals(that.extra);
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.type;
        h *= 1000003;
        h ^= this.value.hashCode();
        h *= 1000003;
        return h ^= this.extra.hashCode();
    }

    public static final class Builder {
        int type;
        SamplingFlags value;
        List<Object> extra = Collections.emptyList();

        public final Builder context(TraceContext context) {
            if (context == null) {
                throw new NullPointerException("context == null");
            }
            this.type = 1;
            this.value = context;
            return this;
        }

        public final Builder traceIdContext(TraceIdContext traceIdContext) {
            if (traceIdContext == null) {
                throw new NullPointerException("traceIdContext == null");
            }
            this.type = 2;
            this.value = traceIdContext;
            return this;
        }

        public final Builder samplingFlags(SamplingFlags samplingFlags) {
            if (samplingFlags == null) {
                throw new NullPointerException("samplingFlags == null");
            }
            this.type = 3;
            this.value = samplingFlags;
            return this;
        }

        public final Builder extra(List<Object> extra) {
            if (extra == null) {
                throw new NullPointerException("extra == null");
            }
            this.extra = extra;
            return this;
        }

        public final Builder addExtra(Object extra) {
            if (extra == null) {
                throw new NullPointerException("extra == null");
            }
            if (!(this.extra instanceof ArrayList)) {
                this.extra = new ArrayList<Object>(this.extra);
            }
            this.extra.add(extra);
            return this;
        }

        public final TraceContextOrSamplingFlags build() {
            if (!this.extra.isEmpty() && this.type == 1) {
                TraceContext context = (TraceContext)this.value;
                if (context.extra().isEmpty()) {
                    context = context.toBuilder().extra(this.extra).build();
                    return new TraceContextOrSamplingFlags(this.type, context, Collections.<Object>emptyList());
                }
                ArrayList<Object> copy = new ArrayList<Object>(this.extra);
                copy.addAll(context.extra());
                context = context.toBuilder().extra(copy).build();
                return new TraceContextOrSamplingFlags(this.type, context, Collections.<Object>emptyList());
            }
            return new TraceContextOrSamplingFlags(this.type, this.value, this.extra);
        }

        Builder() {
        }
    }
}

