/*
 * Decompiled with CFR 0.152.
 */
package brave.internal.handler;

import brave.handler.FinishedSpanHandler;
import brave.handler.MutableSpan;
import brave.internal.Platform;
import brave.internal.Throwables;
import brave.propagation.TraceContext;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class NoopAwareFinishedSpanHandler
extends FinishedSpanHandler {
    final AtomicBoolean noop;
    boolean alwaysSampleLocal;
    boolean supportsOrphans;

    public static FinishedSpanHandler create(List<FinishedSpanHandler> handlers, AtomicBoolean noop) {
        if (handlers.isEmpty()) {
            return FinishedSpanHandler.NOOP;
        }
        if (handlers.size() == 1) {
            FinishedSpanHandler onlyHandler = handlers.get(0);
            return onlyHandler == FinishedSpanHandler.NOOP ? onlyHandler : new Single(onlyHandler, noop);
        }
        boolean alwaysSampleLocal = false;
        boolean supportsOrphans = false;
        for (FinishedSpanHandler handler : handlers) {
            if (handler.alwaysSampleLocal()) {
                alwaysSampleLocal = true;
            }
            if (!handler.supportsOrphans()) continue;
            supportsOrphans = true;
        }
        return new Multiple(handlers, noop, alwaysSampleLocal, supportsOrphans);
    }

    NoopAwareFinishedSpanHandler(AtomicBoolean noop, boolean alwaysSampleLocal, boolean supportsOrphans) {
        this.noop = noop;
        this.alwaysSampleLocal = alwaysSampleLocal;
        this.supportsOrphans = supportsOrphans;
    }

    @Override
    public final boolean handle(TraceContext context, MutableSpan span) {
        if (this.noop.get()) {
            return false;
        }
        try {
            return this.doHandle(context, span);
        }
        catch (Throwable t) {
            Throwables.propagateIfFatal(t);
            Platform.get().log("error handling {0}", context, t);
            return false;
        }
    }

    @Override
    public final boolean alwaysSampleLocal() {
        return this.alwaysSampleLocal;
    }

    @Override
    public final boolean supportsOrphans() {
        return this.supportsOrphans;
    }

    abstract boolean doHandle(TraceContext var1, MutableSpan var2);

    static final class Single
    extends NoopAwareFinishedSpanHandler {
        final FinishedSpanHandler delegate;

        Single(FinishedSpanHandler delegate, AtomicBoolean noop) {
            super(noop, delegate.alwaysSampleLocal(), delegate.supportsOrphans());
            this.delegate = delegate;
        }

        @Override
        boolean doHandle(TraceContext context, MutableSpan span) {
            return this.delegate.handle(context, span);
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    static final class Multiple
    extends NoopAwareFinishedSpanHandler {
        final FinishedSpanHandler[] handlers;

        Multiple(List<FinishedSpanHandler> handlers, AtomicBoolean noop, boolean alwaysSampleLocal, boolean supportsOrphans) {
            super(noop, alwaysSampleLocal, supportsOrphans);
            this.handlers = handlers.toArray(new FinishedSpanHandler[0]);
        }

        @Override
        boolean doHandle(TraceContext context, MutableSpan span) {
            for (FinishedSpanHandler handler : this.handlers) {
                if (handler.handle(context, span)) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return Arrays.toString(this.handlers);
        }
    }
}

