/*
 * Decompiled with CFR 0.152.
 */
package brave.propagation;

import brave.Request;
import brave.Span;
import brave.internal.Platform;
import brave.propagation.B3SingleFormat;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

public final class B3Propagation<K>
implements Propagation<K> {
    public static final Propagation.Factory FACTORY = B3Propagation.newFactoryBuilder().build();
    static final String TRACE_ID_NAME = "X-B3-TraceId";
    static final String SPAN_ID_NAME = "X-B3-SpanId";
    static final String PARENT_SPAN_ID_NAME = "X-B3-ParentSpanId";
    static final String SAMPLED_NAME = "X-B3-Sampled";
    static final String SAMPLED_MALFORMED = "Invalid input: expected 0 or 1 for X-B3-Sampled, but found '{0}'";
    static final String FLAGS_NAME = "X-B3-Flags";
    final K b3Key;
    final K traceIdKey;
    final K spanIdKey;
    final K parentSpanIdKey;
    final K sampledKey;
    final K debugKey;
    final List<K> fields;
    final Format[] injectFormats;
    final Map<Span.Kind, Format[]> kindToInjectFormats;

    public static FactoryBuilder newFactoryBuilder() {
        return new FactoryBuilder();
    }

    B3Propagation(Propagation.KeyFactory<K> keyFactory, Factory factory) {
        this.b3Key = keyFactory.create("b3");
        this.traceIdKey = keyFactory.create(TRACE_ID_NAME);
        this.spanIdKey = keyFactory.create(SPAN_ID_NAME);
        this.parentSpanIdKey = keyFactory.create(PARENT_SPAN_ID_NAME);
        this.sampledKey = keyFactory.create(SAMPLED_NAME);
        this.debugKey = keyFactory.create(FLAGS_NAME);
        this.injectFormats = new Format[]{factory.injectFormat};
        this.kindToInjectFormats = factory.kindToInjectFormats;
        boolean injectsMulti = factory.injectFormat.equals((Object)Format.MULTI);
        boolean injectsSingle = !injectsMulti;
        for (Format[] formats : this.kindToInjectFormats.values()) {
            for (Format format : formats) {
                if (format.equals((Object)Format.MULTI)) {
                    injectsMulti = true;
                }
                if (format.equals((Object)Format.MULTI)) continue;
                injectsSingle = true;
            }
        }
        this.fields = injectsMulti && injectsSingle ? Collections.unmodifiableList(Arrays.asList(this.b3Key, this.traceIdKey, this.spanIdKey, this.parentSpanIdKey, this.sampledKey, this.debugKey)) : (injectsMulti ? Collections.unmodifiableList(Arrays.asList(this.traceIdKey, this.spanIdKey, this.parentSpanIdKey, this.sampledKey, this.debugKey)) : Collections.singletonList(this.b3Key));
    }

    @Override
    public List<K> keys() {
        return this.fields;
    }

    @Override
    public <C> TraceContext.Injector<C> injector(Propagation.Setter<C, K> setter) {
        if (setter == null) {
            throw new NullPointerException("setter == null");
        }
        return new B3Injector<C, K>(this, setter);
    }

    @Override
    public <C> TraceContext.Extractor<C> extractor(Propagation.Getter<C, K> getter) {
        if (getter == null) {
            throw new NullPointerException("getter == null");
        }
        return new B3Extractor<C, K>(this, getter);
    }

    public static final class FactoryBuilder {
        Format injectFormat = Format.MULTI;
        final EnumMap<Span.Kind, Format[]> kindToInjectFormats = new EnumMap(Span.Kind.class);

        FactoryBuilder() {
            this.kindToInjectFormats.put(Span.Kind.CLIENT, new Format[]{Format.MULTI});
            this.kindToInjectFormats.put(Span.Kind.SERVER, new Format[]{Format.MULTI});
            this.kindToInjectFormats.put(Span.Kind.PRODUCER, new Format[]{Format.SINGLE_NO_PARENT});
            this.kindToInjectFormats.put(Span.Kind.CONSUMER, new Format[]{Format.SINGLE_NO_PARENT});
        }

        public FactoryBuilder injectFormat(Format format) {
            if (format == null) {
                throw new NullPointerException("format == null");
            }
            this.injectFormat = format;
            return this;
        }

        public FactoryBuilder injectFormat(Span.Kind kind, Format format) {
            if (kind == null) {
                throw new NullPointerException("kind == null");
            }
            if (format == null) {
                throw new NullPointerException("format == null");
            }
            this.kindToInjectFormats.put(kind, new Format[]{format});
            return this;
        }

        public FactoryBuilder injectFormats(Span.Kind kind, Format format1, Format format2) {
            if (kind == null) {
                throw new NullPointerException("kind == null");
            }
            if (format1 == null) {
                throw new NullPointerException("format1 == null");
            }
            if (format2 == null) {
                throw new NullPointerException("format2 == null");
            }
            if (format1.equals((Object)format2)) {
                throw new IllegalArgumentException("format1 == format2");
            }
            if (!format1.equals((Object)Format.MULTI) && !format2.equals((Object)Format.MULTI)) {
                throw new IllegalArgumentException("One argument must be Format.MULTI");
            }
            this.kindToInjectFormats.put(kind, new Format[]{format1, format2});
            return this;
        }

        public Propagation.Factory build() {
            return new Factory(this);
        }
    }

    public static enum Format {
        MULTI,
        SINGLE,
        SINGLE_NO_PARENT;

    }

    static final class Factory
    extends Propagation.Factory {
        final Format injectFormat;
        final Map<Span.Kind, Format[]> kindToInjectFormats;

        Factory(FactoryBuilder builder) {
            this.injectFormat = builder.injectFormat;
            this.kindToInjectFormats = new EnumMap<Span.Kind, Format[]>(builder.kindToInjectFormats);
        }

        public <K1> Propagation<K1> create(Propagation.KeyFactory<K1> keyFactory) {
            return new B3Propagation<K1>(keyFactory, this);
        }

        @Override
        public boolean supportsJoin() {
            return true;
        }

        public String toString() {
            return "B3PropagationFactory";
        }
    }

    static final class B3Injector<C, K>
    implements TraceContext.Injector<C> {
        final B3Propagation<K> propagation;
        final Propagation.Setter<C, K> setter;

        B3Injector(B3Propagation<K> propagation, Propagation.Setter<C, K> setter) {
            this.propagation = propagation;
            this.setter = setter;
        }

        @Override
        public void inject(TraceContext context, C carrier) {
            Format[] formats = this.propagation.injectFormats;
            if (carrier instanceof Request) {
                Span.Kind kind = ((Request)carrier).spanKind();
                formats = this.propagation.kindToInjectFormats.get((Object)kind);
            }
            block5: for (Format format : formats) {
                switch (format) {
                    case SINGLE: {
                        this.setter.put(carrier, this.propagation.b3Key, B3SingleFormat.writeB3SingleFormat(context));
                        continue block5;
                    }
                    case SINGLE_NO_PARENT: {
                        this.setter.put(carrier, this.propagation.b3Key, B3SingleFormat.writeB3SingleFormatWithoutParentId(context));
                        continue block5;
                    }
                    case MULTI: {
                        this.injectMulti(context, carrier);
                    }
                }
            }
        }

        void injectMulti(TraceContext context, C carrier) {
            this.setter.put(carrier, this.propagation.traceIdKey, context.traceIdString());
            this.setter.put(carrier, this.propagation.spanIdKey, context.spanIdString());
            String parentId = context.parentIdString();
            if (parentId != null) {
                this.setter.put(carrier, this.propagation.parentSpanIdKey, parentId);
            }
            if (context.debug()) {
                this.setter.put(carrier, this.propagation.debugKey, "1");
            } else if (context.sampled() != null) {
                this.setter.put(carrier, this.propagation.sampledKey, context.sampled() != false ? "1" : "0");
            }
        }
    }

    static final class B3Extractor<C, K>
    implements TraceContext.Extractor<C> {
        final B3Propagation<K> propagation;
        final Propagation.Getter<C, K> getter;

        B3Extractor(B3Propagation<K> propagation, Propagation.Getter<C, K> getter) {
            this.propagation = propagation;
            this.getter = getter;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public TraceContextOrSamplingFlags extract(C carrier) {
            Boolean sampledV;
            TraceContextOrSamplingFlags extracted;
            if (carrier == null) {
                throw new NullPointerException("carrier == null");
            }
            String b3 = this.getter.get(carrier, this.propagation.b3Key);
            TraceContextOrSamplingFlags traceContextOrSamplingFlags = extracted = b3 != null ? B3SingleFormat.parseB3SingleFormat(b3) : null;
            if (extracted != null) {
                return extracted;
            }
            String sampled = this.getter.get(carrier, this.propagation.sampledKey);
            if (sampled == null) {
                sampledV = null;
            } else if (sampled.length() == 1) {
                char sampledC = sampled.charAt(0);
                if (sampledC == '1') {
                    sampledV = true;
                } else {
                    if (sampledC != '0') {
                        Platform.get().log(B3Propagation.SAMPLED_MALFORMED, sampled, null);
                        return TraceContextOrSamplingFlags.EMPTY;
                    }
                    sampledV = false;
                }
            } else if (sampled.equalsIgnoreCase("true")) {
                sampledV = true;
            } else {
                if (!sampled.equalsIgnoreCase("false")) {
                    Platform.get().log(B3Propagation.SAMPLED_MALFORMED, sampled, null);
                    return TraceContextOrSamplingFlags.EMPTY;
                }
                sampledV = false;
            }
            boolean debug = "1".equals(this.getter.get(carrier, this.propagation.debugKey));
            String traceIdString = this.getter.get(carrier, this.propagation.traceIdKey);
            if (traceIdString == null) {
                return TraceContextOrSamplingFlags.create(sampledV, debug);
            }
            TraceContext.Builder result = TraceContext.newBuilder();
            if (result.parseTraceId(traceIdString, this.propagation.traceIdKey) && result.parseSpanId(this.getter, carrier, this.propagation.spanIdKey) && result.parseParentId(this.getter, carrier, this.propagation.parentSpanIdKey)) {
                if (sampledV != null) {
                    result.sampled((boolean)sampledV);
                }
                if (debug) {
                    result.debug(true);
                }
                return TraceContextOrSamplingFlags.create(result.build());
            }
            return TraceContextOrSamplingFlags.EMPTY;
        }
    }
}

