/*
 * Decompiled with CFR 0.152.
 */
package javax.money;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.money.AbstractContext;

public abstract class AbstractContextBuilder<B extends AbstractContextBuilder, C extends AbstractContext> {
    final Map<String, Object> data = new HashMap<String, Object>();

    public B importContext(AbstractContext context, boolean overwriteDuplicates) {
        for (Map.Entry<String, Object> en : context.data.entrySet()) {
            if (overwriteDuplicates) {
                this.data.put(en.getKey(), en.getValue());
                continue;
            }
            this.data.putIfAbsent(en.getKey(), en.getValue());
        }
        return (B)this;
    }

    public B importContext(AbstractContext context) {
        Objects.requireNonNull(context);
        return this.importContext(context, false);
    }

    public B set(String key, int value) {
        this.data.put(key, value);
        return (B)this;
    }

    public B set(String key, boolean value) {
        this.data.put(key, value);
        return (B)this;
    }

    public B set(String key, long value) {
        this.data.put(key, value);
        return (B)this;
    }

    public B set(String key, float value) {
        this.data.put(key, Float.valueOf(value));
        return (B)this;
    }

    public B set(String key, double value) {
        this.data.put(key, value);
        return (B)this;
    }

    public B set(String key, char value) {
        this.data.put(key, Character.valueOf(value));
        return (B)this;
    }

    public B set(Object value) {
        this.data.put(value.getClass().getName(), Objects.requireNonNull(value));
        return (B)this;
    }

    public B set(String key, Object value) {
        this.data.put(key, Objects.requireNonNull(value));
        return (B)this;
    }

    public <T> B set(Class<T> key, T value) {
        B old = this.set(key.getName(), Objects.requireNonNull(value));
        if (old != null && old.getClass().isAssignableFrom(value.getClass())) {
            return (B)((AbstractContextBuilder)old);
        }
        return (B)this;
    }

    public B setProviderName(String provider) {
        this.set("provider", Objects.requireNonNull(provider));
        return (B)this;
    }

    public B removeAttributes(String ... keys) {
        for (String key : keys) {
            this.data.remove(key);
        }
        return (B)this;
    }

    public abstract C build();

    public String toString() {
        return this.getClass().getSimpleName() + " [attributes:\n" + new TreeMap<String, Object>(this.data).toString() + ']';
    }
}

