/*
 * Decompiled with CFR 0.152.
 */
package com.clarkware.junitperf;

import com.clarkware.junitperf.MockTestFactoryTest;
import com.clarkware.junitperf.TestFactory;
import com.clarkware.junitperf.TestMethodFactory;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestFactoryTest
extends TestCase {
    private TestSuite _allMethodsTestSuite;
    private TestSuite _oneMethodTestSuite;
    private Class _testClass = class$com$clarkware$junitperf$MockTestFactoryTest == null ? (class$com$clarkware$junitperf$MockTestFactoryTest = TestFactoryTest.class$("com.clarkware.junitperf.MockTestFactoryTest")) : class$com$clarkware$junitperf$MockTestFactoryTest;
    static /* synthetic */ Class class$com$clarkware$junitperf$MockTestFactoryTest;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$clarkware$junitperf$TestFactoryTest;

    public TestFactoryTest(String string) {
        super(string);
        this._allMethodsTestSuite = new TestSuite(this._testClass);
        this._oneMethodTestSuite = new TestSuite();
        this._oneMethodTestSuite.addTest((Test)new MockTestFactoryTest("testSuccess"));
    }

    public void testAllTestMethods() {
        TestFactory testFactory = new TestFactory(this._testClass);
        Assert.assertEquals((int)2, (int)testFactory.countTestCases());
        this.assertEqualsTestSuite((Test)this._allMethodsTestSuite, testFactory.getTest());
        TestResult testResult = new TestResult();
        testFactory.run(testResult);
        Assert.assertEquals((int)2, (int)testResult.runCount());
        Assert.assertEquals((int)0, (int)testResult.errorCount());
        Assert.assertEquals((int)1, (int)testResult.failureCount());
    }

    public void testAllTestMethodsSameSuiteForSameThread() {
        TestFactory testFactory = new TestFactory(this._testClass);
        Test test = testFactory.getTest();
        Test test2 = testFactory.getTest();
        Assert.assertSame((Object)test, (Object)test2);
        this.assertEqualsTestSuite((Test)this._allMethodsTestSuite, test);
        this.assertEqualsTestSuite((Test)this._allMethodsTestSuite, test2);
    }

    public void testAllTestMethodsDifferentSuiteForDifferentThread() {
        TestFactory testFactory = new TestFactory(this._testClass);
        MockRunnable mockRunnable = new MockRunnable(testFactory);
        MockRunnable mockRunnable2 = new MockRunnable(testFactory);
        Thread thread = new Thread(mockRunnable);
        Thread thread2 = new Thread(mockRunnable2);
        thread.start();
        thread2.start();
        this.sleep();
        Test test = mockRunnable.getTest();
        Test test2 = mockRunnable2.getTest();
        Assert.assertTrue((test != test2 ? 1 : 0) != 0);
        this.assertEqualsTestSuite((Test)this._allMethodsTestSuite, test);
        this.assertEqualsTestSuite((Test)this._allMethodsTestSuite, test2);
    }

    public void testOneTestMethodSuccess() {
        TestMethodFactory testMethodFactory = new TestMethodFactory(this._testClass, "testSuccess");
        Assert.assertEquals((int)1, (int)testMethodFactory.countTestCases());
        this.assertEqualsTestSuite((Test)this._oneMethodTestSuite, testMethodFactory.getTest());
        TestResult testResult = new TestResult();
        testMethodFactory.run(testResult);
        Assert.assertEquals((int)1, (int)testResult.runCount());
        Assert.assertEquals((int)0, (int)testResult.errorCount());
        Assert.assertEquals((int)0, (int)testResult.failureCount());
    }

    public void testOneTestMethodFailure() {
        TestMethodFactory testMethodFactory = new TestMethodFactory(this._testClass, "testFailure");
        Assert.assertEquals((int)1, (int)testMethodFactory.countTestCases());
        this.assertEqualsTestSuite((Test)this._oneMethodTestSuite, testMethodFactory.getTest());
        TestResult testResult = new TestResult();
        testMethodFactory.run(testResult);
        Assert.assertEquals((int)1, (int)testResult.runCount());
        Assert.assertEquals((int)0, (int)testResult.errorCount());
        Assert.assertEquals((int)1, (int)testResult.failureCount());
    }

    public void testOneTestMethodNoSuchMethod() {
        TestMethodFactory testMethodFactory = new TestMethodFactory(this._testClass, "testFoo");
        TestResult testResult = new TestResult();
        testMethodFactory.run(testResult);
        Assert.assertEquals((int)1, (int)testResult.runCount());
        Assert.assertEquals((int)0, (int)testResult.errorCount());
        Assert.assertEquals((int)1, (int)testResult.failureCount());
    }

    public void testOneTestMethodSameSuiteForSameThread() {
        TestMethodFactory testMethodFactory = new TestMethodFactory(this._testClass, "testSuccess");
        Test test = testMethodFactory.getTest();
        Test test2 = testMethodFactory.getTest();
        Assert.assertSame((Object)test, (Object)test2);
        this.assertEqualsTestSuite((Test)this._oneMethodTestSuite, test);
        this.assertEqualsTestSuite((Test)this._oneMethodTestSuite, test2);
    }

    public void testOneTestMethodDifferentSuiteForDifferentThread() {
        TestMethodFactory testMethodFactory = new TestMethodFactory(this._testClass, "testSuccess");
        MockRunnable mockRunnable = new MockRunnable(testMethodFactory);
        MockRunnable mockRunnable2 = new MockRunnable(testMethodFactory);
        Thread thread = new Thread(mockRunnable);
        Thread thread2 = new Thread(mockRunnable2);
        thread.start();
        thread2.start();
        this.sleep();
        Test test = mockRunnable.getTest();
        Test test2 = mockRunnable2.getTest();
        Assert.assertTrue((test != test2 ? 1 : 0) != 0);
        this.assertEqualsTestSuite((Test)this._oneMethodTestSuite, test);
        this.assertEqualsTestSuite((Test)this._oneMethodTestSuite, test2);
    }

    public void testClassNotATestCase() {
        try {
            TestFactory testFactory = new TestFactory(class$java$lang$String == null ? (class$java$lang$String = TestFactoryTest.class$("java.lang.String")) : class$java$lang$String);
            Assert.fail((String)"Class not assignable to TestCase!");
            testFactory = new TestMethodFactory(class$java$lang$String == null ? (class$java$lang$String = TestFactoryTest.class$("java.lang.String")) : class$java$lang$String, "");
            Assert.fail((String)"Class not assignable to TestCase!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected void sleep() {
        try {
            Thread.sleep(250L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void assertEqualsTestSuite(Test test, Test test2) {
        Assert.assertTrue((boolean)(test instanceof TestSuite));
        Assert.assertTrue((boolean)(test2 instanceof TestSuite));
        TestSuite testSuite = (TestSuite)test;
        TestSuite testSuite2 = (TestSuite)test2;
        Assert.assertEquals((int)testSuite.countTestCases(), (int)testSuite2.countTestCases());
        Assert.assertEquals((String)testSuite.getName(), (String)testSuite2.getName());
    }

    public static Test suite() {
        return new TestSuite(class$com$clarkware$junitperf$TestFactoryTest == null ? (class$com$clarkware$junitperf$TestFactoryTest = TestFactoryTest.class$("com.clarkware.junitperf.TestFactoryTest")) : class$com$clarkware$junitperf$TestFactoryTest);
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)TestFactoryTest.suite());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class MockRunnable
    implements Runnable {
        private TestFactory _factory;
        private Test _test;

        public MockRunnable(TestFactory testFactory) {
            this._factory = testFactory;
        }

        public void run() {
            this._test = this._factory.getTest();
        }

        public Test getTest() {
            return this._test;
        }
    }
}

