/*
 * Decompiled with CFR 0.152.
 */
package net.bramp.ffmpeg.nut;

import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.TreeMap;
import net.bramp.ffmpeg.nut.FrameCode;
import net.bramp.ffmpeg.nut.NutDataInputStream;
import net.bramp.ffmpeg.nut.NutReader;
import net.bramp.ffmpeg.nut.Stream;
import org.apache.commons.lang3.math.Fraction;

public class Frame {
    static final long FLAG_KEY = 1L;
    static final long FLAG_EOR = 2L;
    static final long FLAG_CODED_PTS = 8L;
    static final long FLAG_STREAM_ID = 16L;
    static final long FLAG_SIZE_MSB = 32L;
    static final long FLAG_CHECKSUM = 64L;
    static final long FLAG_RESERVED = 128L;
    static final long FLAG_SM_DATA = 256L;
    static final long FLAG_HEADER_IDX = 1024L;
    static final long FLAG_MATCH_TIME = 2048L;
    static final long FLAG_CODED = 4096L;
    static final long FLAG_INVALID = 8192L;
    Stream stream;
    long flags;
    long pts;
    byte[] data;
    Map<String, Object> sideData;
    Map<String, Object> metaData;

    protected Map<String, Object> readMetaData(NutDataInputStream in) throws IOException {
        TreeMap<String, Object> data = new TreeMap<String, Object>();
        long count = in.readVarLong();
        int i = 0;
        while ((long)i < count) {
            Object value;
            String name = new String(in.readVarArray(), StandardCharsets.UTF_8);
            long type = in.readSignedVarInt();
            if (type == -1L) {
                value = new String(in.readVarArray(), StandardCharsets.UTF_8);
            } else if (type == -2L) {
                String k = new String(in.readVarArray(), StandardCharsets.UTF_8);
                String v = new String(in.readVarArray(), StandardCharsets.UTF_8);
                value = k + "=" + v;
            } else if (type == -3L) {
                value = in.readSignedVarInt();
            } else if (type == -4L) {
                value = in.readVarLong();
            } else if (type < -4L) {
                long denominator = -type - 4L;
                long numerator = in.readSignedVarInt();
                value = Fraction.getFraction((int)((int)numerator), (int)((int)denominator));
            } else {
                value = type;
            }
            data.put(name, value);
            ++i;
        }
        return data;
    }

    public void read(NutReader nut, NutDataInputStream in, int code) throws IOException {
        int stream_id;
        if (code == 78) {
            throw new IOException("Illegal frame code: " + code);
        }
        FrameCode fc = nut.header.frameCodes.get(code);
        this.flags = fc.flags;
        if ((this.flags & 0x2000L) == 8192L) {
            throw new IOException("Using invalid framecode: " + code);
        }
        if ((this.flags & 0x1000L) == 4096L) {
            long coded_flags = in.readVarLong();
            this.flags ^= coded_flags;
        }
        int size = fc.dataSizeLsb;
        int header_idx = fc.headerIdx;
        int frame_res = fc.reservedCount;
        if ((this.flags & 0x10L) == 16L) {
            stream_id = in.readVarInt();
            if (stream_id >= nut.streams.size()) {
                throw new IOException("Illegal stream id value " + stream_id + " must be < " + nut.streams.size());
            }
        } else {
            stream_id = fc.streamId;
        }
        this.stream = nut.streams.get(stream_id);
        if ((this.flags & 8L) == 8L) {
            long coded_pts = in.readVarLong();
            if (coded_pts < (long)(1 << this.stream.header.msbPtsShift)) {
                long mask = (1L << this.stream.header.msbPtsShift) - 1L;
                long delta = this.stream.last_pts - mask / 2L;
                this.pts = (coded_pts - delta & mask) + delta;
            } else {
                this.pts = coded_pts - (1L << this.stream.header.msbPtsShift);
            }
        } else {
            this.pts = this.stream.last_pts + fc.ptsDelta;
        }
        this.stream.last_pts = this.pts;
        if ((this.flags & 0x20L) == 32L) {
            int data_size_msb = in.readVarInt();
            size += fc.dataSizeMul * data_size_msb;
        }
        if ((this.flags & 0x800L) == 2048L) {
            fc.matchTimeDelta = in.readSignedVarInt();
        }
        if ((this.flags & 0x400L) == 1024L && (header_idx = in.readVarInt()) >= nut.header.elision.size()) {
            throw new IOException("Illegal header index " + header_idx + " must be < " + nut.header.elision.size());
        }
        if ((this.flags & 0x80L) == 128L) {
            frame_res = in.readVarInt();
        }
        for (int i = 0; i < frame_res; ++i) {
            in.readVarLong();
        }
        if ((this.flags & 0x40L) == 64L) {
            long i = in.readInt();
        }
        if (size > 4096) {
            header_idx = 0;
        }
        if ((this.flags & 0x100L) == 256L) {
            if (nut.header.version < 4L) {
                throw new IOException("Frame SM Data not allowed in version 4 or less");
            }
            long pos = in.offset();
            this.sideData = this.readMetaData(in);
            this.metaData = this.readMetaData(in);
            size = (int)((long)size - (in.offset() - pos));
        } else {
            this.sideData = null;
            this.metaData = null;
        }
        this.data = new byte[size];
        byte[] elision = nut.header.elision.get(header_idx);
        System.arraycopy(elision, 0, this.data, 0, elision.length);
        in.readFully(this.data, elision.length, size - elision.length);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.stream.header.id).add("pts", this.pts).add("data", (Object)String.format("(%d bytes)", this.data.length)).toString();
    }
}

