/*
 * Decompiled with CFR 0.152.
 */
package net.bramp.ffmpeg.progress;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.CountDownLatch;
import net.bramp.ffmpeg.progress.AbstractSocketProgressParser;
import net.bramp.ffmpeg.progress.ProgressListener;
import net.bramp.ffmpeg.progress.TcpProgressParserRunnable;

public class TcpProgressParser
extends AbstractSocketProgressParser {
    final ServerSocket server;
    final URI address;

    public TcpProgressParser(ProgressListener listener) throws IOException, URISyntaxException {
        this(listener, 0, InetAddress.getLoopbackAddress());
    }

    public TcpProgressParser(ProgressListener listener, int port, InetAddress addr) throws IOException, URISyntaxException {
        super(listener);
        this.server = new ServerSocket(port, 0, addr);
        this.address = TcpProgressParser.createUri("tcp", this.server.getInetAddress(), this.server.getLocalPort());
    }

    @Override
    public synchronized void stop() throws IOException {
        if (this.server.isClosed()) {
            return;
        }
        this.server.close();
        super.stop();
    }

    @Override
    protected String getThreadName() {
        return "TcpProgressParser";
    }

    @Override
    protected Runnable getRunnable(CountDownLatch startSignal) {
        return new TcpProgressParserRunnable(this.parser, this.server, startSignal);
    }

    @Override
    public URI getUri() {
        return this.address;
    }
}

