/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.server.metric;

import io.grpc.BindableService;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.ServerServiceDefinition;
import io.grpc.Status;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.devh.boot.grpc.common.metric.AbstractMetricCollectingInterceptor;
import net.devh.boot.grpc.common.metric.MetricUtils;
import net.devh.boot.grpc.server.interceptor.GrpcGlobalServerInterceptor;
import net.devh.boot.grpc.server.metric.MetricCollectingServerCall;
import net.devh.boot.grpc.server.metric.MetricCollectingServerCallListener;
import org.springframework.core.annotation.Order;

@GrpcGlobalServerInterceptor
@Order(value=2500)
public class MetricCollectingServerInterceptor
extends AbstractMetricCollectingInterceptor
implements ServerInterceptor {
    public MetricCollectingServerInterceptor(MeterRegistry registry) {
        super(registry);
    }

    public MetricCollectingServerInterceptor(MeterRegistry registry, UnaryOperator<Counter.Builder> counterCustomizer, UnaryOperator<Timer.Builder> timerCustomizer, Status.Code ... eagerInitializedCodes) {
        super(registry, counterCustomizer, timerCustomizer, eagerInitializedCodes);
    }

    public void preregisterService(BindableService service) {
        this.preregisterService(service.bindService());
    }

    public void preregisterService(ServerServiceDefinition serviceDefinition) {
        this.preregisterService(serviceDefinition.getServiceDescriptor());
    }

    protected Counter newRequestCounterFor(MethodDescriptor<?, ?> method) {
        return ((Counter.Builder)this.counterCustomizer.apply(MetricUtils.prepareCounterFor(method, (String)"grpc.server.requests.received", (String)"The total number of requests received"))).register(this.registry);
    }

    protected Counter newResponseCounterFor(MethodDescriptor<?, ?> method) {
        return ((Counter.Builder)this.counterCustomizer.apply(MetricUtils.prepareCounterFor(method, (String)"grpc.server.responses.sent", (String)"The total number of responses sent"))).register(this.registry);
    }

    protected Function<Status.Code, Timer> newTimerFunction(MethodDescriptor<?, ?> method) {
        return this.asTimerFunction(() -> (Timer.Builder)this.timerCustomizer.apply(MetricUtils.prepareTimerFor((MethodDescriptor)method, (String)"grpc.server.processing.duration", (String)"The total time taken for the server to complete the call")));
    }

    public <Q, A> ServerCall.Listener<Q> interceptCall(ServerCall<Q, A> call, Metadata requestHeaders, ServerCallHandler<Q, A> next) {
        AbstractMetricCollectingInterceptor.MetricSet metrics = this.metricsFor(call.getMethodDescriptor());
        MetricCollectingServerCall<Q, A> monitoringCall = new MetricCollectingServerCall<Q, A>(call, this.registry, metrics.getResponseCounter(), metrics.getTimerFunction());
        return new MetricCollectingServerCallListener(next.startCall(monitoringCall, requestHeaders), metrics.getRequestCounter());
    }
}

