/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.core.beans;

import java.security.ProtectionDomain;
import net.dreamlu.mica.core.beans.MicaBeanMapEmitter;
import net.dreamlu.mica.core.beans.MicaBeanMapKey;
import org.springframework.asm.ClassVisitor;
import org.springframework.cglib.beans.BeanMap;
import org.springframework.cglib.core.AbstractClassGenerator;
import org.springframework.cglib.core.ReflectUtils;

public abstract class MicaBeanMap
extends BeanMap {
    private static final String BEAN_NAME_PREFIX = MicaBeanMap.class.getName();

    protected MicaBeanMap() {
    }

    protected MicaBeanMap(Object bean) {
        super(bean);
    }

    public static MicaBeanMap create(Object bean) {
        MicaGenerator gen = new MicaGenerator();
        gen.setBean(bean);
        gen.setContextClass(MicaBeanMap.class);
        gen.setNamePrefix(BEAN_NAME_PREFIX);
        gen.setUseCache(true);
        return gen.create();
    }

    public abstract MicaBeanMap newInstance(Object var1);

    public static class MicaGenerator
    extends AbstractClassGenerator {
        private static final AbstractClassGenerator.Source SOURCE = new AbstractClassGenerator.Source(BEAN_NAME_PREFIX);
        private Object bean;
        private Class beanClass;
        private int require;

        public MicaGenerator() {
            super(SOURCE);
        }

        public void setBean(Object bean) {
            this.bean = bean;
            if (bean != null) {
                this.beanClass = bean.getClass();
            }
        }

        public void setBeanClass(Class beanClass) {
            this.beanClass = beanClass;
        }

        public void setRequire(int require) {
            this.require = require;
        }

        protected ClassLoader getDefaultClassLoader() {
            return this.beanClass.getClassLoader();
        }

        protected ProtectionDomain getProtectionDomain() {
            return ReflectUtils.getProtectionDomain((Class)this.beanClass);
        }

        public MicaBeanMap create() {
            if (this.beanClass == null) {
                throw new IllegalArgumentException("Class of bean unknown");
            }
            MicaBeanMapKey key = new MicaBeanMapKey(this.beanClass, this.require);
            return (MicaBeanMap)((Object)super.create((Object)key));
        }

        public void setNamePrefix(String namePrefix) {
            super.setNamePrefix(namePrefix);
        }

        public void generateClass(ClassVisitor v) throws Exception {
            new MicaBeanMapEmitter(v, this.getClassName(), this.beanClass, this.require);
        }

        protected Object firstInstance(Class type) {
            return ((BeanMap)ReflectUtils.newInstance((Class)type)).newInstance(this.bean);
        }

        protected Object nextInstance(Object instance) {
            return ((BeanMap)instance).newInstance(this.bean);
        }
    }
}

