/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.core.utils;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.dreamlu.mica.core.utils.Base64Util;
import net.dreamlu.mica.core.utils.Exceptions;
import net.dreamlu.mica.core.utils.HexUtil;
import net.dreamlu.mica.core.utils.Pkcs7Encoder;
import net.dreamlu.mica.core.utils.StringUtil;
import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;

public class AesUtil {
    public static String genAesKey() {
        try {
            KeyGenerator keyGen = KeyGenerator.getInstance("AES");
            keyGen.init(128);
            byte[] aesKey = keyGen.generateKey().getEncoded();
            return HexUtil.encodeToString(aesKey);
        }
        catch (NoSuchAlgorithmException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static SecretKeySpec genMySqlAesKey(byte[] key) {
        byte[] finalKey = new byte[16];
        int i = 0;
        for (byte b : key) {
            int n = i++ % 16;
            finalKey[n] = (byte)(finalKey[n] ^ b);
        }
        return new SecretKeySpec(finalKey, "AES");
    }

    public static SecretKeySpec genMySqlAesKey(String key) {
        return AesUtil.genMySqlAesKey(key.getBytes(StandardCharsets.UTF_8));
    }

    public static String encryptToHex(String content, String aesTextKey) {
        return HexUtil.encodeToString(AesUtil.encrypt(content, aesTextKey));
    }

    public static String encryptToHex(byte[] content, String aesTextKey) {
        return HexUtil.encodeToString(AesUtil.encrypt(content, aesTextKey));
    }

    public static String encryptToBase64(String content, String aesTextKey) {
        return Base64Util.encodeToString(AesUtil.encrypt(content, aesTextKey));
    }

    public static String encryptToBase64(byte[] content, String aesTextKey) {
        return Base64Util.encodeToString(AesUtil.encrypt(content, aesTextKey));
    }

    public static byte[] encrypt(String content, String aesTextKey) {
        return AesUtil.encrypt(content.getBytes(StandardCharsets.UTF_8), aesTextKey);
    }

    public static byte[] encrypt(String content, Charset charset, String aesTextKey) {
        return AesUtil.encrypt(content.getBytes(charset), aesTextKey);
    }

    public static byte[] encrypt(byte[] content, String aesTextKey) {
        return AesUtil.encrypt(content, Objects.requireNonNull(aesTextKey).getBytes(StandardCharsets.UTF_8));
    }

    public static @Nullable String decryptFormHexToString(@Nullable String content, String aesTextKey) {
        byte[] hexBytes = AesUtil.decryptFormHex(content, aesTextKey);
        if (hexBytes == null) {
            return null;
        }
        return new String(hexBytes, StandardCharsets.UTF_8);
    }

    public static byte @Nullable [] decryptFormHex(@Nullable String content, String aesTextKey) {
        if (StringUtil.isBlank(content)) {
            return null;
        }
        return AesUtil.decryptFormHex(content.getBytes(StandardCharsets.UTF_8), aesTextKey);
    }

    public static byte[] decryptFormHex(byte[] content, String aesTextKey) {
        return AesUtil.decrypt(HexUtil.decode(content), aesTextKey);
    }

    public static @Nullable String decryptFormBase64ToString(@Nullable String content, String aesTextKey) {
        byte[] hexBytes = AesUtil.decryptFormBase64(content, aesTextKey);
        if (hexBytes == null) {
            return null;
        }
        return new String(hexBytes, StandardCharsets.UTF_8);
    }

    public static byte @Nullable [] decryptFormBase64(@Nullable String content, String aesTextKey) {
        if (StringUtil.isBlank(content)) {
            return null;
        }
        return AesUtil.decryptFormBase64(content.getBytes(StandardCharsets.UTF_8), aesTextKey);
    }

    public static byte[] decryptFormBase64(byte[] content, String aesTextKey) {
        return AesUtil.decrypt(Base64Util.decode(content), aesTextKey);
    }

    public static String decryptToString(byte[] content, String aesTextKey) {
        return new String(AesUtil.decrypt(content, aesTextKey), StandardCharsets.UTF_8);
    }

    public static byte[] decrypt(byte[] content, String aesTextKey) {
        return AesUtil.decrypt(content, Objects.requireNonNull(aesTextKey).getBytes(StandardCharsets.UTF_8));
    }

    public static byte[] encrypt(byte[] content, byte[] aesKey) {
        return AesUtil.aes(Pkcs7Encoder.encode(content), aesKey, 1);
    }

    public static byte[] decrypt(byte[] encrypted, byte[] aesKey) {
        return Pkcs7Encoder.decode(AesUtil.aes(encrypted, aesKey, 2));
    }

    private static byte[] aes(byte[] encrypted, byte[] aesKey, int mode) {
        Assert.isTrue((aesKey.length == 32 ? 1 : 0) != 0, (String)"IllegalAesKey, aesKey's length must be 32");
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            SecretKeySpec keySpec = new SecretKeySpec(aesKey, "AES");
            IvParameterSpec iv = new IvParameterSpec(Arrays.copyOfRange(aesKey, 0, 16));
            cipher.init(mode, (Key)keySpec, iv);
            return cipher.doFinal(encrypted);
        }
        catch (Exception e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static byte[] encryptMysql(String input, String aesKey) {
        return (byte[])AesUtil.encryptMysql(input, aesKey, Function.identity());
    }

    public static <T> T encryptMysql(String input, String aesKey, Function<byte[], T> mapper) {
        try {
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(1, AesUtil.genMySqlAesKey(aesKey));
            byte[] bytes = cipher.doFinal(input.getBytes(StandardCharsets.UTF_8));
            return mapper.apply(bytes);
        }
        catch (Exception e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static byte[] decryptMysql(String input, String aesKey) {
        return AesUtil.decryptMysql(input, txt -> txt.getBytes(StandardCharsets.UTF_8), aesKey);
    }

    public static byte[] decryptMysql(String input, Function<String, byte[]> inputMapper, String aesKey) {
        try {
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(2, AesUtil.genMySqlAesKey(aesKey));
            return cipher.doFinal(inputMapper.apply(input));
        }
        catch (Exception e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static String decryptMysqlToString(String input, Function<String, byte[]> inputMapper, String aesKey) {
        return new String(AesUtil.decryptMysql(input, inputMapper, aesKey), StandardCharsets.UTF_8);
    }

    public static String decryptMysqlToString(String input, String aesKey) {
        return AesUtil.decryptMysqlToString(input, txt -> txt.getBytes(StandardCharsets.UTF_8), aesKey);
    }
}

