/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.core.utils;

import java.util.Arrays;
import net.dreamlu.mica.core.utils.StringUtil;
import org.jspecify.annotations.Nullable;
import org.springframework.util.StringUtils;

public class DesensitizationUtil {
    public static @Nullable String chineseName(@Nullable String fullName) {
        return DesensitizationUtil.sensitive(fullName, 1, 0);
    }

    public static @Nullable String idCardNum(@Nullable String id) {
        return DesensitizationUtil.sensitive(id, 0, 4);
    }

    public static @Nullable String phoneNo(@Nullable String num) {
        return DesensitizationUtil.sensitive(num, 0, 4);
    }

    public static @Nullable String mobileNo(@Nullable String num) {
        return DesensitizationUtil.sensitive(num, 3, 4);
    }

    public static @Nullable String address(@Nullable String address, int sensitiveSize) {
        return DesensitizationUtil.sensitive(address, 0, sensitiveSize);
    }

    public static @Nullable String email(@Nullable String email) {
        if (email == null) {
            return null;
        }
        if (!StringUtils.hasText((String)email)) {
            return "";
        }
        int index = email.indexOf(64);
        if (index <= 1) {
            return email;
        }
        return DesensitizationUtil.sensitive(email, 1, email.length() - index);
    }

    public static @Nullable String bankCard(@Nullable String cardNum) {
        return DesensitizationUtil.sensitive(cardNum, 6, 4);
    }

    public static @Nullable String cnApsCode(@Nullable String code) {
        return DesensitizationUtil.sensitive(code, 2, 0);
    }

    public static @Nullable String right(@Nullable String sensitiveStr) {
        if (sensitiveStr == null) {
            return null;
        }
        if (!StringUtils.hasText((String)sensitiveStr)) {
            return "";
        }
        int length = sensitiveStr.length();
        return DesensitizationUtil.sensitive(sensitiveStr, length / 2, 0);
    }

    public static @Nullable String left(@Nullable String sensitiveStr) {
        if (sensitiveStr == null) {
            return null;
        }
        if (!StringUtils.hasText((String)sensitiveStr)) {
            return "";
        }
        int length = sensitiveStr.length();
        return DesensitizationUtil.sensitive(sensitiveStr, 0, length / 2);
    }

    public static @Nullable String middle(@Nullable String sensitiveStr) {
        if (sensitiveStr == null) {
            return null;
        }
        if (!StringUtils.hasText((String)sensitiveStr)) {
            return "";
        }
        int length = sensitiveStr.length();
        if (length < 3) {
            return StringUtil.leftPad("", length, '*');
        }
        if (length < 6) {
            char[] chars = new char[length];
            int last = length - 1;
            Arrays.fill(chars, 1, last, '*');
            chars[0] = sensitiveStr.charAt(0);
            chars[last] = sensitiveStr.charAt(last);
            return new String(chars);
        }
        int fromLastLen = length / 3;
        return DesensitizationUtil.sensitive(sensitiveStr, fromLastLen, fromLastLen);
    }

    public static @Nullable String all(@Nullable String sensitiveStr) {
        return DesensitizationUtil.sensitive(sensitiveStr, 0, 0);
    }

    public static @Nullable String sensitive(@Nullable String str, int fromIndex, int lastSize) {
        return DesensitizationUtil.sensitive(str, fromIndex, lastSize, '*');
    }

    public static @Nullable String sensitive(@Nullable String str, int fromIndex, int lastSize, int padSize) {
        return DesensitizationUtil.sensitive(str, fromIndex, lastSize, '*', padSize);
    }

    public static @Nullable String sensitive(@Nullable String str, int fromIndex, int lastSize, char padChar) {
        return DesensitizationUtil.sensitive(str, fromIndex, lastSize, padChar, -1);
    }

    public static @Nullable String sensitive(@Nullable String str, int fromIndex, int lastSize, char padChar, int padSize) {
        int padSiz;
        if (str == null) {
            return null;
        }
        if (fromIndex < 0 || lastSize < 0) {
            return str;
        }
        if (!StringUtils.hasText((String)str)) {
            return "";
        }
        int length = str.length();
        if (fromIndex == 0 && lastSize == 0) {
            int padSiz2 = padSize > 0 ? padSize : length;
            return StringUtil.repeat('*', padSiz2);
        }
        int minLength = fromIndex + lastSize;
        if (length <= minLength) {
            return StringUtil.repeat('*', length);
        }
        int toIndex = length - lastSize;
        int n = padSiz = padSize > 0 ? padSize : toIndex - fromIndex;
        if (fromIndex == 0) {
            String tail = str.substring(toIndex);
            return StringUtil.repeat(padChar, padSiz).concat(tail);
        }
        if (toIndex == length) {
            String head = str.substring(0, fromIndex);
            return head.concat(StringUtil.repeat(padChar, padSiz));
        }
        String head = str.substring(0, fromIndex);
        String tail = str.substring(toIndex);
        return head + StringUtil.repeat(padChar, padSiz) + tail;
    }
}

