/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.lite.error;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.Servlet;
import net.dreamlu.mica.lite.error.MicaErrorAttributes;
import net.dreamlu.mica.lite.error.MicaErrorController;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.autoconfigure.web.servlet.error.BasicErrorController;
import org.springframework.boot.autoconfigure.web.servlet.error.ErrorMvcAutoConfiguration;
import org.springframework.boot.web.servlet.error.DefaultErrorAttributes;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.boot.web.servlet.error.ErrorController;
import org.springframework.context.annotation.Bean;
import org.springframework.web.servlet.DispatcherServlet;

@AutoConfiguration(before={ErrorMvcAutoConfiguration.class})
@ConditionalOnClass(value={Servlet.class, DispatcherServlet.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class MicaErrorAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={ErrorAttributes.class}, search=SearchStrategy.CURRENT)
    public DefaultErrorAttributes errorAttributes() {
        return new MicaErrorAttributes();
    }

    @Bean
    @ConditionalOnMissingBean(value={ErrorController.class}, search=SearchStrategy.CURRENT)
    public BasicErrorController basicErrorController(ObjectMapper objectMapper, ErrorAttributes errorAttributes, ServerProperties serverProperties) {
        return new MicaErrorController(objectMapper, errorAttributes, serverProperties.getError());
    }
}

