/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.lite.jackson;

import com.fasterxml.jackson.annotation.JsonView;
import net.dreamlu.mica.core.result.R;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJacksonValue;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@RestControllerAdvice
public class JsonViewResultAdvice
implements ResponseBodyAdvice<Object> {
    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        return returnType.hasMethodAnnotation(JsonView.class);
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        if (body instanceof R) {
            JsonView jsonView = (JsonView)returnType.getMethodAnnotation(JsonView.class);
            if (jsonView == null) {
                return body;
            }
            Class[] jsonViewClassArray = jsonView.value();
            if (jsonViewClassArray == null || jsonViewClassArray.length == 0) {
                return body;
            }
            MappingJacksonValue mappingJacksonValue = new MappingJacksonValue(body);
            mappingJacksonValue.setSerializationView(jsonView.value()[0]);
            return mappingJacksonValue;
        }
        return body;
    }
}

