/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.logging.appender;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import com.github.loki4j.logback.ApacheHttpSender;
import com.github.loki4j.logback.HttpSender;
import com.github.loki4j.logback.JavaHttpSender;
import com.github.loki4j.logback.Loki4jAppender;
import com.github.loki4j.logback.PipelineConfigAppenderBase;
import lombok.Generated;
import net.dreamlu.mica.core.utils.StringUtil;
import net.dreamlu.mica.logging.appender.ILoggingAppender;
import net.dreamlu.mica.logging.config.MicaLoggingProperties;
import net.dreamlu.mica.logging.loki.Loki4jOkHttpSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;

public class LoggingLokiAppender
implements ILoggingAppender {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoggingLokiAppender.class);
    private static final String APPENDER_NAME = "LOKI";
    private final MicaLoggingProperties properties;
    private final String appName;
    private final String profile;

    public LoggingLokiAppender(Environment environment, MicaLoggingProperties properties) {
        this.properties = properties;
        this.appName = environment.getRequiredProperty("spring.application.name");
        this.profile = environment.getRequiredProperty("spring.profiles.active");
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        this.start(context);
    }

    @Override
    public void start(LoggerContext context) {
        log.info("Loki logging start.");
        this.reload(context);
    }

    @Override
    public void reset(LoggerContext context) {
        log.info("Loki logging reset.");
        this.reload(context);
    }

    private void reload(LoggerContext context) {
        MicaLoggingProperties.Loki loki = this.properties.getLoki();
        if (loki.isEnabled()) {
            this.addLokiAppender(context, loki);
        }
    }

    private void addLokiAppender(LoggerContext context, MicaLoggingProperties.Loki properties) {
        Loki4jAppender lokiAppender = new Loki4jAppender();
        lokiAppender.setName(APPENDER_NAME);
        lokiAppender.setContext((Context)context);
        lokiAppender.setHttp(LoggingLokiAppender.getHttpCfg(properties));
        lokiAppender.setBatch(LoggingLokiAppender.getBatchCfg(properties));
        lokiAppender.setMetricsEnabled(properties.isMetricsEnabled());
        lokiAppender.setVerbose(properties.isVerbose());
        lokiAppender.setLabels(this.formatLabelPatternHandle(context, properties));
        lokiAppender.setStructuredMetadata(properties.getStructuredMetadataPattern());
        lokiAppender.start();
        context.getLogger("ROOT").detachAppender(APPENDER_NAME);
        context.getLogger("ROOT").addAppender((Appender)lokiAppender);
    }

    private static PipelineConfigAppenderBase.HttpCfg getHttpCfg(MicaLoggingProperties.Loki properties) {
        PipelineConfigAppenderBase.HttpCfg httpCfg = new PipelineConfigAppenderBase.HttpCfg();
        httpCfg.setUrl(properties.getHttpUrl());
        httpCfg.setTenantId(properties.getHttpTenantId());
        httpCfg.setConnectionTimeoutMs(properties.getHttpConnectionTimeoutMs());
        httpCfg.setRequestTimeoutMs(properties.getHttpRequestTimeoutMs());
        httpCfg.setUseProtobufApi(true);
        String authUsername = properties.getHttpAuthUsername();
        String authPassword = properties.getHttpAuthPassword();
        if (StringUtil.isNotBlank((CharSequence)authUsername) && StringUtil.isNotBlank((CharSequence)authPassword)) {
            PipelineConfigAppenderBase.BasicAuth basicAuth = new PipelineConfigAppenderBase.BasicAuth();
            basicAuth.setUsername(authUsername);
            basicAuth.setPassword(authPassword);
            httpCfg.setAuth(basicAuth);
        }
        httpCfg.setUseProtobufApi(MicaLoggingProperties.LokiEncoder.ProtoBuf == properties.getEncoder());
        MicaLoggingProperties.HttpSender httpSenderType = LoggingLokiAppender.getHttpSender(properties);
        Object httpSender = MicaLoggingProperties.HttpSender.OKHttp == httpSenderType ? new Loki4jOkHttpSender() : (MicaLoggingProperties.HttpSender.ApacheHttp == httpSenderType ? new ApacheHttpSender() : new JavaHttpSender());
        httpCfg.setSender((HttpSender)httpSender);
        return httpCfg;
    }

    private static PipelineConfigAppenderBase.BatchCfg getBatchCfg(MicaLoggingProperties.Loki properties) {
        PipelineConfigAppenderBase.BatchCfg batchCfg = new PipelineConfigAppenderBase.BatchCfg();
        batchCfg.setMaxItems(properties.getBatchMaxItems());
        batchCfg.setMaxBytes(properties.getBatchMaxBytes());
        batchCfg.setTimeoutMs(properties.getBatchTimeoutMs());
        batchCfg.setSendQueueMaxBytes(properties.getSendQueueMaxBytes());
        batchCfg.setUseDirectBuffers(properties.isUseDirectBuffers());
        batchCfg.setDrainOnStop(properties.isDrainOnStop());
        batchCfg.setStaticLabels(properties.isFormatStaticLabels());
        return batchCfg;
    }

    private String formatLabelPatternHandle(LoggerContext context, MicaLoggingProperties.Loki properties) {
        Object labelPattern = properties.getFormatLabelPattern();
        Assert.hasText((String)labelPattern, (String)"MicaLoggingProperties mica.logging.loki.format-label-pattern is blank.");
        String labelPatternExtend = properties.getFormatLabelPatternExtend();
        if (StringUtil.isNotBlank((CharSequence)labelPatternExtend)) {
            labelPattern = (String)labelPattern + "," + labelPatternExtend;
        }
        return ((String)labelPattern).replace("${appName}", this.appName).replace("${profile}", this.profile).replace("${HOSTNAME}", context.getProperty("HOSTNAME"));
    }

    private static MicaLoggingProperties.HttpSender getHttpSender(MicaLoggingProperties.Loki properties) {
        MicaLoggingProperties.HttpSender httpSenderProp = properties.getHttpSender();
        if (httpSenderProp != null && httpSenderProp.isAvailable()) {
            log.debug("mica logging use {} HttpSender", (Object)httpSenderProp);
            return httpSenderProp;
        }
        if (httpSenderProp == null) {
            MicaLoggingProperties.HttpSender[] httpSenders;
            for (MicaLoggingProperties.HttpSender httpSender : httpSenders = MicaLoggingProperties.HttpSender.values()) {
                if (!httpSender.isAvailable()) continue;
                log.debug("mica logging use {} HttpSender", (Object)httpSender);
                return httpSender;
            }
            throw new IllegalArgumentException("Not java11 and no okHttp or apache http dependency.");
        }
        throw new NoClassDefFoundError(httpSenderProp.getSenderClass());
    }
}

