/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.logging.config;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.util.ClassUtils;

@RefreshScope
@ConfigurationProperties(value="mica.logging")
public class MicaLoggingProperties {
    public static final String PREFIX = "mica.logging";
    private final Console console = new Console();
    private final Files files = new Files();
    private final Logstash logstash = new Logstash();
    private final Loki loki = new Loki();

    @Generated
    public Console getConsole() {
        return this.console;
    }

    @Generated
    public Files getFiles() {
        return this.files;
    }

    @Generated
    public Logstash getLogstash() {
        return this.logstash;
    }

    @Generated
    public Loki getLoki() {
        return this.loki;
    }

    public static class Console {
        private boolean closeAfterStart = false;

        @Generated
        public boolean isCloseAfterStart() {
            return this.closeAfterStart;
        }

        @Generated
        public void setCloseAfterStart(boolean closeAfterStart) {
            this.closeAfterStart = closeAfterStart;
        }
    }

    public static class Files {
        public static final String PREFIX = "mica.logging.files";
        private boolean enabled = true;
        private boolean useJsonFormat = false;

        @Generated
        public boolean isEnabled() {
            return this.enabled;
        }

        @Generated
        public boolean isUseJsonFormat() {
            return this.useJsonFormat;
        }

        @Generated
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public void setUseJsonFormat(boolean useJsonFormat) {
            this.useJsonFormat = useJsonFormat;
        }
    }

    public static class Logstash {
        public static final String PREFIX = "mica.logging.logstash";
        private boolean enabled = false;
        private String destinations = "localhost:5000";
        private Map<String, Object> customFieldMap = new HashMap<String, Object>();
        private int ringBufferSize = 512;

        @Generated
        public boolean isEnabled() {
            return this.enabled;
        }

        @Generated
        public String getDestinations() {
            return this.destinations;
        }

        @Generated
        public Map<String, Object> getCustomFieldMap() {
            return this.customFieldMap;
        }

        @Generated
        public int getRingBufferSize() {
            return this.ringBufferSize;
        }

        @Generated
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public void setDestinations(String destinations) {
            this.destinations = destinations;
        }

        @Generated
        public void setCustomFieldMap(Map<String, Object> customFieldMap) {
            this.customFieldMap = customFieldMap;
        }

        @Generated
        public void setRingBufferSize(int ringBufferSize) {
            this.ringBufferSize = ringBufferSize;
        }
    }

    public static class Loki {
        public static final String PREFIX = "mica.logging.loki";
        private boolean enabled = false;
        private LokiEncoder encoder = LokiEncoder.Json;
        private HttpSender httpSender;
        private int batchMaxItems = 1000;
        private int batchMaxBytes = 0x400000;
        private long batchTimeoutMs = 60000L;
        private long sendQueueMaxBytes = 0x2800000L;
        private boolean useDirectBuffers = true;
        private boolean drainOnStop = true;
        private boolean metricsEnabled = false;
        private boolean verbose = false;
        private String httpUrl = "http://localhost:3100/loki/api/v1/push";
        private long httpConnectionTimeoutMs = 30000L;
        private long httpRequestTimeoutMs = 5000L;
        private String httpAuthUsername;
        private String httpAuthPassword;
        private String httpTenantId;
        private String formatLabelPattern = "appName=${appName},profile=${profile},host=${HOSTNAME},level=%level,traceId=%X{traceId:-NAN},requestId=%X{requestId:-NAN}";
        private String formatLabelPatternExtend;
        private boolean formatStaticLabels = false;
        private String structuredMetadataPattern;

        @Generated
        public boolean isEnabled() {
            return this.enabled;
        }

        @Generated
        public LokiEncoder getEncoder() {
            return this.encoder;
        }

        @Generated
        public HttpSender getHttpSender() {
            return this.httpSender;
        }

        @Generated
        public int getBatchMaxItems() {
            return this.batchMaxItems;
        }

        @Generated
        public int getBatchMaxBytes() {
            return this.batchMaxBytes;
        }

        @Generated
        public long getBatchTimeoutMs() {
            return this.batchTimeoutMs;
        }

        @Generated
        public long getSendQueueMaxBytes() {
            return this.sendQueueMaxBytes;
        }

        @Generated
        public boolean isUseDirectBuffers() {
            return this.useDirectBuffers;
        }

        @Generated
        public boolean isDrainOnStop() {
            return this.drainOnStop;
        }

        @Generated
        public boolean isMetricsEnabled() {
            return this.metricsEnabled;
        }

        @Generated
        public boolean isVerbose() {
            return this.verbose;
        }

        @Generated
        public String getHttpUrl() {
            return this.httpUrl;
        }

        @Generated
        public long getHttpConnectionTimeoutMs() {
            return this.httpConnectionTimeoutMs;
        }

        @Generated
        public long getHttpRequestTimeoutMs() {
            return this.httpRequestTimeoutMs;
        }

        @Generated
        public String getHttpAuthUsername() {
            return this.httpAuthUsername;
        }

        @Generated
        public String getHttpAuthPassword() {
            return this.httpAuthPassword;
        }

        @Generated
        public String getHttpTenantId() {
            return this.httpTenantId;
        }

        @Generated
        public String getFormatLabelPattern() {
            return this.formatLabelPattern;
        }

        @Generated
        public String getFormatLabelPatternExtend() {
            return this.formatLabelPatternExtend;
        }

        @Generated
        public boolean isFormatStaticLabels() {
            return this.formatStaticLabels;
        }

        @Generated
        public String getStructuredMetadataPattern() {
            return this.structuredMetadataPattern;
        }

        @Generated
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public void setEncoder(LokiEncoder encoder) {
            this.encoder = encoder;
        }

        @Generated
        public void setHttpSender(HttpSender httpSender) {
            this.httpSender = httpSender;
        }

        @Generated
        public void setBatchMaxItems(int batchMaxItems) {
            this.batchMaxItems = batchMaxItems;
        }

        @Generated
        public void setBatchMaxBytes(int batchMaxBytes) {
            this.batchMaxBytes = batchMaxBytes;
        }

        @Generated
        public void setBatchTimeoutMs(long batchTimeoutMs) {
            this.batchTimeoutMs = batchTimeoutMs;
        }

        @Generated
        public void setSendQueueMaxBytes(long sendQueueMaxBytes) {
            this.sendQueueMaxBytes = sendQueueMaxBytes;
        }

        @Generated
        public void setUseDirectBuffers(boolean useDirectBuffers) {
            this.useDirectBuffers = useDirectBuffers;
        }

        @Generated
        public void setDrainOnStop(boolean drainOnStop) {
            this.drainOnStop = drainOnStop;
        }

        @Generated
        public void setMetricsEnabled(boolean metricsEnabled) {
            this.metricsEnabled = metricsEnabled;
        }

        @Generated
        public void setVerbose(boolean verbose) {
            this.verbose = verbose;
        }

        @Generated
        public void setHttpUrl(String httpUrl) {
            this.httpUrl = httpUrl;
        }

        @Generated
        public void setHttpConnectionTimeoutMs(long httpConnectionTimeoutMs) {
            this.httpConnectionTimeoutMs = httpConnectionTimeoutMs;
        }

        @Generated
        public void setHttpRequestTimeoutMs(long httpRequestTimeoutMs) {
            this.httpRequestTimeoutMs = httpRequestTimeoutMs;
        }

        @Generated
        public void setHttpAuthUsername(String httpAuthUsername) {
            this.httpAuthUsername = httpAuthUsername;
        }

        @Generated
        public void setHttpAuthPassword(String httpAuthPassword) {
            this.httpAuthPassword = httpAuthPassword;
        }

        @Generated
        public void setHttpTenantId(String httpTenantId) {
            this.httpTenantId = httpTenantId;
        }

        @Generated
        public void setFormatLabelPattern(String formatLabelPattern) {
            this.formatLabelPattern = formatLabelPattern;
        }

        @Generated
        public void setFormatLabelPatternExtend(String formatLabelPatternExtend) {
            this.formatLabelPatternExtend = formatLabelPatternExtend;
        }

        @Generated
        public void setFormatStaticLabels(boolean formatStaticLabels) {
            this.formatStaticLabels = formatStaticLabels;
        }

        @Generated
        public void setStructuredMetadataPattern(String structuredMetadataPattern) {
            this.structuredMetadataPattern = structuredMetadataPattern;
        }
    }

    public static enum HttpSender {
        JAVA11("java.net.http.HttpClient"),
        OKHttp("okhttp3.OkHttpClient"),
        ApacheHttp("org.apache.http.impl.client.HttpClients");

        private final String senderClass;

        public boolean isAvailable() {
            return ClassUtils.isPresent((String)this.senderClass, null);
        }

        @Generated
        public String getSenderClass() {
            return this.senderClass;
        }

        @Generated
        private HttpSender(String senderClass) {
            this.senderClass = senderClass;
        }
    }

    public static enum LokiEncoder {
        Json,
        ProtoBuf;

    }
}

