/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.task;

import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.PacketHandlerMode;
import org.tio.core.TioConfig;
import org.tio.core.intf.Packet;
import org.tio.utils.thread.pool.AbstractQueueRunnable;

public class HandlerRunnable
extends AbstractQueueRunnable<Packet> {
    private static final Logger log = LoggerFactory.getLogger(HandlerRunnable.class);
    private final ChannelContext channelContext;
    private final TioConfig tioConfig;
    private final AtomicLong synFailCount = new AtomicLong();
    private final Queue<Packet> msgQueue;

    public HandlerRunnable(ChannelContext channelContext, Executor executor) {
        super(executor);
        this.channelContext = channelContext;
        this.tioConfig = channelContext.tioConfig;
        this.msgQueue = PacketHandlerMode.QUEUE == this.tioConfig.packetHandlerMode ? new ConcurrentLinkedQueue() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handler(Packet packet) {
        block18: {
            long start = System.currentTimeMillis();
            try {
                Integer synSeq = packet.getSynSeq();
                if (synSeq != null && synSeq > 0) {
                    Map<Integer, Packet> syns = this.tioConfig.getWaitingResps();
                    Packet initPacket = syns.remove(synSeq);
                    if (initPacket != null) {
                        Packet packet2 = initPacket;
                        synchronized (packet2) {
                            syns.put(synSeq, packet);
                            initPacket.notify();
                            break block18;
                        }
                    }
                    log.error("[{}]\u540c\u6b65\u6d88\u606f\u5931\u8d25, synSeq is {}, \u4f46\u662f\u540c\u6b65\u96c6\u5408\u4e2d\u6ca1\u6709\u5bf9\u5e94key\u503c", (Object)this.synFailCount.incrementAndGet(), (Object)synSeq);
                    break block18;
                }
                this.tioConfig.getTioHandler().handler(packet, this.channelContext);
            }
            catch (Throwable e) {
                log.error(packet.logstr(), e);
            }
            finally {
                long end = System.currentTimeMillis();
                long iv = end - start;
                if (this.tioConfig.statOn) {
                    this.channelContext.stat.handledPackets.increment();
                    this.channelContext.stat.handledBytes.add(packet.getByteCount());
                    this.channelContext.stat.handledPacketCosts.add(iv);
                    this.tioConfig.groupStat.handledPackets.increment();
                    this.tioConfig.groupStat.handledBytes.add(packet.getByteCount());
                    this.tioConfig.groupStat.handledPacketCosts.add(iv);
                }
                if (this.tioConfig.getTioListener() != null) {
                    try {
                        this.tioConfig.getTioListener().onAfterHandled(this.channelContext, packet, iv);
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }

    public void runTask() {
        Packet packet;
        while ((packet = this.msgQueue.poll()) != null) {
            this.handler(packet);
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + ':' + this.channelContext.toString();
    }

    public String logstr() {
        return this.toString();
    }

    public Queue<Packet> getMsgQueue() {
        return this.msgQueue;
    }
}

