/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.utils;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.tio.core.exception.LengthOverflowException;
import org.tio.core.utils.DecodeByteBufferList;
import org.tio.utils.hutool.StrUtil;

public class ByteBufferUtils {
    public static ByteBuffer composite(ByteBuffer byteBuffer1, ByteBuffer byteBuffer2) {
        int capacity = byteBuffer1.remaining() + byteBuffer2.remaining();
        ByteBuffer ret = ByteBuffer.allocate(capacity);
        ret.put(byteBuffer1);
        ret.put(byteBuffer2);
        ret.position(0);
        ret.limit(ret.capacity());
        return ret;
    }

    public static void copy(ByteBuffer src, int srcStartIndex, ByteBuffer dest, int destStartIndex, int length) {
        System.arraycopy(src.array(), srcStartIndex, dest.array(), destStartIndex, length);
    }

    public static ByteBuffer copy(ByteBuffer src, int startIndex, int endIndex) {
        int size = endIndex - startIndex;
        int initPosition = src.position();
        int initLimit = src.limit();
        src.position(startIndex);
        src.limit(endIndex);
        ByteBuffer ret = ByteBuffer.allocate(size);
        ret.put(src);
        ret.flip();
        src.position(initPosition);
        src.limit(initLimit);
        return ret;
    }

    public static ByteBuffer copy(ByteBuffer src) {
        int startIndex = src.position();
        int endIndex = src.limit();
        return ByteBufferUtils.copy(src, startIndex, endIndex);
    }

    public static ByteBuffer[] split(ByteBuffer src, int unitSize) {
        int limit = src.limit();
        if (unitSize >= limit) {
            return null;
        }
        int size = (int)Math.ceil((double)src.limit() / (double)unitSize);
        ByteBuffer[] ret = new ByteBuffer[size];
        int srcIndex = 0;
        for (int i = 0; i < size; ++i) {
            int bufferSize = unitSize;
            if (i == size - 1) {
                bufferSize = src.limit() % unitSize;
            }
            byte[] dest = new byte[bufferSize];
            System.arraycopy(src.array(), srcIndex, dest, 0, dest.length);
            srcIndex += bufferSize;
            ret[i] = ByteBuffer.wrap(dest);
            ret[i].position(0);
            ret[i].limit(ret[i].capacity());
        }
        return ret;
    }

    public static int lineEnd(ByteBuffer buffer) throws LengthOverflowException {
        return ByteBufferUtils.lineEnd(buffer, Integer.MAX_VALUE);
    }

    public static int lineEnd(ByteBuffer buffer, int maxlength) throws LengthOverflowException {
        int initPosition = buffer.position();
        int endPosition = ByteBufferUtils.indexOf(buffer, '\n', maxlength);
        if (endPosition - initPosition > 0 && buffer.get(endPosition - 1) == 13) {
            return endPosition - 1;
        }
        return endPosition;
    }

    public static int indexOf(ByteBuffer buffer, char theChar, int maxlength) throws LengthOverflowException {
        boolean needJudgeLengthOverflow;
        int count = 0;
        boolean bl = needJudgeLengthOverflow = buffer.remaining() > maxlength;
        while (buffer.hasRemaining()) {
            if (buffer.get() == theChar) {
                return buffer.position() - 1;
            }
            if (!needJudgeLengthOverflow || ++count <= maxlength) continue;
            throw new LengthOverflowException("maxlength is " + maxlength);
        }
        return -1;
    }

    public static byte[] readBytes(ByteBuffer buffer, int length) {
        byte[] ab = new byte[length];
        buffer.get(ab);
        return ab;
    }

    public static String readString(ByteBuffer buffer, int length, String charset) throws UnsupportedEncodingException {
        byte[] bs = ByteBufferUtils.readBytes(buffer, length);
        if (StrUtil.isNotBlank((CharSequence)charset)) {
            return new String(bs, charset);
        }
        return new String(bs);
    }

    public static String readLine(ByteBuffer buffer, Charset charset) throws LengthOverflowException {
        return ByteBufferUtils.readLine(buffer, charset, Integer.MAX_VALUE);
    }

    public static String readLine(ByteBuffer buffer, Charset charset, Integer maxlength) throws LengthOverflowException {
        int startPosition = buffer.position();
        int endPosition = ByteBufferUtils.lineEnd(buffer, maxlength);
        if (endPosition == -1) {
            return null;
        }
        int nowPosition = buffer.position();
        if (endPosition > startPosition) {
            byte[] bs = new byte[endPosition - startPosition];
            buffer.position(startPosition);
            buffer.get(bs);
            buffer.position(nowPosition);
            if (charset == null) {
                return new String(bs);
            }
            return new String(bs, charset);
        }
        if (endPosition == startPosition) {
            return "";
        }
        return null;
    }

    public static String readString(ByteBuffer buffer, int length, Charset charset) {
        byte[] bs = ByteBufferUtils.readBytes(buffer, length);
        if (charset != null) {
            return new String(bs, charset);
        }
        return new String(bs, StandardCharsets.UTF_8);
    }

    public static String readString(ByteBuffer buffer, Charset charset, char endChar, Integer maxlength) throws LengthOverflowException {
        int startPosition = buffer.position();
        int endPosition = ByteBufferUtils.indexOf(buffer, endChar, maxlength);
        if (endPosition == -1) {
            return null;
        }
        int nowPosition = buffer.position();
        if (endPosition > startPosition) {
            byte[] bs = new byte[endPosition - startPosition];
            buffer.position(startPosition);
            buffer.get(bs);
            buffer.position(nowPosition);
            if (charset == null) {
                return new String(bs);
            }
            return new String(bs, charset);
        }
        if (endPosition == startPosition) {
            return "";
        }
        return null;
    }

    public static String getUtf8(byte[] bytes) {
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static byte read(ByteBuffer buffer) {
        return buffer.get();
    }

    public static short readShort(ByteBuffer buffer) {
        return buffer.getShort();
    }

    public static int readUB1(ByteBuffer buffer) {
        return buffer.get() & 0xFF;
    }

    public static int readUB1(DecodeByteBufferList buffer) {
        return ByteBufferUtils.readUB1(buffer.checkGet(1));
    }

    public static int readUB2(ByteBuffer buffer) {
        int ret = buffer.get() & 0xFF;
        return ret |= (buffer.get() & 0xFF) << 8;
    }

    public static int readUB2WithBigEdian(ByteBuffer buffer) {
        int ret = (buffer.get() & 0xFF) << 8;
        return ret |= buffer.get() & 0xFF;
    }

    public static long readUB4(ByteBuffer buffer) {
        long ret = buffer.get() & 0xFF;
        ret |= (long)(buffer.get() & 0xFF) << 8;
        ret |= (long)(buffer.get() & 0xFF) << 16;
        return ret |= (long)(buffer.get() & 0xFF) << 24;
    }

    public static long readUB4WithBigEdian(ByteBuffer buffer) {
        long ret = (long)(buffer.get() & 0xFF) << 24;
        ret |= (long)(buffer.get() & 0xFF) << 16;
        ret |= (long)(buffer.get() & 0xFF) << 8;
        return ret |= (long)(buffer.get() & 0xFF);
    }

    public static void writeUB2(ByteBuffer buffer, int i) {
        buffer.put((byte)(i & 0xFF));
        buffer.put((byte)(i >>> 8));
    }

    public static void writeUB2WithBigEdian(ByteBuffer buffer, int i) {
        buffer.put((byte)(i >>> 8));
        buffer.put((byte)(i & 0xFF));
    }

    public static void writeUB4(ByteBuffer buffer, long l) {
        buffer.put((byte)(l & 0xFFL));
        buffer.put((byte)(l >>> 8));
        buffer.put((byte)(l >>> 16));
        buffer.put((byte)(l >>> 24));
    }

    public static void writeUB4WithBigEdian(ByteBuffer buffer, long l) {
        buffer.put((byte)(l >>> 24));
        buffer.put((byte)(l >>> 16));
        buffer.put((byte)(l >>> 8));
        buffer.put((byte)(l & 0xFFL));
    }
}

