/*
 * Decompiled with CFR 0.152.
 */
package org.tio.client.task;

import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.client.ClientChannelContext;
import org.tio.client.ClientGroupStat;
import org.tio.client.TioClientConfig;
import org.tio.client.intf.TioClientHandler;
import org.tio.client.task.HeartbeatTimeoutStrategy;
import org.tio.core.ChannelContext;
import org.tio.core.Tio;
import org.tio.core.intf.Packet;
import org.tio.core.task.HeartbeatMode;
import org.tio.utils.timer.Timer;
import org.tio.utils.timer.TimerTask;

public class ClientHeartbeatTask
extends TimerTask {
    private static final Logger logger = LoggerFactory.getLogger(ClientHeartbeatTask.class);
    private final Timer timer;
    private final TioClientConfig clientConfig;
    private final ClientGroupStat clientGroupStat;
    private final TioClientHandler tioHandler;
    private final String id;

    public ClientHeartbeatTask(Timer timer, TioClientConfig clientConfig) {
        super(clientConfig.heartbeatTimeout / 3L);
        this.timer = timer;
        this.clientConfig = clientConfig;
        this.clientGroupStat = (ClientGroupStat)clientConfig.groupStat;
        this.tioHandler = clientConfig.getTioClientHandler();
        this.id = clientConfig.getId();
    }

    public void run() {
        if (this.clientConfig.isStopped()) {
            return;
        }
        this.timer.add((TimerTask)this);
        Set<ChannelContext> set = this.clientConfig.connecteds;
        HeartbeatMode heartbeatMode = this.clientConfig.getHeartbeatMode();
        HeartbeatTimeoutStrategy timeoutStrategy = this.clientConfig.getHeartbeatTimeoutStrategy();
        long currTime = System.currentTimeMillis();
        try {
            for (ChannelContext entry : set) {
                ClientChannelContext context = (ClientChannelContext)entry;
                if (context.isClosed() || context.isRemoved()) continue;
                long compareTime = heartbeatMode.getLastTime(context.stat);
                long interval = currTime - compareTime;
                if (interval >= this.clientConfig.heartbeatTimeout) {
                    if (HeartbeatTimeoutStrategy.CLOSE == timeoutStrategy) {
                        Tio.close((ChannelContext)context, interval + "ms\u6ca1\u6709\u6536\u5230\u6d88\u606f", ChannelContext.CloseCode.HEARTBEAT_TIMEOUT);
                        continue;
                    }
                    this.sendHeartbeat(context);
                    continue;
                }
                if (interval < this.clientConfig.heartbeatTimeout / 2L) continue;
                this.sendHeartbeat(context);
            }
            if (this.clientConfig.debug && logger.isInfoEnabled()) {
                if (this.clientConfig.statOn) {
                    logger.info("[{}]: curr:{}, closed:{}, received:({}p)({}b), handled:{}, sent:({}p)({}b)", new Object[]{this.id, set.size(), this.clientGroupStat.closed.sum(), this.clientGroupStat.receivedPackets.sum(), this.clientGroupStat.receivedBytes.sum(), this.clientGroupStat.handledPackets.sum(), this.clientGroupStat.sentPackets.sum(), this.clientGroupStat.sentBytes.sum()});
                } else {
                    logger.info("[{}]: curr:{}, closed:{}", new Object[]{this.id, set.size(), this.clientGroupStat.closed.sum()});
                }
            }
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
        }
    }

    private void sendHeartbeat(ChannelContext context) {
        Packet packet = this.tioHandler.heartbeatPacket(context);
        if (packet != null) {
            boolean result = Tio.send(context, packet);
            if (this.clientConfig.debug && logger.isInfoEnabled()) {
                logger.info("{} \u53d1\u9001\u5fc3\u8df3\u5305 result:{}", (Object)context, (Object)result);
            }
        }
    }
}

