/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core;

import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.client.ClientChannelContext;
import org.tio.client.ReconnConf;
import org.tio.client.TioClientConfig;
import org.tio.core.ChannelContext;
import org.tio.core.ChannelContextFilter;
import org.tio.core.Node;
import org.tio.core.PacketSendMode;
import org.tio.core.TioConfig;
import org.tio.core.intf.Packet;
import org.tio.utils.page.Page;
import org.tio.utils.page.PageUtils;

public class Tio {
    private static final Logger log = LoggerFactory.getLogger(Tio.class);

    private Tio() {
    }

    public static void bindBsId(ChannelContext channelContext, String bsId) {
        channelContext.tioConfig.bsIds.bind(channelContext, bsId);
    }

    public static void bindGroup(ChannelContext channelContext, String group) {
        channelContext.tioConfig.groups.bind(group, channelContext);
    }

    public static void bindGroup(TioConfig tioConfig, String userid, String group) {
        Set<ChannelContext> contextSet = Tio.getByUserid(tioConfig, userid);
        if (contextSet != null) {
            for (ChannelContext channelContext : contextSet) {
                Tio.bindGroup(channelContext, group);
            }
        }
    }

    public static void bindToken(ChannelContext channelContext, String token) {
        channelContext.tioConfig.tokens.bind(token, channelContext);
    }

    public static void bindUser(ChannelContext channelContext, String userid) {
        channelContext.tioConfig.users.bind(userid, channelContext);
    }

    public static boolean bSend(ChannelContext channelContext, Packet packet) {
        if (channelContext == null) {
            return false;
        }
        CountDownLatch countDownLatch = new CountDownLatch(1);
        return Tio.send(channelContext, packet, countDownLatch, PacketSendMode.SINGLE_BLOCK);
    }

    public static boolean bSend(TioConfig tioConfig, String ip, int port, Packet packet) {
        return Tio.send(tioConfig, ip, port, packet, true);
    }

    public static boolean bSendToAll(TioConfig tioConfig, Packet packet, ChannelContextFilter channelContextFilter) {
        return Tio.sendToAll(tioConfig, packet, channelContextFilter, true);
    }

    public static boolean bSendToBsId(TioConfig tioConfig, String bsId, Packet packet) {
        return Tio.sendToBsId(tioConfig, bsId, packet, true);
    }

    public static boolean bSendToGroup(TioConfig tioConfig, String group, Packet packet) {
        return Tio.bSendToGroup(tioConfig, group, packet, null);
    }

    public static boolean bSendToGroup(TioConfig tioConfig, String group, Packet packet, ChannelContextFilter channelContextFilter) {
        return Tio.sendToGroup(tioConfig, group, packet, channelContextFilter, true);
    }

    public static boolean bSendToId(TioConfig tioConfig, String channelContextId, Packet packet) {
        return Tio.sendToId(tioConfig, channelContextId, packet, true);
    }

    public static boolean bSendToSet(TioConfig tioConfig, Set<ChannelContext> set, Packet packet, ChannelContextFilter channelContextFilter) {
        return Tio.sendToSet(tioConfig, set, packet, channelContextFilter, true);
    }

    public static boolean bSendToToken(TioConfig tioConfig, String token, Packet packet) {
        return Tio.sendToToken(tioConfig, token, packet, true);
    }

    public static boolean bSendToUser(TioConfig tioConfig, String userid, Packet packet) {
        return Tio.sendToUser(tioConfig, userid, packet, true);
    }

    public static void close(ChannelContext channelContext, String remark) {
        Tio.close(channelContext, null, remark);
    }

    public static void close(ChannelContext channelContext, String remark, ChannelContext.CloseCode closeCode) {
        Tio.close(channelContext, null, remark, closeCode);
    }

    public static void close(ChannelContext context, Throwable throwable, String remark) {
        Tio.close(context, throwable, remark, context.isServer());
    }

    public static void close(ChannelContext context, Throwable throwable, String remark, ChannelContext.CloseCode closeCode) {
        Tio.close(context, throwable, remark, context.isServer(), closeCode);
    }

    public static void close(ChannelContext context, Throwable throwable, String remark, boolean isNeedRemove) {
        Tio.close(context, throwable, remark, isNeedRemove, true);
    }

    public static void close(ChannelContext context, Throwable throwable, String remark, boolean isNeedRemove, ChannelContext.CloseCode closeCode) {
        Tio.close(context, throwable, remark, isNeedRemove, true, closeCode);
    }

    public static void close(ChannelContext context, Throwable throwable, String remark, boolean isNeedRemove, boolean needCloseLock) {
        Tio.close(context, throwable, remark, isNeedRemove, needCloseLock, null);
    }

    public static void close(ChannelContext context, Throwable throwable, String remark, boolean isNeedRemove, boolean needCloseLock, ChannelContext.CloseCode closeCode) {
        if (context == null) {
            return;
        }
        if (context.isWaitingClose()) {
            log.debug("{} \u6b63\u5728\u7b49\u5f85\u88ab\u5173\u95ed", (Object)context);
            return;
        }
        context.decodeRunnable.setCanceled(true);
        context.handlerRunnable.setCanceled(true);
        context.sendRunnable.setCanceled(true);
        if (needCloseLock) {
            ReentrantReadWriteLock.WriteLock writeLock = context.closeLock.writeLock();
            boolean tryLock = writeLock.tryLock();
            if (!tryLock) {
                return;
            }
            context.setWaitingClose(true);
            writeLock.unlock();
        } else {
            context.setWaitingClose(true);
        }
        if (closeCode == null) {
            if (context.getCloseCode() == ChannelContext.CloseCode.INIT_STATUS) {
                context.setCloseCode(ChannelContext.CloseCode.NO_CODE);
            }
        } else {
            context.setCloseCode(closeCode);
        }
        if (context.asynchronousSocketChannel != null) {
            try {
                context.asynchronousSocketChannel.shutdownInput();
            }
            catch (Throwable tryLock) {
                // empty catch block
            }
            try {
                context.asynchronousSocketChannel.shutdownOutput();
            }
            catch (Throwable tryLock) {
                // empty catch block
            }
            try {
                context.asynchronousSocketChannel.close();
            }
            catch (Throwable tryLock) {
                // empty catch block
            }
        }
        context.closeMeta.setRemark(remark);
        context.closeMeta.setThrowable(throwable);
        if (!isNeedRemove) {
            if (context.isServer()) {
                isNeedRemove = true;
            } else {
                ClientChannelContext clientChannelContext = (ClientChannelContext)context;
                if (!ReconnConf.isNeedReconn(clientChannelContext, false)) {
                    isNeedRemove = true;
                }
            }
        }
        context.closeMeta.setNeedRemove(isNeedRemove);
        context.tioConfig.closeRunnable.addMsg((Object)context);
        context.tioConfig.closeRunnable.execute();
    }

    public static void close(TioConfig tioConfig, String clientIp, Integer clientPort, Throwable throwable, String remark) {
        ChannelContext channelContext = tioConfig.clientNodes.find(clientIp, clientPort);
        Tio.close(channelContext, throwable, remark);
    }

    public static void closeGroup(TioConfig tioConfig, String group, String remark) {
        Tio.closeGroup(tioConfig, group, remark, null);
    }

    public static void closeGroup(TioConfig tioConfig, String group, String remark, ChannelContext.CloseCode closeCode) {
        Set<ChannelContext> contextSet = Tio.getByGroup(tioConfig, group);
        Tio.closeSet(contextSet, remark, closeCode);
    }

    public static void closeUser(TioConfig tioConfig, String userid, String remark) {
        Tio.closeUser(tioConfig, userid, remark, null);
    }

    public static void closeUser(TioConfig tioConfig, String userid, String remark, ChannelContext.CloseCode closeCode) {
        Set<ChannelContext> contextSet = Tio.getByUserid(tioConfig, userid);
        Tio.closeSet(contextSet, remark, closeCode);
    }

    public static void closeToken(TioConfig tioConfig, String token, String remark) {
        Tio.closeToken(tioConfig, token, remark, null);
    }

    public static void closeToken(TioConfig tioConfig, String token, String remark, ChannelContext.CloseCode closeCode) {
        Set<ChannelContext> setWithLock = Tio.getByToken(tioConfig, token);
        Tio.closeSet(setWithLock, remark, closeCode);
    }

    public static void removeGroup(TioConfig tioConfig, String group, String remark) {
        Tio.removeGroup(tioConfig, group, remark, null);
    }

    public static void removeGroup(TioConfig tioConfig, String group, String remark, ChannelContext.CloseCode removeCode) {
        Set<ChannelContext> contextSet = Tio.getByGroup(tioConfig, group);
        Tio.removeSet(contextSet, remark, removeCode);
    }

    public static void removeUser(TioConfig tioConfig, String userid, String remark) {
        Tio.removeUser(tioConfig, userid, remark, null);
    }

    public static void removeUser(TioConfig tioConfig, String userid, String remark, ChannelContext.CloseCode removeCode) {
        Set<ChannelContext> contextSet = Tio.getByUserid(tioConfig, userid);
        Tio.removeSet(contextSet, remark, removeCode);
    }

    public static void removeToken(TioConfig tioConfig, String token, String remark) {
        Tio.removeToken(tioConfig, token, remark, null);
    }

    public static void removeToken(TioConfig tioConfig, String token, String remark, ChannelContext.CloseCode removeCode) {
        Set<ChannelContext> contextSet = Tio.getByToken(tioConfig, token);
        Tio.removeSet(contextSet, remark, removeCode);
    }

    public static void closeSet(Set<ChannelContext> set, String remark, ChannelContext.CloseCode closeCode) {
        if (set != null) {
            for (ChannelContext channelContext : set) {
                Tio.close(channelContext, remark, closeCode);
            }
        }
    }

    public static void removeSet(Set<ChannelContext> set, String remark, ChannelContext.CloseCode closeCode) {
        if (set != null) {
            for (ChannelContext channelContext : set) {
                Tio.remove(channelContext, remark, closeCode);
            }
        }
    }

    public static Set<ChannelContext> getAll(TioConfig tioConfig) {
        return tioConfig.connections;
    }

    public static Set<ChannelContext> getConnecteds(TioClientConfig tioClientConfig) {
        return tioClientConfig.connecteds;
    }

    public static ChannelContext getByBsId(TioConfig tioConfig, String bsId) {
        return tioConfig.bsIds.find(tioConfig, bsId);
    }

    public static ChannelContext getByClientNode(TioConfig tioConfig, Node node) {
        return tioConfig.clientNodes.find(node);
    }

    public static ChannelContext getByClientNode(TioConfig tioConfig, String clientIp, Integer clientPort) {
        return tioConfig.clientNodes.find(clientIp, clientPort);
    }

    public static ChannelContext getByChannelContextId(TioConfig tioConfig, String channelContextId) {
        return tioConfig.ids.find(tioConfig, channelContextId);
    }

    public static Set<ChannelContext> getByGroup(TioConfig tioConfig, String group) {
        return tioConfig.groups.clients(tioConfig, group);
    }

    public static Set<ChannelContext> getByToken(TioConfig tioConfig, String token) {
        return tioConfig.tokens.find(tioConfig, token);
    }

    public static Set<ChannelContext> getByUserid(TioConfig tioConfig, String userid) {
        return tioConfig.users.find(tioConfig, userid);
    }

    public static Page<ChannelContext> getPageOfAll(TioConfig tioConfig, Integer pageIndex, Integer pageSize) {
        return Tio.getPageOfAll(tioConfig, pageIndex, pageSize, null);
    }

    public static <T> Page<T> getPageOfAll(TioConfig tioConfig, Integer pageIndex, Integer pageSize, Function<ChannelContext, T> converter) {
        Set<ChannelContext> contextSet = Tio.getAll(tioConfig);
        return PageUtils.fromSet(contextSet, (int)pageIndex, (int)pageSize, converter);
    }

    public static <T> Page<T> getPageOfAll(TioConfig tioConfig, Integer pageIndex, Integer pageSize, Predicate<ChannelContext> filter, Function<ChannelContext, T> converter) {
        Set<ChannelContext> contextSet = Tio.getAll(tioConfig);
        return PageUtils.fromSet(contextSet, (int)pageIndex, (int)pageSize, filter, converter);
    }

    public static Page<ChannelContext> getPageOfConnecteds(TioClientConfig tioClientConfig, Integer pageIndex, Integer pageSize) {
        return Tio.getPageOfConnecteds(tioClientConfig, pageIndex, pageSize, null);
    }

    public static <T> Page<T> getPageOfConnecteds(TioClientConfig tioClientConfig, Integer pageIndex, Integer pageSize, Function<ChannelContext, T> converter) {
        Set<ChannelContext> contextSet = Tio.getConnecteds(tioClientConfig);
        return PageUtils.fromSet(contextSet, (int)pageIndex, (int)pageSize, converter);
    }

    public static Page<ChannelContext> getPageOfGroup(TioConfig tioConfig, String group, Integer pageIndex, Integer pageSize) {
        return Tio.getPageOfGroup(tioConfig, group, pageIndex, pageSize, null);
    }

    public static <T> Page<T> getPageOfGroup(TioConfig tioConfig, String group, Integer pageIndex, Integer pageSize, Function<ChannelContext, T> converter) {
        Set<ChannelContext> contextSet = Tio.getByGroup(tioConfig, group);
        return PageUtils.fromSet(contextSet, (int)pageIndex, (int)pageSize, converter);
    }

    public static int groupCount(TioConfig tioConfig, String group) {
        Set<ChannelContext> contextSet = tioConfig.groups.clients(tioConfig, group);
        if (contextSet == null) {
            return 0;
        }
        return contextSet.size();
    }

    public static boolean isInGroup(String group, ChannelContext channelContext) {
        Set<String> groupSet = channelContext.getGroups();
        if (groupSet == null || groupSet.isEmpty()) {
            return false;
        }
        return groupSet.contains(group);
    }

    public static void remove(ChannelContext channelContext, String remark) {
        Tio.remove(channelContext, remark, null);
    }

    public static void remove(ChannelContext channelContext, String remark, ChannelContext.CloseCode closeCode) {
        Tio.remove(channelContext, null, remark, closeCode);
    }

    public static void remove(ChannelContext channelContext, Throwable throwable, String remark) {
        Tio.remove(channelContext, throwable, remark, null);
    }

    public static void remove(ChannelContext channelContext, Throwable throwable, String remark, ChannelContext.CloseCode closeCode) {
        Tio.close(channelContext, throwable, remark, true, closeCode);
    }

    public static void remove(TioConfig tioConfig, String clientIp, Integer clientPort, Throwable throwable, String remark) {
        Tio.remove(tioConfig, clientIp, clientPort, throwable, remark, null);
    }

    public static void remove(TioConfig tioConfig, String clientIp, Integer clientPort, Throwable throwable, String remark, ChannelContext.CloseCode closeCode) {
        ChannelContext channelContext = tioConfig.clientNodes.find(clientIp, clientPort);
        Tio.remove(channelContext, throwable, remark, closeCode);
    }

    public static boolean send(ChannelContext channelContext, Packet packet) {
        return Tio.send(channelContext, packet, null, null);
    }

    private static boolean send(ChannelContext channelContext, Packet packet, CountDownLatch countDownLatch, PacketSendMode packetSendMode) {
        try {
            boolean isAdded;
            boolean isSingleBlock;
            if (packet == null || channelContext == null) {
                if (countDownLatch != null) {
                    countDownLatch.countDown();
                }
                return false;
            }
            if (channelContext.isVirtual()) {
                if (countDownLatch != null) {
                    countDownLatch.countDown();
                }
                return true;
            }
            if (channelContext.isClosed() || channelContext.isRemoved()) {
                if (countDownLatch != null) {
                    countDownLatch.countDown();
                }
                if (channelContext != null) {
                    log.info("can't send data, {}, isClosed:{}, isRemoved:{}", new Object[]{channelContext, channelContext.isClosed(), channelContext.isRemoved()});
                }
                return false;
            }
            if (channelContext.tioConfig.packetConverter != null) {
                Packet packet1 = channelContext.tioConfig.packetConverter.convert(packet, channelContext);
                if (packet1 == null) {
                    if (log.isInfoEnabled()) {
                        log.info("channelContext:{} packet:{} convert\u540e\u4e3anull\uff0c\u8868\u793a\u4e0d\u9700\u8981\u53d1\u9001", (Object)channelContext, (Object)packet.logstr());
                    }
                    return true;
                }
                packet = packet1;
            }
            boolean bl = isSingleBlock = countDownLatch != null && packetSendMode == PacketSendMode.SINGLE_BLOCK;
            if (countDownLatch != null) {
                Packet.Meta meta = new Packet.Meta(countDownLatch);
                packet.setMeta(meta);
            }
            if (!(isAdded = channelContext.tioConfig.useQueueSend ? channelContext.sendRunnable.addMsg(packet) : channelContext.sendRunnable.sendPacket(packet))) {
                if (countDownLatch != null) {
                    countDownLatch.countDown();
                }
                return false;
            }
            if (channelContext.tioConfig.useQueueSend) {
                channelContext.sendRunnable.execute();
            }
            if (isSingleBlock) {
                long timeout = 10L;
                try {
                    boolean awaitFlag = countDownLatch.await(timeout, TimeUnit.SECONDS);
                    if (!awaitFlag) {
                        log.error("{}, \u963b\u585e\u53d1\u9001\u8d85\u65f6, timeout:{}s, packet:{}", new Object[]{channelContext, timeout, packet.logstr()});
                    }
                }
                catch (InterruptedException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                return packet.getMeta().isSentSuccess();
            }
            return true;
        }
        catch (Throwable e) {
            log.error("channelContext:{}, error:", (Object)channelContext, (Object)e);
            return false;
        }
    }

    public static boolean send(TioConfig tioConfig, String ip, int port, Packet packet) {
        return Tio.send(tioConfig, ip, port, packet, false);
    }

    private static boolean send(TioConfig tioConfig, String ip, int port, Packet packet, boolean isBlock) {
        ChannelContext channelContext = tioConfig.clientNodes.find(ip, port);
        if (channelContext != null) {
            if (isBlock) {
                return Tio.bSend(channelContext, packet);
            }
            return Tio.send(channelContext, packet);
        }
        log.info("{}, can find channelContext by {}:{}", new Object[]{tioConfig.getName(), ip, port});
        return false;
    }

    public static void sendToAll(TioConfig tioConfig, Packet packet) {
        Tio.sendToAll(tioConfig, packet, null);
    }

    public static void sendToAll(TioConfig tioConfig, Packet packet, ChannelContextFilter channelContextFilter) {
        Tio.sendToAll(tioConfig, packet, channelContextFilter, false);
    }

    private static boolean sendToAll(TioConfig tioConfig, Packet packet, ChannelContextFilter channelContextFilter, boolean isBlock) {
        return Tio.sendToSet(tioConfig, tioConfig.connections, packet, channelContextFilter, isBlock);
    }

    public static boolean sendToBsId(TioConfig tioConfig, String bsId, Packet packet) {
        return Tio.sendToBsId(tioConfig, bsId, packet, false);
    }

    private static boolean sendToBsId(TioConfig tioConfig, String bsId, Packet packet, boolean isBlock) {
        ChannelContext channelContext = Tio.getByBsId(tioConfig, bsId);
        if (channelContext == null) {
            return false;
        }
        if (isBlock) {
            return Tio.bSend(channelContext, packet);
        }
        return Tio.send(channelContext, packet);
    }

    public static void sendToGroup(TioConfig tioConfig, String group, Packet packet) {
        Tio.sendToGroup(tioConfig, group, packet, null);
    }

    public static void sendToGroup(TioConfig tioConfig, String group, Packet packet, ChannelContextFilter channelContextFilter) {
        Tio.sendToGroup(tioConfig, group, packet, channelContextFilter, false);
    }

    private static boolean sendToGroup(TioConfig tioConfig, String group, Packet packet, ChannelContextFilter channelContextFilter, boolean isBlock) {
        Set<ChannelContext> contextSet = tioConfig.groups.clients(tioConfig, group);
        if (contextSet == null) {
            log.debug("{}, \u7ec4[{}]\u4e0d\u5b58\u5728", (Object)tioConfig.getName(), (Object)group);
            return false;
        }
        return Tio.sendToSet(tioConfig, contextSet, packet, channelContextFilter, isBlock);
    }

    public static boolean sendToId(TioConfig tioConfig, String channelContextId, Packet packet) {
        return Tio.sendToId(tioConfig, channelContextId, packet, false);
    }

    private static boolean sendToId(TioConfig tioConfig, String channelContextId, Packet packet, boolean isBlock) {
        ChannelContext channelContext = Tio.getByChannelContextId(tioConfig, channelContextId);
        if (channelContext == null) {
            return false;
        }
        if (isBlock) {
            return Tio.bSend(channelContext, packet);
        }
        return Tio.send(channelContext, packet);
    }

    public static void sendToSet(TioConfig tioConfig, Set<ChannelContext> set, Packet packet, ChannelContextFilter channelContextFilter) {
        Tio.sendToSet(tioConfig, set, packet, channelContextFilter, false);
    }

    private static boolean sendToSet(TioConfig tioConfig, Set<ChannelContext> set, Packet packet, ChannelContextFilter channelContextFilter, boolean isBlock) {
        if (set == null || set.isEmpty()) {
            log.debug("{}, ChannelContext \u96c6\u5408\u4e3a\u7a7a", (Object)tioConfig.getName());
            return false;
        }
        try {
            CountDownLatch countDownLatch = null;
            if (isBlock) {
                countDownLatch = new CountDownLatch(set.size());
            }
            int sendCount = 0;
            for (ChannelContext channelContext : set) {
                boolean isFilter;
                if (channelContextFilter != null && !(isFilter = channelContextFilter.filter(channelContext))) {
                    if (!isBlock) continue;
                    countDownLatch.countDown();
                    continue;
                }
                ++sendCount;
                if (isBlock) {
                    Tio.send(channelContext, packet, countDownLatch, PacketSendMode.GROUP_BLOCK);
                    continue;
                }
                Tio.send(channelContext, packet, null, null);
            }
            if (sendCount == 0) {
                return false;
            }
            if (isBlock) {
                try {
                    long timeout = sendCount / 5;
                    timeout = Math.max(timeout, 10L);
                    boolean awaitFlag = countDownLatch.await(timeout, TimeUnit.SECONDS);
                    if (!awaitFlag) {
                        log.error("{}, \u540c\u6b65\u7fa4\u53d1\u8d85\u65f6, size:{}, timeout:{}, packet:{}", new Object[]{tioConfig.getName(), set.size(), timeout, packet.logstr()});
                        return false;
                    }
                    return true;
                }
                catch (InterruptedException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    return false;
                }
            }
            return true;
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
            return false;
        }
    }

    public static boolean sendToToken(TioConfig tioConfig, String token, Packet packet) {
        return Tio.sendToToken(tioConfig, token, packet, false);
    }

    private static boolean sendToToken(TioConfig tioConfig, String token, Packet packet, boolean isBlock) {
        Set<ChannelContext> contextSet = tioConfig.tokens.find(tioConfig, token);
        if (contextSet == null) {
            return false;
        }
        try {
            boolean ret = false;
            for (ChannelContext channelContext : contextSet) {
                boolean singleRet = isBlock ? Tio.bSend(channelContext, packet) : Tio.send(channelContext, packet);
                if (!singleRet) continue;
                ret = true;
            }
            return ret;
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
            return false;
        }
    }

    public static boolean sendToUser(TioConfig tioConfig, String userid, Packet packet) {
        return Tio.sendToUser(tioConfig, userid, packet, false);
    }

    private static boolean sendToUser(TioConfig tioConfig, String userid, Packet packet, boolean isBlock) {
        Set<ChannelContext> contextSet = tioConfig.users.find(tioConfig, userid);
        if (contextSet == null) {
            return false;
        }
        try {
            boolean ret = false;
            for (ChannelContext channelContext : contextSet) {
                boolean singleRet = isBlock ? Tio.bSend(channelContext, packet) : Tio.send(channelContext, packet);
                if (!singleRet) continue;
                ret = true;
            }
            return ret;
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
            return false;
        }
    }

    public static void unbindBsId(ChannelContext channelContext) {
        channelContext.tioConfig.bsIds.unbind(channelContext);
    }

    public static void unbindGroup(ChannelContext channelContext) {
        channelContext.tioConfig.groups.unbind(channelContext);
    }

    public static void unbindGroup(String group, ChannelContext channelContext) {
        channelContext.tioConfig.groups.unbind(group, channelContext);
    }

    public static void unbindGroup(TioConfig tioConfig, String userid, String group) {
        Set<ChannelContext> contextSet = Tio.getByUserid(tioConfig, userid);
        if (contextSet != null) {
            for (ChannelContext channelContext : contextSet) {
                Tio.unbindGroup(group, channelContext);
            }
        }
    }

    public static void unbindToken(ChannelContext channelContext) {
        channelContext.tioConfig.tokens.unbind(channelContext);
    }

    public static void unbindToken(TioConfig tioConfig, String token) {
        tioConfig.tokens.unbind(tioConfig, token);
    }

    public static void unbindUser(ChannelContext channelContext) {
        channelContext.tioConfig.users.unbind(channelContext);
    }

    public static void unbindUser(TioConfig tioConfig, String userid) {
        tioConfig.users.unbind(tioConfig, userid);
    }
}

