/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.ssl;

import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Objects;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.tio.core.ssl.ClientAuth;
import org.tio.core.ssl.SSLEngineCustomizer;
import org.tio.core.ssl.SslCertType;
import org.tio.utils.hutool.ResourceUtil;

public class SslConfig {
    private final ClientAuth clientAuth;
    private final KeyManager[] kms;
    private final TrustManager[] tms;
    private SSLEngineCustomizer sslEngineCustomizer;

    public SslConfig(TrustManager[] tms) {
        this(ClientAuth.NONE, null, tms);
    }

    public SslConfig(KeyManager[] kms, TrustManager[] tms) {
        this(ClientAuth.NONE, kms, tms);
    }

    public SslConfig(ClientAuth clientAuth, TrustManager[] tms) {
        this(clientAuth, null, tms);
    }

    public SslConfig(ClientAuth clientAuth, KeyManager[] kms, TrustManager[] tms) {
        this.clientAuth = clientAuth;
        this.kms = kms;
        this.tms = tms;
    }

    public ClientAuth getClientAuth() {
        return this.clientAuth;
    }

    public SSLContext getSslContext() {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(this.kms, this.tms, new SecureRandom());
            return sslContext;
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public SSLEngineCustomizer getSslEngineCustomizer() {
        return this.sslEngineCustomizer;
    }

    public void setSslEngineCustomizer(SSLEngineCustomizer sslEngineCustomizer) {
        this.sslEngineCustomizer = sslEngineCustomizer;
    }

    public static SslConfig forServer(String keyStoreFile, String keyPasswd) {
        return SslConfig.forServer(keyStoreFile, keyPasswd, ClientAuth.NONE);
    }

    public static SslConfig forServer(String keyStoreFile, String keyPasswd, ClientAuth clientAuth) {
        return SslConfig.forServer(keyStoreFile, keyPasswd, null, null, clientAuth);
    }

    public static SslConfig forServer(String keyStoreFile, String keyPasswd, String trustStoreFile, String trustPassword, ClientAuth clientAuth) {
        KeyManager[] kms = SslConfig.getKeyManager(keyStoreFile, keyPasswd);
        TrustManager[] tms = SslConfig.getTrustManager(trustStoreFile, trustPassword);
        return new SslConfig(clientAuth, kms, tms);
    }

    public static SslConfig forServer(InputStream keyStoreInputStream, String keyPasswd) {
        return SslConfig.forServer(keyStoreInputStream, keyPasswd, ClientAuth.NONE);
    }

    public static SslConfig forServer(SslCertType certType, InputStream keyStoreInputStream, String keyPasswd) {
        return SslConfig.forServer(certType, keyStoreInputStream, keyPasswd, ClientAuth.NONE);
    }

    public static SslConfig forServer(InputStream keyStoreInputStream, String keyPasswd, ClientAuth clientAuth) {
        return SslConfig.forServer(keyStoreInputStream, keyPasswd, null, null, clientAuth);
    }

    public static SslConfig forServer(SslCertType certType, InputStream keyStoreInputStream, String keyPasswd, ClientAuth clientAuth) {
        return SslConfig.forServer(certType, keyStoreInputStream, keyPasswd, null, null, clientAuth);
    }

    public static SslConfig forServer(InputStream keyStoreInputStream, String keyPasswd, InputStream trustStoreInputStream, String trustPassword, ClientAuth clientAuth) {
        return SslConfig.forServer(SslCertType.JKS, keyStoreInputStream, keyPasswd, trustStoreInputStream, trustPassword, clientAuth);
    }

    public static SslConfig forServer(SslCertType certType, InputStream keyStoreInputStream, String keyPasswd, InputStream trustStoreInputStream, String trustPassword, ClientAuth clientAuth) {
        KeyManager[] kms = SslConfig.getKeyManager(certType, keyStoreInputStream, keyPasswd);
        TrustManager[] tms = SslConfig.getTrustManager(trustStoreInputStream, trustPassword);
        return new SslConfig(clientAuth, kms, tms);
    }

    public static SslConfig forClient() {
        return SslConfig.forClient((InputStream)null, null);
    }

    public static SslConfig forClient(String crtFile) {
        InputStream inputStream = ResourceUtil.getClasspathOrFileResource((String)crtFile);
        return new SslConfig(SslConfig.getCrtTrustManagers(inputStream));
    }

    public static SslConfig forClient(String trustStoreFile, String trustPassword) {
        return SslConfig.forClient(null, null, trustStoreFile, trustPassword);
    }

    public static SslConfig forClient(String keyStoreFile, String keyPasswd, String trustStoreFile, String trustPassword) {
        KeyManager[] kms = SslConfig.getKeyManager(keyStoreFile, keyPasswd);
        TrustManager[] tms = SslConfig.getTrustManager(trustStoreFile, trustPassword);
        return new SslConfig(kms, tms);
    }

    public static SslConfig forClient(InputStream crtInputStream) {
        return new SslConfig(SslConfig.getCrtTrustManagers(crtInputStream));
    }

    public static SslConfig forClient(InputStream trustStoreInputStream, String trustPassword) {
        return SslConfig.forClient(null, null, trustStoreInputStream, trustPassword);
    }

    public static SslConfig forClient(InputStream keyStoreInputStream, String keyPasswd, InputStream trustStoreInputStream, String trustPassword) {
        return SslConfig.forClient(SslCertType.JKS, keyStoreInputStream, keyPasswd, trustStoreInputStream, trustPassword);
    }

    public static SslConfig forClient(SslCertType certType, InputStream keyStoreInputStream, String keyPasswd, InputStream trustStoreInputStream, String trustPassword) {
        KeyManager[] kms = SslConfig.getKeyManager(certType, keyStoreInputStream, keyPasswd);
        TrustManager[] tms = SslConfig.getTrustManager(certType, trustStoreInputStream, trustPassword);
        return new SslConfig(kms, tms);
    }

    public static KeyManager[] getKeyManager(String keyStoreFile, String keyPass) {
        SslCertType certType = SslCertType.from(keyStoreFile);
        InputStream keyStoreInputStream = ResourceUtil.getClasspathOrFileResource((String)keyStoreFile);
        return SslConfig.getKeyManager(certType, keyStoreInputStream, keyPass);
    }

    public static KeyManager[] getKeyManager(SslCertType certType, InputStream keyStoreInputStream, String keyPass) {
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            KeyStore keyStore = null;
            char[] keyPassChars = null;
            if (keyStoreInputStream != null) {
                keyPassChars = keyPass == null ? null : keyPass.toCharArray();
                keyStore = KeyStore.getInstance(certType.getType());
                try (InputStream inputStream = keyStoreInputStream;){
                    keyStore.load(inputStream, keyPassChars);
                }
            }
            keyManagerFactory.init(keyStore, keyPassChars);
            return keyManagerFactory.getKeyManagers();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static TrustManager[] getTrustManager(String trustStoreFile, String trustPass) {
        SslCertType certType = SslCertType.from(trustStoreFile);
        InputStream trustStoreInputStream = ResourceUtil.getClasspathOrFileResource((String)trustStoreFile);
        return SslConfig.getTrustManager(certType, trustStoreInputStream, trustPass);
    }

    public static TrustManager[] getTrustManager(InputStream trustInputStream, String trustPass) {
        return SslConfig.getTrustManager(SslCertType.JKS, trustInputStream, trustPass);
    }

    public static TrustManager[] getTrustManager(SslCertType certType, InputStream trustInputStream, String trustPass) {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            KeyStore keyStore = null;
            if (trustInputStream != null) {
                keyStore = KeyStore.getInstance(certType.getType());
                char[] trustPassChars = trustPass == null ? null : trustPass.toCharArray();
                try (InputStream inputStream = trustInputStream;){
                    keyStore.load(inputStream, trustPassChars);
                }
            }
            trustManagerFactory.init(keyStore);
            return trustManagerFactory.getTrustManagers();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static TrustManager[] getCrtTrustManagers(InputStream crtInputStream) {
        Objects.requireNonNull(crtInputStream, "crt \u8bc1\u4e66\u4e0d\u80fd\u4e3a null");
        try (InputStream inputStream = crtInputStream;){
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, null);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)cf.generateCertificate(inputStream);
            keyStore.setCertificateEntry("Certificate", cert);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
            return trustManagerArray;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }
}

