/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.stat;

import java.io.Serializable;
import java.util.concurrent.atomic.LongAdder;

public class GroupStat
implements Serializable {
    private static final long serialVersionUID = -6988655941470121164L;
    public final LongAdder closed = new LongAdder();
    public final LongAdder receivedPackets = new LongAdder();
    public final LongAdder receivedBytes = new LongAdder();
    public final LongAdder handledPackets = new LongAdder();
    public final LongAdder handledPacketCosts = new LongAdder();
    public final LongAdder handledBytes = new LongAdder();
    public final LongAdder sentPackets = new LongAdder();
    public final LongAdder sentBytes = new LongAdder();
    public final LongAdder receivedTcps = new LongAdder();

    public double getBytesPerTcpReceive() {
        if (this.receivedTcps.sum() == 0L) {
            return 0.0;
        }
        return this.receivedBytes.doubleValue() / this.receivedTcps.doubleValue();
    }

    public double getPacketsPerTcpReceive() {
        if (this.receivedTcps.sum() == 0L) {
            return 0.0;
        }
        return this.receivedPackets.doubleValue() / this.receivedTcps.doubleValue();
    }

    public LongAdder getClosed() {
        return this.closed;
    }

    public LongAdder getHandledBytes() {
        return this.handledBytes;
    }

    public LongAdder getHandledPackets() {
        return this.handledPackets;
    }

    public LongAdder getReceivedBytes() {
        return this.receivedBytes;
    }

    public LongAdder getReceivedPackets() {
        return this.receivedPackets;
    }

    public LongAdder getSentBytes() {
        return this.sentBytes;
    }

    public LongAdder getSentPackets() {
        return this.sentPackets;
    }

    public LongAdder getReceivedTcps() {
        return this.receivedTcps;
    }

    public LongAdder getHandledPacketCosts() {
        return this.handledPacketCosts;
    }

    public double getHandledCostsPerPacket() {
        if (this.handledPackets.sum() > 0L) {
            return this.handledPacketCosts.doubleValue() / this.handledPackets.doubleValue();
        }
        return 0.0;
    }
}

