/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.udp;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.Node;
import org.tio.core.udp.UdpPacket;
import org.tio.core.udp.UdpServerConf;
import org.tio.core.udp.task.UdpHandlerRunnable;
import org.tio.core.udp.task.UdpSendRunnable;

public class UdpServer {
    private static final Logger log = LoggerFactory.getLogger(UdpServer.class);
    private final LinkedBlockingQueue<UdpPacket> handlerQueue = new LinkedBlockingQueue();
    private final LinkedBlockingQueue<DatagramPacket> sendQueue = new LinkedBlockingQueue();
    private final DatagramSocket datagramSocket;
    private final byte[] readBuf;
    private final UdpHandlerRunnable udpHandlerRunnable;
    private final UdpSendRunnable udpSendRunnable;
    private final UdpServerConf udpServerConf;
    private volatile boolean isStopped = false;

    public UdpServer(UdpServerConf udpServerConf) throws SocketException {
        this.udpServerConf = udpServerConf;
        this.datagramSocket = new DatagramSocket(this.udpServerConf.getServerNode().getPort());
        this.readBuf = new byte[this.udpServerConf.getReadBufferSize()];
        this.udpHandlerRunnable = new UdpHandlerRunnable(udpServerConf.getUdpHandler(), this.handlerQueue, this.datagramSocket);
        this.udpSendRunnable = new UdpSendRunnable(this.sendQueue, udpServerConf, this.datagramSocket);
    }

    public void send(byte[] data, Node remoteNode) {
        InetSocketAddress inetSocketAddress = new InetSocketAddress(remoteNode.getIp(), remoteNode.getPort());
        DatagramPacket datagramPacket = new DatagramPacket(data, data.length, inetSocketAddress);
        this.sendQueue.add(datagramPacket);
    }

    public void send(String str, Node remoteNode) {
        this.send(str, StandardCharsets.UTF_8, remoteNode);
    }

    public void send(String data, Charset charset, Node remoteNode) {
        if (data == null) {
            return;
        }
        if (charset == null) {
            charset = StandardCharsets.UTF_8;
        }
        this.send(data.getBytes(charset), remoteNode);
    }

    public void start() {
        this.startListen();
        this.startHandler();
        this.startSend();
    }

    private void startHandler() {
        Thread thread = new Thread((Runnable)this.udpHandlerRunnable, "tio-udp-server-handler");
        thread.setDaemon(false);
        thread.start();
    }

    private void startListen() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                String startLog = "started tio udp server: " + UdpServer.this.udpServerConf.getServerNode();
                if (log.isInfoEnabled()) {
                    log.info(startLog);
                } else {
                    System.out.println(startLog);
                }
                while (!UdpServer.this.isStopped) {
                    try {
                        DatagramPacket datagramPacket = new DatagramPacket(UdpServer.this.readBuf, UdpServer.this.readBuf.length);
                        UdpServer.this.datagramSocket.receive(datagramPacket);
                        byte[] data = new byte[datagramPacket.getLength()];
                        System.arraycopy(UdpServer.this.readBuf, 0, data, 0, datagramPacket.getLength());
                        String remoteIp = datagramPacket.getAddress().getHostAddress();
                        int remotePort = datagramPacket.getPort();
                        Node remote = new Node(remoteIp, remotePort);
                        UdpPacket udpPacket = new UdpPacket(data, remote);
                        UdpServer.this.handlerQueue.put(udpPacket);
                    }
                    catch (Throwable e) {
                        log.error(e.getMessage(), e);
                    }
                }
            }
        };
        Thread thread = new Thread(runnable, "tio-udp-server-listen");
        thread.setDaemon(false);
        thread.start();
    }

    private void startSend() {
        Thread thread = new Thread((Runnable)this.udpSendRunnable, "tio-udp-client-send");
        thread.setDaemon(false);
        thread.start();
    }

    public void stop() {
        this.isStopped = true;
        this.datagramSocket.close();
        this.udpHandlerRunnable.stop();
    }
}

