/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.thread.pool;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class DefaultThreadFactory
implements ThreadFactory {
    private final String threadPoolName;
    private final AtomicInteger threadPoolId;
    private final int priority;

    public DefaultThreadFactory(String threadPoolName) {
        this(threadPoolName, 5);
    }

    public DefaultThreadFactory(String threadPoolName, int priority) {
        this.threadPoolName = threadPoolName;
        this.threadPoolId = new AtomicInteger();
        this.priority = priority;
    }

    public static DefaultThreadFactory getInstance(String threadName, int priority) {
        return new DefaultThreadFactory(threadName, priority);
    }

    @Override
    public Thread newThread(@NotNull Runnable r) {
        Thread thread = new Thread(r);
        thread.setName(this.threadPoolName + '-' + this.threadPoolId.incrementAndGet());
        thread.setPriority(this.priority);
        return thread;
    }
}

