/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.core;

import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import net.opentsdb.core.Aggregator;
import net.opentsdb.core.Aggregators;
import net.opentsdb.core.DataPoint;
import net.opentsdb.core.DownsamplingSpecification;
import net.opentsdb.core.FillPolicy;
import net.opentsdb.core.IllegalDataException;
import net.opentsdb.core.RateOptions;
import net.opentsdb.core.RateSpan;
import net.opentsdb.core.SeekableView;
import net.opentsdb.core.Span;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregationIterator
implements SeekableView,
DataPoint,
Aggregator.Longs,
Aggregator.Doubles {
    private static final Logger LOG = LoggerFactory.getLogger(AggregationIterator.class);
    private static final long FLAG_FLOAT = Long.MIN_VALUE;
    protected static final long TIME_MASK = Long.MAX_VALUE;
    private final Aggregator aggregator;
    private final Aggregators.Interpolation method;
    private final boolean rate;
    protected final SeekableView[] iterators;
    protected final long start_time;
    protected final long end_time;
    protected final long[] timestamps;
    protected final long[] values;
    private int current;
    private int pos;

    public static AggregationIterator create(List<Span> spans, long start_time, long end_time, Aggregator aggregator, Aggregators.Interpolation method, Aggregator downsampler, long sample_interval_ms, boolean rate, RateOptions rate_options) {
        return AggregationIterator.create(spans, start_time, end_time, aggregator, method, downsampler, sample_interval_ms, rate, rate_options, null);
    }

    public static AggregationIterator create(List<Span> spans, long start_time, long end_time, Aggregator aggregator, Aggregators.Interpolation method, Aggregator downsampler, long sample_interval_ms, boolean rate, RateOptions rate_options, FillPolicy fill_policy) {
        int size = spans.size();
        SeekableView[] iterators = new SeekableView[size];
        for (int i = 0; i < size; ++i) {
            SeekableView it = downsampler == null ? spans.get(i).spanIterator() : spans.get(i).downsampler(start_time, end_time, sample_interval_ms, downsampler, fill_policy);
            if (rate) {
                it = new RateSpan(it, rate_options);
            }
            iterators[i] = it;
        }
        return new AggregationIterator(iterators, start_time, end_time, aggregator, method, rate);
    }

    public static AggregationIterator create(List<Span> spans, long start_time, long end_time, Aggregator aggregator, Aggregators.Interpolation method, DownsamplingSpecification downsampler, long query_start, long query_end, boolean rate, RateOptions rate_options) {
        int size = spans.size();
        SeekableView[] iterators = new SeekableView[size];
        for (int i = 0; i < size; ++i) {
            SeekableView it = downsampler == null || downsampler == DownsamplingSpecification.NO_DOWNSAMPLER ? spans.get(i).spanIterator() : spans.get(i).downsampler(start_time, end_time, downsampler, query_start, query_end);
            if (rate) {
                it = new RateSpan(it, rate_options);
            }
            iterators[i] = it;
        }
        return new AggregationIterator(iterators, start_time, end_time, aggregator, method, rate);
    }

    public AggregationIterator(SeekableView[] iterators, long start_time, long end_time, Aggregator aggregator, Aggregators.Interpolation method, boolean rate) {
        LOG.debug("Aggregating {} iterators", (Object)iterators.length);
        this.iterators = iterators;
        this.start_time = start_time;
        this.end_time = end_time;
        this.aggregator = aggregator;
        this.method = method;
        this.rate = rate;
        int size = iterators.length;
        this.timestamps = new long[size * 2];
        this.values = new long[size * 2];
        int num_empty_spans = 0;
        for (int i = 0; i < size; ++i) {
            SeekableView it = iterators[i];
            it.seek(start_time);
            if (!it.hasNext()) {
                ++num_empty_spans;
                this.endReached(i);
                continue;
            }
            DataPoint dp = it.next();
            if (dp.timestamp() >= start_time) {
                this.putDataPoint(size + i, dp);
            } else {
                while (dp != null && dp.timestamp() < start_time) {
                    if (it.hasNext()) {
                        dp = it.next();
                        continue;
                    }
                    dp = null;
                }
                if (dp == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(String.format("No DP in range for #%d: start time %d", i, start_time));
                    }
                    this.endReached(i);
                    continue;
                }
                this.putDataPoint(size + i, dp);
            }
            if (!rate) continue;
            if (it.hasNext()) {
                this.moveToNext(i);
                continue;
            }
            this.endReached(i);
        }
        if (num_empty_spans > 0) {
            LOG.debug(String.format("%d out of %d spans are empty!", num_empty_spans, size));
        }
    }

    private void endReached(int i) {
        this.timestamps[this.iterators.length + i] = Long.MAX_VALUE;
        this.iterators[i] = null;
    }

    private void putDataPoint(int i, DataPoint dp) {
        this.timestamps[i] = dp.timestamp();
        if (dp.isInteger()) {
            this.values[i] = dp.longValue();
        } else {
            this.values[i] = Double.doubleToRawLongBits(dp.doubleValue());
            int n = i;
            this.timestamps[n] = this.timestamps[n] | Long.MIN_VALUE;
        }
    }

    @Override
    public boolean hasNext() {
        int size = this.iterators.length;
        for (int i = 0; i < size; ++i) {
            if ((this.timestamps[size + i] & Long.MAX_VALUE) > this.end_time) continue;
            return true;
        }
        return false;
    }

    @Override
    public DataPoint next() {
        long timestamp;
        int i;
        int size = this.iterators.length;
        long min_ts = Long.MAX_VALUE;
        for (int i2 = this.current; i2 < size; ++i2) {
            if (this.timestamps[i2 + size] != Long.MAX_VALUE) continue;
            this.timestamps[i2] = 0L;
        }
        this.current = -1;
        boolean multiple = false;
        for (i = 0; i < size; ++i) {
            timestamp = this.timestamps[size + i] & Long.MAX_VALUE;
            if (timestamp > this.end_time) continue;
            if (timestamp < min_ts) {
                min_ts = timestamp;
                this.current = i;
                multiple = false;
                continue;
            }
            if (timestamp != min_ts) continue;
            multiple = true;
        }
        if (this.current < 0) {
            throw new NoSuchElementException("no more elements");
        }
        this.moveToNext(this.current);
        if (multiple) {
            for (i = this.current + 1; i < size; ++i) {
                timestamp = this.timestamps[size + i] & Long.MAX_VALUE;
                if (timestamp != min_ts) continue;
                this.moveToNext(i);
            }
        }
        return this;
    }

    private void moveToNext(int i) {
        int next = this.iterators.length + i;
        this.timestamps[i] = this.timestamps[next];
        this.values[i] = this.values[next];
        SeekableView it = this.iterators[i];
        if (it.hasNext()) {
            this.putDataPoint(next, it.next());
        } else {
            this.endReached(i);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void seek(long timestamp) {
        for (SeekableView it : this.iterators) {
            it.seek(timestamp);
        }
    }

    @Override
    public long timestamp() {
        return this.timestamps[this.current] & Long.MAX_VALUE;
    }

    @Override
    public boolean isInteger() {
        if (this.rate) {
            return false;
        }
        for (int i = this.timestamps.length - 1; i >= 0; --i) {
            if ((this.timestamps[i] & Long.MIN_VALUE) != Long.MIN_VALUE) continue;
            return false;
        }
        return true;
    }

    @Override
    public long longValue() {
        if (this.isInteger()) {
            this.pos = -1;
            return this.aggregator.runLong(this);
        }
        throw new ClassCastException("current value is a double: " + this);
    }

    @Override
    public double doubleValue() {
        if (!this.isInteger()) {
            this.pos = -1;
            double value = this.aggregator.runDouble(this);
            if (Double.isInfinite(value)) {
                throw new IllegalStateException("Got Infinity: " + value + " in this " + this);
            }
            return value;
        }
        throw new ClassCastException("current value is a long: " + this);
    }

    @Override
    public double toDouble() {
        return this.isInteger() ? (double)this.longValue() : this.doubleValue();
    }

    @Override
    public boolean hasNextValue() {
        return this.hasNextValue(false);
    }

    private boolean hasNextValue(boolean update_pos) {
        int size = this.iterators.length;
        for (int i = this.pos + 1; i < size; ++i) {
            if (this.timestamps[i] == 0L) continue;
            if (update_pos) {
                this.pos = i;
            }
            return true;
        }
        return false;
    }

    @Override
    public long nextLongValue() {
        if (this.hasNextValue(true)) {
            long r;
            long y0 = this.values[this.pos];
            if (this.rate) {
                throw new AssertionError((Object)("Should not be here, impossible! " + this));
            }
            if (this.current == this.pos) {
                return y0;
            }
            long x = this.timestamps[this.current] & Long.MAX_VALUE;
            long x0 = this.timestamps[this.pos] & Long.MAX_VALUE;
            if (x == x0) {
                return y0;
            }
            long y1 = this.values[this.pos + this.iterators.length];
            long x1 = this.timestamps[this.pos + this.iterators.length] & Long.MAX_VALUE;
            if (x == x1) {
                return y1;
            }
            if ((x1 & 0xFFFFF00000000000L) != 0L) {
                throw new AssertionError((Object)("x1=" + x1 + " in " + this));
            }
            switch (this.method) {
                case LERP: {
                    r = y0 + (x - x0) * (y1 - y0) / (x1 - x0);
                    break;
                }
                case ZIM: {
                    r = 0L;
                    break;
                }
                case MAX: {
                    r = Long.MAX_VALUE;
                    break;
                }
                case MIN: {
                    r = Long.MIN_VALUE;
                    break;
                }
                default: {
                    throw new IllegalDataException("Invalid interpolation somehow??");
                }
            }
            return r;
        }
        throw new NoSuchElementException("no more longs in " + this);
    }

    @Override
    public double nextDoubleValue() {
        if (this.hasNextValue(true)) {
            double r;
            double y0;
            double d = y0 = (this.timestamps[this.pos] & Long.MIN_VALUE) == Long.MIN_VALUE ? Double.longBitsToDouble(this.values[this.pos]) : (double)this.values[this.pos];
            if (this.current == this.pos) {
                return y0;
            }
            if (this.rate) {
                return y0;
            }
            long x = this.timestamps[this.current] & Long.MAX_VALUE;
            long x0 = this.timestamps[this.pos] & Long.MAX_VALUE;
            if (x == x0) {
                return y0;
            }
            int next = this.pos + this.iterators.length;
            double y1 = (this.timestamps[next] & Long.MIN_VALUE) == Long.MIN_VALUE ? Double.longBitsToDouble(this.values[next]) : (double)this.values[next];
            long x1 = this.timestamps[next] & Long.MAX_VALUE;
            if (x == x1) {
                return y1;
            }
            if ((x1 & 0xFFFFF00000000000L) != 0L) {
                throw new AssertionError((Object)("x1=" + x1 + " in " + this));
            }
            switch (this.method) {
                case LERP: {
                    r = y0 + (double)(x - x0) * (y1 - y0) / (double)(x1 - x0);
                    break;
                }
                case ZIM: {
                    r = 0.0;
                    break;
                }
                case MAX: {
                    r = Double.MAX_VALUE;
                    break;
                }
                case MIN: {
                    r = Double.MIN_VALUE;
                    break;
                }
                default: {
                    throw new IllegalDataException("Invalid interploation somehow??");
                }
            }
            return r;
        }
        throw new NoSuchElementException("no more doubles in " + this);
    }

    public String toString() {
        return "SpanGroup.Iterator(timestamps=" + Arrays.toString(this.timestamps) + ", values=" + Arrays.toString(this.values) + ", current=" + this.current + ", pos=" + this.pos + ", (SpanGroup: " + this.toStringSharedAttributes() + "), iterators=" + Arrays.toString(this.iterators) + ')';
    }

    private String toStringSharedAttributes() {
        return "start_time=" + this.start_time + ", end_time=" + this.end_time + ", rate=" + this.rate + ", aggregator=" + this.aggregator + ')';
    }

    @VisibleForTesting
    static AggregationIterator createForTesting(SeekableView[] iterators, long start_time, long end_time, Aggregator aggregator, Aggregators.Interpolation method, boolean rate) {
        return new AggregationIterator(iterators, start_time, end_time, aggregator, method, rate);
    }
}

