/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.core;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Set;
import net.opentsdb.core.Aggregator;
import net.opentsdb.core.DataPoint;
import net.opentsdb.core.IllegalDataException;
import org.apache.commons.math3.stat.descriptive.rank.Percentile;
import org.apache.commons.math3.util.ResizableDoubleArray;

public final class Aggregators {
    public static final Aggregator SUM;
    public static final Aggregator MIN;
    public static final Aggregator MAX;
    public static final Aggregator AVG;
    public static final Aggregator NONE;
    public static final Aggregator MULTIPLY;
    public static final Aggregator DEV;
    public static final Aggregator ZIMSUM;
    public static final Aggregator MIMMIN;
    public static final Aggregator MIMMAX;
    public static final Aggregator COUNT;
    public static final Aggregator FIRST;
    public static final Aggregator LAST;
    private static final HashMap<String, Aggregator> aggregators;
    public static final PercentileAgg p999;
    public static final PercentileAgg p99;
    public static final PercentileAgg p95;
    public static final PercentileAgg p90;
    public static final PercentileAgg p75;
    public static final PercentileAgg p50;
    public static final PercentileAgg ep999r3;
    public static final PercentileAgg ep99r3;
    public static final PercentileAgg ep95r3;
    public static final PercentileAgg ep90r3;
    public static final PercentileAgg ep75r3;
    public static final PercentileAgg ep50r3;
    public static final PercentileAgg ep999r7;
    public static final PercentileAgg ep99r7;
    public static final PercentileAgg ep95r7;
    public static final PercentileAgg ep90r7;
    public static final PercentileAgg ep75r7;
    public static final PercentileAgg ep50r7;

    private Aggregators() {
    }

    public static Set<String> set() {
        return aggregators.keySet();
    }

    public static Aggregator get(String name) {
        Aggregator agg = aggregators.get(name);
        if (agg != null) {
            return agg;
        }
        throw new NoSuchElementException("No such aggregator: " + name);
    }

    static {
        PercentileAgg[] percentiles;
        SUM = new Sum(Interpolation.LERP, "sum");
        MIN = new Min(Interpolation.LERP, "min");
        MAX = new Max(Interpolation.LERP, "max");
        AVG = new Avg(Interpolation.LERP, "avg");
        NONE = new None(Interpolation.ZIM, "raw");
        MULTIPLY = new Multiply(Interpolation.LERP, "multiply");
        DEV = new StdDev(Interpolation.LERP, "dev");
        ZIMSUM = new Sum(Interpolation.ZIM, "zimsum");
        MIMMIN = new Min(Interpolation.MAX, "mimmin");
        MIMMAX = new Max(Interpolation.MIN, "mimmax");
        COUNT = new Count(Interpolation.ZIM, "count");
        FIRST = new First(Interpolation.ZIM, "first");
        LAST = new Last(Interpolation.ZIM, "last");
        p999 = new PercentileAgg(99.9, "p999");
        p99 = new PercentileAgg(99.0, "p99");
        p95 = new PercentileAgg(95.0, "p95");
        p90 = new PercentileAgg(90.0, "p90");
        p75 = new PercentileAgg(75.0, "p75");
        p50 = new PercentileAgg(50.0, "p50");
        ep999r3 = new PercentileAgg(99.9, "ep999r3", Percentile.EstimationType.R_3);
        ep99r3 = new PercentileAgg(99.0, "ep99r3", Percentile.EstimationType.R_3);
        ep95r3 = new PercentileAgg(95.0, "ep95r3", Percentile.EstimationType.R_3);
        ep90r3 = new PercentileAgg(90.0, "ep90r3", Percentile.EstimationType.R_3);
        ep75r3 = new PercentileAgg(75.0, "ep75r3", Percentile.EstimationType.R_3);
        ep50r3 = new PercentileAgg(50.0, "ep50r3", Percentile.EstimationType.R_3);
        ep999r7 = new PercentileAgg(99.9, "ep999r7", Percentile.EstimationType.R_7);
        ep99r7 = new PercentileAgg(99.0, "ep99r7", Percentile.EstimationType.R_7);
        ep95r7 = new PercentileAgg(95.0, "ep95r7", Percentile.EstimationType.R_7);
        ep90r7 = new PercentileAgg(90.0, "ep90r7", Percentile.EstimationType.R_7);
        ep75r7 = new PercentileAgg(75.0, "ep75r7", Percentile.EstimationType.R_7);
        ep50r7 = new PercentileAgg(50.0, "ep50r7", Percentile.EstimationType.R_7);
        aggregators = new HashMap(8);
        aggregators.put("sum", SUM);
        aggregators.put("min", MIN);
        aggregators.put("max", MAX);
        aggregators.put("avg", AVG);
        aggregators.put("none", NONE);
        aggregators.put("mult", MULTIPLY);
        aggregators.put("dev", DEV);
        aggregators.put("count", COUNT);
        aggregators.put("zimsum", ZIMSUM);
        aggregators.put("mimmin", MIMMIN);
        aggregators.put("mimmax", MIMMAX);
        aggregators.put("first", FIRST);
        aggregators.put("last", LAST);
        for (PercentileAgg agg : percentiles = new PercentileAgg[]{p999, p99, p95, p90, p75, p50, ep999r3, ep99r3, ep95r3, ep90r3, ep75r3, ep50r3, ep999r7, ep99r7, ep95r7, ep90r7, ep75r7, ep50r7}) {
            aggregators.put(agg.toString(), agg);
        }
    }

    private static final class Last
    extends Aggregator {
        public Last(Interpolation method, String name) {
            super(method, name);
        }

        @Override
        public long runLong(Aggregator.Longs values) {
            long val = values.nextLongValue();
            while (values.hasNextValue()) {
                val = values.nextLongValue();
            }
            return val;
        }

        @Override
        public double runDouble(Aggregator.Doubles values) {
            double val = values.nextDoubleValue();
            while (values.hasNextValue()) {
                val = values.nextDoubleValue();
            }
            return val;
        }
    }

    private static final class First
    extends Aggregator {
        public First(Interpolation method, String name) {
            super(method, name);
        }

        @Override
        public long runLong(Aggregator.Longs values) {
            long val = values.nextLongValue();
            while (values.hasNextValue()) {
                values.nextLongValue();
            }
            return val;
        }

        @Override
        public double runDouble(Aggregator.Doubles values) {
            double val = values.nextDoubleValue();
            while (values.hasNextValue()) {
                values.nextDoubleValue();
            }
            return val;
        }
    }

    public static final class MovingAverage
    extends Aggregator {
        private LinkedList<SumPoint> list = new LinkedList();
        private final long numPoints;
        private final boolean isTimeUnit;

        public MovingAverage(Interpolation method, String name, long numPoints, boolean isTimeUnit) {
            super(method, name);
            this.numPoints = numPoints;
            this.isTimeUnit = isTimeUnit;
        }

        @Override
        public long runLong(Aggregator.Longs values) {
            long sum = values.nextLongValue();
            while (values.hasNextValue()) {
                sum += values.nextLongValue();
            }
            if (values instanceof DataPoint) {
                long ts = ((DataPoint)((Object)values)).timestamp();
                this.list.addFirst(new SumPoint(ts, sum));
            }
            long result = 0L;
            int count = 0;
            Iterator iter = this.list.iterator();
            SumPoint first = (SumPoint)iter.next();
            boolean conditionMet = false;
            while (iter.hasNext()) {
                SumPoint next = (SumPoint)iter.next();
                result += ((Long)next.val).longValue();
                if (!this.isTimeUnit && (long)(++count) >= this.numPoints) {
                    conditionMet = true;
                    break;
                }
                if (!this.isTimeUnit || first.ts - next.ts <= this.numPoints) continue;
                conditionMet = true;
                break;
            }
            if (!conditionMet || count == 0) {
                return 0L;
            }
            return result / (long)count;
        }

        @Override
        public double runDouble(Aggregator.Doubles values) {
            double sum = values.nextDoubleValue();
            while (values.hasNextValue()) {
                sum += values.nextDoubleValue();
            }
            if (values instanceof DataPoint) {
                long ts = ((DataPoint)((Object)values)).timestamp();
                this.list.addFirst(new SumPoint(ts, sum));
            }
            double result = 0.0;
            int count = 0;
            Iterator iter = this.list.iterator();
            SumPoint first = (SumPoint)iter.next();
            boolean conditionMet = false;
            while (iter.hasNext()) {
                SumPoint next = (SumPoint)iter.next();
                result += ((Double)next.val).doubleValue();
                if (!this.isTimeUnit && (long)(++count) >= this.numPoints) {
                    conditionMet = true;
                    break;
                }
                if (!this.isTimeUnit || first.ts - next.ts <= this.numPoints) continue;
                conditionMet = true;
                break;
            }
            if (!conditionMet || count == 0) {
                return 0.0;
            }
            return result / (double)count;
        }

        class SumPoint {
            long ts;
            Object val;

            public SumPoint(long ts, Object val) {
                this.ts = ts;
                this.val = val;
            }
        }
    }

    private static final class PercentileAgg
    extends Aggregator {
        private final Double percentile;
        private final Percentile.EstimationType estimation;

        public PercentileAgg(Double percentile, String name) {
            this(percentile, name, null);
        }

        public PercentileAgg(Double percentile, String name, Percentile.EstimationType est) {
            super(Interpolation.LERP, name);
            Preconditions.checkArgument((percentile > 0.0 && percentile <= 100.0 ? 1 : 0) != 0, (Object)"Invalid percentile value");
            this.percentile = percentile;
            this.estimation = est;
        }

        @Override
        public long runLong(Aggregator.Longs values) {
            Percentile percentile = this.estimation == null ? new Percentile(this.percentile.doubleValue()) : new Percentile(this.percentile.doubleValue()).withEstimationType(this.estimation);
            ResizableDoubleArray local_values = new ResizableDoubleArray();
            while (values.hasNextValue()) {
                local_values.addElement((double)values.nextLongValue());
            }
            percentile.setData(local_values.getElements());
            return (long)percentile.evaluate();
        }

        @Override
        public double runDouble(Aggregator.Doubles values) {
            Percentile percentile = new Percentile(this.percentile.doubleValue());
            ResizableDoubleArray local_values = new ResizableDoubleArray();
            int n = 0;
            while (values.hasNextValue()) {
                double val = values.nextDoubleValue();
                if (Double.isNaN(val)) continue;
                local_values.addElement(val);
                ++n;
            }
            if (n > 0) {
                percentile.setData(local_values.getElements());
                return percentile.evaluate();
            }
            return Double.NaN;
        }
    }

    private static final class Count
    extends Aggregator {
        public Count(Interpolation method, String name) {
            super(method, name);
        }

        @Override
        public long runLong(Aggregator.Longs values) {
            long result = 0L;
            while (values.hasNextValue()) {
                values.nextLongValue();
                ++result;
            }
            return result;
        }

        @Override
        public double runDouble(Aggregator.Doubles values) {
            double result = 0.0;
            while (values.hasNextValue()) {
                double val = values.nextDoubleValue();
                if (Double.isNaN(val)) continue;
                result += 1.0;
            }
            return result;
        }
    }

    private static final class StdDev
    extends Aggregator {
        public StdDev(Interpolation method, String name) {
            super(method, name);
        }

        @Override
        public long runLong(Aggregator.Longs values) {
            double old_mean = values.nextLongValue();
            if (!values.hasNextValue()) {
                return 0L;
            }
            long n = 2L;
            double new_mean = 0.0;
            double M2 = 0.0;
            do {
                double x = values.nextLongValue();
                new_mean = old_mean + (x - old_mean) / (double)n;
                M2 += (x - old_mean) * (x - new_mean);
                old_mean = new_mean;
                ++n;
            } while (values.hasNextValue());
            return (long)Math.sqrt(M2 / (double)(n - 1L));
        }

        @Override
        public double runDouble(Aggregator.Doubles values) {
            double old_mean = values.nextDoubleValue();
            while (Double.isNaN(old_mean) && values.hasNextValue()) {
                old_mean = values.nextDoubleValue();
            }
            if (Double.isNaN(old_mean)) {
                return Double.NaN;
            }
            if (!values.hasNextValue()) {
                return 0.0;
            }
            long n = 2L;
            double new_mean = 0.0;
            double M2 = 0.0;
            do {
                double x;
                if (Double.isNaN(x = values.nextDoubleValue())) continue;
                new_mean = old_mean + (x - old_mean) / (double)n;
                M2 += (x - old_mean) * (x - new_mean);
                old_mean = new_mean;
                ++n;
            } while (values.hasNextValue());
            return 2L == n ? 0.0 : Math.sqrt(M2 / (double)(n - 1L));
        }
    }

    private static final class Multiply
    extends Aggregator {
        public Multiply(Interpolation method, String name) {
            super(method, name);
        }

        @Override
        public long runLong(Aggregator.Longs values) {
            long result = values.nextLongValue();
            while (values.hasNextValue()) {
                result *= values.nextLongValue();
            }
            return result;
        }

        @Override
        public double runDouble(Aggregator.Doubles values) {
            double result = values.nextDoubleValue();
            while (values.hasNextValue()) {
                result *= values.nextDoubleValue();
            }
            return result;
        }
    }

    private static final class None
    extends Aggregator {
        public None(Interpolation method, String name) {
            super(method, name);
        }

        @Override
        public long runLong(Aggregator.Longs values) {
            long v = values.nextLongValue();
            if (values.hasNextValue()) {
                throw new IllegalDataException("More than one value in aggregator " + values);
            }
            return v;
        }

        @Override
        public double runDouble(Aggregator.Doubles values) {
            double v = values.nextDoubleValue();
            if (values.hasNextValue()) {
                throw new IllegalDataException("More than one value in aggregator " + values);
            }
            return v;
        }
    }

    private static final class Avg
    extends Aggregator {
        public Avg(Interpolation method, String name) {
            super(method, name);
        }

        @Override
        public long runLong(Aggregator.Longs values) {
            long result = values.nextLongValue();
            int n = 1;
            while (values.hasNextValue()) {
                result += values.nextLongValue();
                ++n;
            }
            return result / (long)n;
        }

        @Override
        public double runDouble(Aggregator.Doubles values) {
            double result = 0.0;
            int n = 0;
            while (values.hasNextValue()) {
                double val = values.nextDoubleValue();
                if (Double.isNaN(val)) continue;
                result += val;
                ++n;
            }
            return 0 == n ? Double.NaN : result / (double)n;
        }
    }

    private static final class Max
    extends Aggregator {
        public Max(Interpolation method, String name) {
            super(method, name);
        }

        @Override
        public long runLong(Aggregator.Longs values) {
            long max = values.nextLongValue();
            while (values.hasNextValue()) {
                long val = values.nextLongValue();
                if (val <= max) continue;
                max = val;
            }
            return max;
        }

        @Override
        public double runDouble(Aggregator.Doubles values) {
            double max;
            double initial = values.nextDoubleValue();
            double d = max = Double.isNaN(initial) ? Double.NEGATIVE_INFINITY : initial;
            while (values.hasNextValue()) {
                double val = values.nextDoubleValue();
                if (Double.isNaN(val) || !(val > max)) continue;
                max = val;
            }
            return Double.NEGATIVE_INFINITY == max ? Double.NaN : max;
        }
    }

    private static final class Min
    extends Aggregator {
        public Min(Interpolation method, String name) {
            super(method, name);
        }

        @Override
        public long runLong(Aggregator.Longs values) {
            long min = values.nextLongValue();
            while (values.hasNextValue()) {
                long val = values.nextLongValue();
                if (val >= min) continue;
                min = val;
            }
            return min;
        }

        @Override
        public double runDouble(Aggregator.Doubles values) {
            double min;
            double initial = values.nextDoubleValue();
            double d = min = Double.isNaN(initial) ? Double.POSITIVE_INFINITY : initial;
            while (values.hasNextValue()) {
                double val = values.nextDoubleValue();
                if (Double.isNaN(val) || !(val < min)) continue;
                min = val;
            }
            return Double.POSITIVE_INFINITY == min ? Double.NaN : min;
        }
    }

    private static final class Sum
    extends Aggregator {
        public Sum(Interpolation method, String name) {
            super(method, name);
        }

        @Override
        public long runLong(Aggregator.Longs values) {
            long result = values.nextLongValue();
            while (values.hasNextValue()) {
                result += values.nextLongValue();
            }
            return result;
        }

        @Override
        public double runDouble(Aggregator.Doubles values) {
            double result = 0.0;
            long n = 0L;
            while (values.hasNextValue()) {
                double val = values.nextDoubleValue();
                if (Double.isNaN(val)) continue;
                result += val;
                ++n;
            }
            return 0L == n ? Double.NaN : result;
        }
    }

    public static enum Interpolation {
        LERP,
        ZIM,
        MAX,
        MIN;

    }
}

