/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.core;

import com.stumbleupon.async.Deferred;
import java.util.Collection;
import java.util.TreeMap;
import net.opentsdb.core.IllegalDataException;
import net.opentsdb.core.Internal;
import net.opentsdb.core.TSDB;
import net.opentsdb.utils.DateTime;
import org.hbase.async.Bytes;
import org.hbase.async.KeyValue;
import org.hbase.async.PutRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppendDataPoints {
    private static final Logger LOG = LoggerFactory.getLogger(AppendDataPoints.class);
    public static final byte APPEND_COLUMN_PREFIX = 5;
    public static final byte[] APPEND_COLUMN_QUALIFIER = new byte[]{5, 0, 0};
    public static final int REPAIR_THRESHOLD = 3600;
    private byte[] qualifier;
    private byte[] value;
    private Deferred<Object> repaired_deferred = null;

    public AppendDataPoints() {
    }

    public AppendDataPoints(byte[] qualifier, byte[] value) {
        if (qualifier == null || qualifier.length < 1) {
            throw new IllegalArgumentException("Qualifier cannot be null or empty");
        }
        if (value == null || value.length < 1) {
            throw new IllegalArgumentException("Value cannot be null or empty");
        }
        this.qualifier = qualifier;
        this.value = value;
    }

    public byte[] getBytes() {
        byte[] bytes = new byte[this.qualifier.length + this.value.length];
        System.arraycopy(this.qualifier, 0, bytes, 0, this.qualifier.length);
        System.arraycopy(this.value, 0, bytes, this.qualifier.length, this.value.length);
        return bytes;
    }

    public final Collection<Internal.Cell> parseKeyValue(TSDB tsdb, KeyValue kv) {
        long base_time;
        if (kv.qualifier().length != 3 || kv.qualifier()[0] != 5) {
            throw new IllegalArgumentException("Can not parse cell, it is not  an appended cell. It has a different qualifier " + Bytes.pretty((byte[])kv.qualifier()) + ", row key " + Bytes.pretty((byte[])kv.key()));
        }
        boolean repair = tsdb.getConfig().repair_appends();
        try {
            base_time = Internal.baseTime(tsdb, kv.key());
        }
        catch (ArrayIndexOutOfBoundsException oob) {
            throw new IllegalDataException("Corrupted value: invalid row key: " + kv, oob);
        }
        int val_idx = 0;
        int val_length = 0;
        int qual_length = 0;
        int last_delta = -1;
        TreeMap<Integer, Internal.Cell> deltas = new TreeMap<Integer, Internal.Cell>();
        boolean has_duplicates = false;
        boolean out_of_order = false;
        boolean needs_repair = false;
        try {
            while (val_idx < kv.value().length) {
                byte[] q = Internal.extractQualifier(kv.value(), val_idx);
                System.arraycopy(kv.value(), val_idx, q, 0, q.length);
                byte vlen = Internal.getValueLengthFromQualifier(q, 0);
                byte[] v = new byte[vlen];
                System.arraycopy(kv.value(), val_idx += q.length, v, 0, vlen);
                val_idx += vlen;
                int delta = Internal.getOffsetFromQualifier(q);
                Internal.Cell duplicate = (Internal.Cell)deltas.get(delta);
                if (duplicate != null) {
                    has_duplicates = true;
                    qual_length -= duplicate.qualifier.length;
                    val_length -= duplicate.value.length;
                }
                qual_length += q.length;
                val_length += vlen;
                Internal.Cell cell = new Internal.Cell(q, v);
                deltas.put(delta, cell);
                if (out_of_order) continue;
                if (delta <= last_delta) {
                    out_of_order = true;
                }
                last_delta = delta;
            }
        }
        catch (ArrayIndexOutOfBoundsException oob) {
            throw new IllegalDataException("Corrupted value: couldn't break down into individual values (consumed " + val_idx + " bytes, but was expecting to consume " + kv.value().length + "): " + kv + ", cells so far: " + deltas.values(), oob);
        }
        if ((has_duplicates || out_of_order) && DateTime.currentTimeMillis() / 1000L - base_time > 3600L) {
            needs_repair = true;
        }
        if (val_idx != kv.value().length) {
            throw new IllegalDataException("Corrupted value: couldn't break down into individual values (consumed " + val_idx + " bytes, but was expecting to consume " + kv.value().length + "): " + kv + ", cells so far: " + deltas.values());
        }
        val_idx = 0;
        int qual_idx = 0;
        byte[] healed_cell = null;
        int healed_index = 0;
        this.value = new byte[val_length];
        this.qualifier = new byte[qual_length];
        if (repair && needs_repair) {
            healed_cell = new byte[val_length + qual_length];
        }
        for (Internal.Cell cell : deltas.values()) {
            System.arraycopy(cell.qualifier, 0, this.qualifier, qual_idx, cell.qualifier.length);
            qual_idx += cell.qualifier.length;
            System.arraycopy(cell.value, 0, this.value, val_idx, cell.value.length);
            val_idx += cell.value.length;
            if (!repair || !needs_repair) continue;
            System.arraycopy(cell.qualifier, 0, healed_cell, healed_index, cell.qualifier.length);
            System.arraycopy(cell.value, 0, healed_cell, healed_index += cell.qualifier.length, cell.value.length);
            healed_index += cell.value.length;
        }
        if (repair && needs_repair) {
            LOG.debug("Repairing appended data column " + kv);
            PutRequest put = new PutRequest(tsdb.table, kv.key(), TSDB.FAMILY(), kv.qualifier(), healed_cell);
            this.repaired_deferred = tsdb.getClient().put(put);
        }
        return deltas.values();
    }

    public byte[] qualifier() {
        return this.qualifier;
    }

    public byte[] value() {
        return this.value;
    }

    public Deferred<Object> repairedDeferred() {
        return this.repaired_deferred;
    }

    public static boolean isAppendDataPoints(byte[] qualifier) {
        return qualifier != null && qualifier.length == 3 && qualifier[0] == 5;
    }
}

