/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.core;

import com.stumbleupon.async.Deferred;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.opentsdb.core.Const;
import net.opentsdb.core.DataPointsIterator;
import net.opentsdb.core.IllegalDataException;
import net.opentsdb.core.IncomingDataPoints;
import net.opentsdb.core.Internal;
import net.opentsdb.core.RowKey;
import net.opentsdb.core.SeekableView;
import net.opentsdb.core.TSDB;
import net.opentsdb.core.Tags;
import net.opentsdb.core.WritableDataPoints;
import net.opentsdb.meta.Annotation;
import org.hbase.async.Bytes;

final class BatchedDataPoints
implements WritableDataPoints {
    private final TSDB tsdb;
    private byte[] row_key;
    private long last_timestamp;
    private int size = 0;
    private byte[] batched_qualifier = new byte[14400];
    private byte[] batched_value = new byte[28800];
    private int qualifier_index = 0;
    private int value_index = 0;
    private long base_time;

    BatchedDataPoints(TSDB tsdb, String metric, Map<String, String> tags) {
        this.tsdb = tsdb;
        this.setSeries(metric, tags);
    }

    @Override
    public void setSeries(String metric, Map<String, String> tags) {
        IncomingDataPoints.checkMetricAndTags(metric, tags);
        try {
            this.row_key = IncomingDataPoints.rowKeyTemplate(this.tsdb, metric, tags);
            RowKey.prefixKeyWithSalt(this.row_key);
            this.reset();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Should never happen", e);
        }
    }

    private void reset() {
        this.size = 0;
        this.qualifier_index = 0;
        this.value_index = 0;
        this.base_time = Long.MIN_VALUE;
        this.last_timestamp = Long.MIN_VALUE;
    }

    @Override
    public Deferred<Object> persist() {
        byte[] q = Arrays.copyOfRange(this.batched_qualifier, 0, this.qualifier_index);
        byte[] v = Arrays.copyOfRange(this.batched_value, 0, this.value_index);
        byte[] r = Arrays.copyOfRange(this.row_key, 0, this.row_key.length);
        this.reset();
        return this.tsdb.put(r, q, v);
    }

    @Override
    public void setBufferingTime(short time) {
    }

    @Override
    public void setBatchImport(boolean batchornot) {
    }

    @Override
    public Deferred<Object> addPoint(long timestamp, long value) {
        byte[] v = -128L <= value && value <= 127L ? new byte[]{(byte)value} : (-32768L <= value && value <= 32767L ? Bytes.fromShort((short)((short)value)) : (Integer.MIN_VALUE <= value && value <= Integer.MAX_VALUE ? Bytes.fromInt((int)((int)value)) : Bytes.fromLong((long)value)));
        short flags = (short)(v.length - 1);
        return this.addPointInternal(timestamp, v, flags);
    }

    @Override
    public Deferred<Object> addPoint(long timestamp, float value) {
        if (Float.isNaN(value) || Float.isInfinite(value)) {
            throw new IllegalArgumentException("value is NaN or Infinite: " + value + " for timestamp=" + timestamp);
        }
        int flags = 11;
        return this.addPointInternal(timestamp, Bytes.fromInt((int)Float.floatToRawIntBits(value)), (short)11);
    }

    private Deferred<Object> addPointInternal(long timestamp, byte[] value, short flags) throws IllegalDataException {
        boolean ms_timestamp;
        boolean bl = ms_timestamp = (timestamp & 0xFFFFFFFF00000000L) != 0L;
        if (timestamp < 0L || ms_timestamp && timestamp > 9999999999999L) {
            throw new IllegalArgumentException((timestamp < 0L ? "negative " : "bad") + " timestamp=" + timestamp + " when trying to add value=" + Arrays.toString(value) + " to " + this);
        }
        if ((ms_timestamp ? timestamp : timestamp * 1000L) <= this.last_timestamp) {
            throw new IllegalArgumentException("New timestamp=" + timestamp + " is less than or equal to previous=" + this.last_timestamp + " when trying to add value=" + Arrays.toString(value) + " to " + this);
        }
        this.last_timestamp = ms_timestamp ? timestamp : timestamp * 1000L;
        long incomingBaseTime = ms_timestamp ? timestamp / 1000L - timestamp / 1000L % 3600L : timestamp - timestamp % 3600L;
        if (this.base_time == Long.MIN_VALUE) {
            this.base_time = incomingBaseTime;
            Bytes.setInt((byte[])this.row_key, (int)((int)this.base_time), (int)(this.tsdb.metrics.width() + Const.SALT_WIDTH()));
        }
        if (incomingBaseTime - this.base_time >= 3600L) {
            throw new IllegalDataException("The timestamp is beyond the boundary of this batch of data points");
        }
        if (incomingBaseTime < this.base_time) {
            throw new IllegalDataException("The timestamp is prior to the boundary of this batch of data points");
        }
        byte[] new_qualifier = Internal.buildQualifier(timestamp, flags);
        this.append(new_qualifier, value);
        ++this.size;
        return Deferred.fromResult(null);
    }

    private void ensureCapacity(byte[] next_qualifier, byte[] next_value) {
        if (this.qualifier_index + next_qualifier.length >= this.batched_qualifier.length) {
            this.batched_qualifier = Arrays.copyOf(this.batched_qualifier, this.batched_qualifier.length * 2);
        }
        if (this.value_index + next_value.length >= this.batched_value.length) {
            this.batched_value = Arrays.copyOf(this.batched_value, this.batched_value.length * 2);
        }
    }

    private void append(byte[] next_qualifier, byte[] next_value) {
        this.ensureCapacity(next_qualifier, next_value);
        System.arraycopy(next_value, 0, this.batched_value, this.value_index, next_value.length);
        this.value_index += next_value.length;
        System.arraycopy(next_qualifier, 0, this.batched_qualifier, this.qualifier_index, next_qualifier.length);
        this.qualifier_index += next_qualifier.length;
    }

    @Override
    public String metricName() {
        try {
            return (String)this.metricNameAsync().joinUninterruptibly();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Should never be here", e);
        }
    }

    @Override
    public Deferred<String> metricNameAsync() {
        if (this.row_key == null) {
            throw new IllegalStateException("Instance was not properly constructed!");
        }
        byte[] id = Arrays.copyOfRange(this.row_key, Const.SALT_WIDTH(), this.tsdb.metrics.width() + Const.SALT_WIDTH());
        return this.tsdb.metrics.getNameAsync(id);
    }

    @Override
    public byte[] metricUID() {
        return Arrays.copyOfRange(this.row_key, Const.SALT_WIDTH(), Const.SALT_WIDTH() + TSDB.metrics_width());
    }

    @Override
    public Map<String, String> getTags() {
        try {
            return (Map)this.getTagsAsync().joinUninterruptibly();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Should never be here", e);
        }
    }

    @Override
    public Bytes.ByteMap<byte[]> getTagUids() {
        return Tags.getTagUids(this.row_key);
    }

    @Override
    public Deferred<Map<String, String>> getTagsAsync() {
        return Tags.getTagsAsync(this.tsdb, this.row_key);
    }

    @Override
    public List<String> getAggregatedTags() {
        return Collections.emptyList();
    }

    @Override
    public Deferred<List<String>> getAggregatedTagsAsync() {
        List empty = Collections.emptyList();
        return Deferred.fromResult(empty);
    }

    @Override
    public List<byte[]> getAggregatedTagUids() {
        return Collections.emptyList();
    }

    @Override
    public List<String> getTSUIDs() {
        return Collections.emptyList();
    }

    @Override
    public List<Annotation> getAnnotations() {
        return null;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int aggregatedSize() {
        return 0;
    }

    @Override
    public SeekableView iterator() {
        return new DataPointsIterator(this);
    }

    private void checkIndex(int i) {
        if (i > this.size) {
            throw new IndexOutOfBoundsException("index " + i + " > " + this.size + " for this=" + this);
        }
        if (i < 0) {
            throw new IndexOutOfBoundsException("negative index " + i + " for this=" + this);
        }
    }

    private int qualifierOffset(int i) {
        int offset = 0;
        for (int j = 0; j < i; ++j) {
            offset += Internal.getQualifierLength(this.batched_qualifier, offset);
        }
        return offset;
    }

    @Override
    public long timestamp(int i) {
        this.checkIndex(i);
        return Internal.getTimestampFromQualifier(this.batched_qualifier, this.base_time, this.qualifierOffset(i));
    }

    @Override
    public boolean isInteger(int i) {
        this.checkIndex(i);
        return this.isInteger(i, this.qualifierOffset(i));
    }

    private boolean isInteger(int i, int q_offset) {
        short flags = Internal.getFlagsFromQualifier(this.batched_qualifier, q_offset);
        return (flags & 8) == 0;
    }

    @Override
    public long longValue(int i) {
        this.checkIndex(i);
        int v_offset = 0;
        int q_offset = 0;
        for (int j = 0; j < i; ++j) {
            v_offset += Internal.getValueLengthFromQualifier(this.batched_qualifier, q_offset);
            q_offset += Internal.getQualifierLength(this.batched_qualifier, q_offset);
        }
        if (this.isInteger(i, q_offset)) {
            short flags = Internal.getFlagsFromQualifier(this.batched_qualifier, q_offset);
            return Internal.extractIntegerValue(this.batched_value, v_offset, (byte)flags);
        }
        throw new ClassCastException("value #" + i + " is not a long in " + this);
    }

    @Override
    public double doubleValue(int i) {
        this.checkIndex(i);
        int v_offset = 0;
        int q_offset = 0;
        for (int j = 0; j < i; ++j) {
            v_offset += Internal.getValueLengthFromQualifier(this.batched_qualifier, q_offset);
            q_offset += Internal.getQualifierLength(this.batched_qualifier, q_offset);
        }
        if (!this.isInteger(i, q_offset)) {
            short flags = Internal.getFlagsFromQualifier(this.batched_qualifier, q_offset);
            return Internal.extractFloatingPointValue(this.batched_value, v_offset, (byte)flags);
        }
        throw new ClassCastException("value #" + i + " is not a float in " + this);
    }

    public String toString() {
        String metric = this.metricName();
        StringBuilder buf = new StringBuilder(80 + metric.length() + this.row_key.length * 4 + this.size * 16);
        buf.append("BatchedDataPoints(").append(this.row_key == null ? "<null>" : Arrays.toString(this.row_key)).append(" (metric=").append(metric).append("), base_time=").append(this.base_time).append(" (").append(this.base_time > 0L ? new Date(this.base_time * 1000L) : "no date").append("), [");
        int q_offset = 0;
        int v_offset = 0;
        for (int i = 0; i < this.size; ++i) {
            buf.append('+').append(Internal.getOffsetFromQualifier(this.batched_qualifier, q_offset));
            short flags = Internal.getFlagsFromQualifier(this.batched_qualifier, q_offset);
            if (this.isInteger(i, q_offset)) {
                buf.append(":long(").append(Internal.extractIntegerValue(this.batched_value, v_offset, (byte)flags));
            } else {
                buf.append(":float(").append(Internal.extractFloatingPointValue(this.batched_value, v_offset, (byte)flags));
            }
            buf.append(')');
            if (i != this.size - 1) {
                buf.append(", ");
            }
            v_offset += Internal.getValueLengthFromQualifier(this.batched_qualifier, q_offset);
            q_offset += Internal.getQualifierLength(this.batched_qualifier, q_offset);
        }
        buf.append("])");
        return buf.toString();
    }

    @Override
    public int getQueryIndex() {
        throw new UnsupportedOperationException("Not mapped to a query");
    }
}

