/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.core;

import java.util.ArrayList;
import java.util.Arrays;

final class ByteBufferList {
    private final ArrayList<BufferSegment> segments;
    private int total_length;

    public ByteBufferList(int n) {
        this.segments = new ArrayList(n);
    }

    public void add(byte[] buf, int offset, int len) {
        this.segments.add(new BufferSegment(buf, offset, len));
        this.total_length += len;
    }

    public byte[] getLastSegment() {
        if (this.segments.isEmpty()) {
            return null;
        }
        BufferSegment seg = this.segments.get(this.segments.size() - 1);
        return Arrays.copyOfRange(seg.buf, seg.offset, seg.offset + seg.len);
    }

    public int segmentCount() {
        return this.segments.size();
    }

    public byte[] toBytes(int padding) {
        if (padding == 0 && this.segments.size() == 1) {
            BufferSegment seg = this.segments.get(0);
            if (seg.offset == 0 && seg.len == seg.buf.length) {
                return seg.buf;
            }
            return Arrays.copyOfRange(seg.buf, seg.offset, seg.offset + seg.len);
        }
        byte[] result = new byte[this.total_length + padding];
        int ofs = 0;
        for (BufferSegment seg : this.segments) {
            System.arraycopy(seg.buf, seg.offset, result, ofs, seg.len);
            ofs += seg.len;
        }
        return result;
    }

    private static class BufferSegment {
        public final byte[] buf;
        public final int offset;
        public final int len;

        public BufferSegment(byte[] buf, int offset, int len) {
            this.buf = buf;
            this.offset = offset;
            this.len = len;
        }
    }
}

