/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.core;

import java.util.Arrays;
import net.opentsdb.core.ByteBufferList;
import net.opentsdb.core.Internal;
import org.hbase.async.KeyValue;

final class ColumnDatapointIterator
implements Comparable<ColumnDatapointIterator> {
    private final long column_timestamp;
    byte[] qualifier;
    private byte[] value;
    private boolean needs_fixup;
    private int qualifier_offset;
    private int value_offset;
    private int current_timestamp_offset;
    private int current_qual_length;
    private int current_val_length;
    private boolean is_ms;

    public boolean needsFixup() {
        return this.needs_fixup;
    }

    public ColumnDatapointIterator(KeyValue kv) {
        this.column_timestamp = kv.timestamp();
        this.qualifier = kv.qualifier();
        this.value = kv.value();
        this.qualifier_offset = 0;
        this.value_offset = 0;
        this.checkForFixup();
        this.update();
    }

    private void checkForFixup() {
        if (this.qualifier.length == 2) {
            byte lenByte;
            byte qual1 = this.qualifier[1];
            if (Internal.floatingPointValueToFix(qual1, this.value)) {
                this.value = Internal.fixFloatingPointValue(qual1, this.value);
                this.needs_fixup = true;
            }
            if ((lenByte = Internal.fixQualifierFlags(qual1, this.value.length)) != qual1) {
                this.qualifier = new byte[]{this.qualifier[0], lenByte};
                this.needs_fixup = true;
            }
        }
    }

    public boolean hasMoreData() {
        return this.qualifier_offset < this.qualifier.length;
    }

    public int getTimestampOffsetMs() {
        return this.current_timestamp_offset;
    }

    public boolean isMilliseconds() {
        return this.is_ms;
    }

    public void writeToBuffers(ByteBufferList compQualifier, ByteBufferList compValue) {
        compQualifier.add(this.qualifier, this.qualifier_offset, this.current_qual_length);
        compValue.add(this.value, this.value_offset, this.current_val_length);
    }

    public int getCurrentQualiferLength() {
        return this.current_qual_length;
    }

    public byte[] getCopyOfCurrentValue() {
        if (this.needs_fixup) {
            assert (this.value_offset == 0);
            return Internal.fixFloatingPointValue(this.qualifier[this.qualifier_offset + 1], this.value);
        }
        return Arrays.copyOfRange(this.value, this.value_offset, this.value_offset + this.current_val_length);
    }

    public boolean advance() {
        this.qualifier_offset += this.current_qual_length;
        this.value_offset += this.current_val_length;
        return this.update();
    }

    private boolean update() {
        if (this.qualifier_offset >= this.qualifier.length || this.value_offset >= this.value.length) {
            return false;
        }
        if (Internal.inMilliseconds(this.qualifier[this.qualifier_offset])) {
            this.current_qual_length = 4;
            this.is_ms = true;
        } else {
            this.current_qual_length = 2;
            this.is_ms = false;
        }
        this.current_timestamp_offset = Internal.getOffsetFromQualifier(this.qualifier, this.qualifier_offset);
        this.current_val_length = Internal.getValueLengthFromQualifier(this.qualifier, this.qualifier_offset);
        return true;
    }

    @Override
    public int compareTo(ColumnDatapointIterator o) {
        int c = this.current_timestamp_offset - o.current_timestamp_offset;
        if (c == 0) {
            c = Long.signum(o.column_timestamp - this.column_timestamp);
        }
        return c;
    }

    public String toString() {
        return "q=" + Arrays.toString(this.qualifier) + " [ofs=" + this.qualifier_offset + "], v=" + Arrays.toString(this.value) + " [ofs=" + this.value_offset + "], ts=" + this.current_timestamp_offset;
    }
}

