/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.core;

import java.nio.charset.Charset;
import java.util.TimeZone;

public final class Const {
    public static final short TIMESTAMP_BYTES = 4;
    private static short MAX_NUM_TAGS = (short)8;
    public static final Charset ASCII_CHARSET = Charset.forName("ISO-8859-1");
    public static final Charset UTF8_CHARSET = Charset.forName("UTF8");
    public static final TimeZone UTC_TZ = TimeZone.getTimeZone("UTC");
    public static final short FLAG_BITS = 4;
    public static final short MS_FLAG_BITS = 6;
    public static final short FLAG_FLOAT = 8;
    public static final short LENGTH_MASK = 7;
    public static final byte MS_BYTE_FLAG = -16;
    public static final int MS_FLAG = -268435456;
    public static final byte MS_MIXED_COMPACT = 1;
    public static final short FLAGS_MASK = 15;
    public static final long SECOND_MASK = -4294967296L;
    public static final long MILLISECOND_MASK = -17592186044416L;
    public static final short MAX_TIMESPAN = 3600;
    public static final byte[] HEX = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    public static final long MAX_INT_IN_DOUBLE = -9007199254740992L;
    public static final boolean DONT_CREATE = false;
    public static final boolean CREATE_IF_NEEDED = true;
    public static final boolean MUST_BE_WRITEABLE = true;
    private static int SALT_BUCKETS = 20;
    private static int SALT_WIDTH = 0;

    public static short MAX_NUM_TAGS() {
        return MAX_NUM_TAGS;
    }

    static void setMaxNumTags(short tags) {
        if (tags < 1) {
            throw new IllegalArgumentException("tsd.storage.max_tags must be greater than 0");
        }
        MAX_NUM_TAGS = tags;
    }

    public static int SALT_BUCKETS() {
        return SALT_BUCKETS;
    }

    static void setSaltBuckets(int buckets) {
        if (buckets < 1) {
            throw new IllegalArgumentException("Salt buckets must be greater than 0");
        }
        SALT_BUCKETS = buckets;
    }

    public static int SALT_WIDTH() {
        return SALT_WIDTH;
    }

    static void setSaltWidth(int width) {
        if (width < 0 || width > 8) {
            throw new IllegalArgumentException("Salt width must be between 0 and 8");
        }
        SALT_WIDTH = width;
    }
}

