/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.core;

import java.util.NoSuchElementException;
import net.opentsdb.core.DataPoint;
import net.opentsdb.core.DataPoints;
import net.opentsdb.core.SeekableView;

final class DataPointsIterator
implements SeekableView,
DataPoint {
    private final DataPoints dp;
    private short index = (short)-1;

    DataPointsIterator(DataPoints dp) {
        this.dp = dp;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.dp.size() - 1;
    }

    @Override
    public DataPoint next() {
        if (this.hasNext()) {
            this.index = (short)(this.index + 1);
            return this;
        }
        throw new NoSuchElementException("no more elements in " + this);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void seek(long timestamp) {
        if ((timestamp & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalArgumentException("invalid timestamp: " + timestamp);
        }
        short lo = 0;
        short hi = (short)this.dp.size();
        while (lo <= hi) {
            this.index = (short)(lo + hi >>> 1);
            long cmp = this.dp.timestamp(this.index) - timestamp;
            if (cmp < 0L) {
                lo = (short)(this.index + 1);
                continue;
            }
            if (cmp > 0L) {
                hi = (short)(this.index - 1);
                continue;
            }
            this.index = (short)(this.index - 1);
            return;
        }
        this.index = (short)(lo - 1);
        if (0 < this.index && this.index < this.dp.size() && this.dp.timestamp(this.index) >= timestamp) {
            throw new AssertionError((Object)("seeked after the time wanted! timestamp=" + timestamp + ", index=" + this.index + ", dp.timestamp(index)=" + this.dp.timestamp(this.index) + ", this=" + this));
        }
    }

    int index() {
        return this.index;
    }

    @Override
    public long timestamp() {
        return this.dp.timestamp(this.index);
    }

    @Override
    public boolean isInteger() {
        return this.dp.isInteger(this.index);
    }

    @Override
    public long longValue() {
        return this.dp.longValue(this.index);
    }

    @Override
    public double doubleValue() {
        return this.dp.doubleValue(this.index);
    }

    @Override
    public double toDouble() {
        return this.isInteger() ? (double)this.longValue() : this.doubleValue();
    }

    public String toString() {
        return "DataPointsIterator(index=" + this.index + (this.index >= 0 ? ", current type: " + (this.isInteger() ? "long" : "float") + ", current value=" + (this.isInteger() ? (double)this.longValue() : this.doubleValue()) : " (iteration not started)") + ", dp=" + this.dp + ')';
    }
}

