/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.core;

import java.util.Calendar;
import java.util.NoSuchElementException;
import net.opentsdb.core.Aggregator;
import net.opentsdb.core.Aggregators;
import net.opentsdb.core.DataPoint;
import net.opentsdb.core.DownsamplingSpecification;
import net.opentsdb.core.SeekableView;
import net.opentsdb.utils.DateTime;

public class Downsampler
implements SeekableView,
DataPoint {
    protected static final int WEEK_UNIT = DateTime.unitsToCalendarType("w");
    protected static final int DAY_UNIT = DateTime.unitsToCalendarType("d");
    protected static final int WEEK_LENGTH = 7;
    protected final DownsamplingSpecification specification;
    protected final long query_start;
    protected final long query_end;
    protected final SeekableView source;
    protected final ValuesInInterval values_in_interval;
    protected long timestamp;
    protected double value;
    protected final boolean run_all;
    protected final int interval;
    protected final int unit;

    Downsampler(SeekableView source, long interval_ms, Aggregator downsampler) {
        this.source = source;
        if (downsampler == Aggregators.NONE) {
            throw new IllegalArgumentException("cannot use the NONE aggregator for downsampling");
        }
        this.specification = new DownsamplingSpecification(interval_ms, downsampler, DownsamplingSpecification.DEFAULT_FILL_POLICY);
        this.values_in_interval = new ValuesInInterval();
        this.query_start = 0L;
        this.query_end = 0L;
        this.unit = 0;
        this.interval = 0;
        this.run_all = false;
    }

    Downsampler(SeekableView source, DownsamplingSpecification specification, long query_start, long query_end) {
        this.source = source;
        this.specification = specification;
        this.values_in_interval = new ValuesInInterval();
        this.query_start = query_start;
        this.query_end = query_end;
        String s = specification.getStringInterval();
        if (s != null && s.toLowerCase().contains("all")) {
            this.run_all = true;
            this.unit = 0;
            this.interval = 0;
        } else if (s != null && specification.useCalendar()) {
            if (s.toLowerCase().contains("ms")) {
                this.interval = Integer.parseInt(s.substring(0, s.length() - 2));
                this.unit = DateTime.unitsToCalendarType(s.substring(s.length() - 2));
            } else {
                this.interval = Integer.parseInt(s.substring(0, s.length() - 1));
                this.unit = DateTime.unitsToCalendarType(s.substring(s.length() - 1));
            }
            this.run_all = false;
        } else {
            this.run_all = false;
            this.unit = 0;
            this.interval = 0;
        }
    }

    @Override
    public boolean hasNext() {
        return this.values_in_interval.hasNextValue();
    }

    @Override
    public DataPoint next() {
        if (this.hasNext()) {
            this.value = this.specification.getFunction().runDouble(this.values_in_interval);
            this.timestamp = this.values_in_interval.getIntervalTimestamp();
            this.values_in_interval.moveToNextInterval();
            return this;
        }
        throw new NoSuchElementException("no more data points in " + this);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void seek(long timestamp) {
        this.values_in_interval.seekInterval(timestamp);
    }

    @Override
    public long timestamp() {
        if (this.run_all) {
            return this.query_start;
        }
        return this.timestamp;
    }

    @Override
    public boolean isInteger() {
        return false;
    }

    @Override
    public long longValue() {
        throw new ClassCastException("Downsampled values are doubles");
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public double toDouble() {
        return this.value;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Downsampler: ").append(", downsampler=").append(this.specification).append(", queryStart=").append(this.query_start).append(", queryEnd=").append(this.query_end).append(", runAll=").append(this.run_all).append(", current data=(timestamp=").append(this.timestamp).append(", value=").append(this.value).append("), values_in_interval=").append(this.values_in_interval);
        return buf.toString();
    }

    protected class ValuesInInterval
    implements Aggregator.Doubles {
        private Calendar previous_calendar;
        private Calendar next_calendar;
        private long timestamp_end_interval = Long.MIN_VALUE;
        private boolean has_next_value_from_source = false;
        private DataPoint next_dp = null;
        private boolean initialized = false;

        protected ValuesInInterval() {
            if (Downsampler.this.run_all) {
                this.timestamp_end_interval = Downsampler.this.query_end;
            } else if (!Downsampler.this.specification.useCalendar()) {
                this.timestamp_end_interval = Downsampler.this.specification.getInterval();
            }
        }

        protected void initializeIfNotDone() {
            if (!this.initialized) {
                this.initialized = true;
                if (Downsampler.this.source.hasNext()) {
                    this.moveToNextValue();
                    if (!Downsampler.this.run_all) {
                        if (Downsampler.this.specification.useCalendar()) {
                            this.previous_calendar = DateTime.previousInterval(this.next_dp.timestamp(), Downsampler.this.interval, Downsampler.this.unit, Downsampler.this.specification.getTimezone());
                            this.next_calendar = DateTime.previousInterval(this.next_dp.timestamp(), Downsampler.this.interval, Downsampler.this.unit, Downsampler.this.specification.getTimezone());
                            if (Downsampler.this.unit == WEEK_UNIT) {
                                this.next_calendar.add(DAY_UNIT, Downsampler.this.interval * 7);
                            } else {
                                this.next_calendar.add(Downsampler.this.unit, Downsampler.this.interval);
                            }
                            this.timestamp_end_interval = this.next_calendar.getTimeInMillis();
                        } else {
                            this.timestamp_end_interval = this.alignTimestamp(this.next_dp.timestamp()) + Downsampler.this.specification.getInterval();
                        }
                    }
                }
            }
        }

        private void moveToNextValue() {
            if (Downsampler.this.source.hasNext()) {
                this.has_next_value_from_source = true;
                if (Downsampler.this.run_all) {
                    while (Downsampler.this.source.hasNext()) {
                        this.next_dp = Downsampler.this.source.next();
                        if (this.next_dp.timestamp() < Downsampler.this.query_start) {
                            this.next_dp = null;
                            continue;
                        }
                        if (this.next_dp.timestamp() < Downsampler.this.query_end) break;
                        this.has_next_value_from_source = false;
                        break;
                    }
                    if (this.next_dp == null) {
                        this.has_next_value_from_source = false;
                    }
                } else {
                    this.next_dp = Downsampler.this.source.next();
                }
            } else {
                this.has_next_value_from_source = false;
            }
        }

        private void resetEndOfInterval() {
            if (this.has_next_value_from_source && !Downsampler.this.run_all) {
                if (Downsampler.this.specification.useCalendar()) {
                    while (this.next_dp.timestamp() >= this.timestamp_end_interval) {
                        if (Downsampler.this.unit == WEEK_UNIT) {
                            this.previous_calendar.add(DAY_UNIT, Downsampler.this.interval * 7);
                            this.next_calendar.add(DAY_UNIT, Downsampler.this.interval * 7);
                        } else {
                            this.previous_calendar.add(Downsampler.this.unit, Downsampler.this.interval);
                            this.next_calendar.add(Downsampler.this.unit, Downsampler.this.interval);
                        }
                        this.timestamp_end_interval = this.next_calendar.getTimeInMillis();
                    }
                } else {
                    this.timestamp_end_interval = this.alignTimestamp(this.next_dp.timestamp()) + Downsampler.this.specification.getInterval();
                }
            }
        }

        void moveToNextInterval() {
            this.initializeIfNotDone();
            this.resetEndOfInterval();
        }

        void seekInterval(long timestamp) {
            if (Downsampler.this.run_all) {
                Downsampler.this.source.seek(timestamp);
            } else if (Downsampler.this.specification.useCalendar()) {
                Calendar seek_calendar = DateTime.previousInterval(timestamp, Downsampler.this.interval, Downsampler.this.unit, Downsampler.this.specification.getTimezone());
                if (timestamp > seek_calendar.getTimeInMillis()) {
                    if (Downsampler.this.unit == WEEK_UNIT) {
                        seek_calendar.add(DAY_UNIT, Downsampler.this.interval * 7);
                    } else {
                        seek_calendar.add(Downsampler.this.unit, Downsampler.this.interval);
                    }
                }
                Downsampler.this.source.seek(seek_calendar.getTimeInMillis());
            } else {
                Downsampler.this.source.seek(this.alignTimestamp(timestamp + Downsampler.this.specification.getInterval() - 1L));
            }
            this.initialized = false;
        }

        protected long getIntervalTimestamp() {
            if (Downsampler.this.run_all) {
                return this.timestamp_end_interval;
            }
            if (Downsampler.this.specification.useCalendar()) {
                return this.previous_calendar.getTimeInMillis();
            }
            return this.alignTimestamp(this.timestamp_end_interval - Downsampler.this.specification.getInterval());
        }

        protected long alignTimestamp(long timestamp) {
            return timestamp - timestamp % Downsampler.this.specification.getInterval();
        }

        @Override
        public boolean hasNextValue() {
            this.initializeIfNotDone();
            if (Downsampler.this.run_all) {
                return this.has_next_value_from_source;
            }
            return this.has_next_value_from_source && this.next_dp.timestamp() < this.timestamp_end_interval;
        }

        @Override
        public double nextDoubleValue() {
            if (this.hasNextValue()) {
                double value = this.next_dp.toDouble();
                this.moveToNextValue();
                return value;
            }
            throw new NoSuchElementException("no more values in interval of " + this.timestamp_end_interval);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("ValuesInInterval: ").append(", timestamp_end_interval=").append(this.timestamp_end_interval).append(", has_next_value_from_source=").append(this.has_next_value_from_source).append(", previousCalendar=").append(this.previous_calendar == null ? "null" : this.previous_calendar).append(", nextCalendar=").append(this.next_calendar == null ? "null" : this.next_calendar);
            if (this.has_next_value_from_source) {
                buf.append(", nextValue=(").append(this.next_dp).append(')');
            }
            buf.append(", source=").append(Downsampler.this.source);
            return buf.toString();
        }
    }
}

