/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.core;

import com.google.common.base.MoreObjects;
import java.util.NoSuchElementException;
import java.util.TimeZone;
import net.opentsdb.core.Aggregator;
import net.opentsdb.core.Aggregators;
import net.opentsdb.core.FillPolicy;
import net.opentsdb.utils.DateTime;

public final class DownsamplingSpecification {
    public static final DownsamplingSpecification NO_DOWNSAMPLER = new DownsamplingSpecification();
    public static final long NO_INTERVAL = 0L;
    public static final Aggregator NO_FUNCTION = null;
    public static final FillPolicy DEFAULT_FILL_POLICY = FillPolicy.NONE;
    private final long interval;
    private final String string_interval;
    private final Aggregator function;
    private final FillPolicy fill_policy;
    private boolean use_calendar;
    private TimeZone timezone;

    private DownsamplingSpecification() {
        this.interval = 0L;
        this.function = NO_FUNCTION;
        this.fill_policy = DEFAULT_FILL_POLICY;
        this.string_interval = null;
        this.use_calendar = false;
        this.timezone = DateTime.timezones.get("UTC");
    }

    public DownsamplingSpecification(long interval, Aggregator function, FillPolicy fill_policy) {
        if (null == function) {
            throw new IllegalArgumentException("downsampling function cannot be null");
        }
        if (interval <= 0L) {
            throw new IllegalArgumentException("interval not > 0: " + interval);
        }
        if (null == fill_policy) {
            throw new IllegalArgumentException("fill policy cannot be null");
        }
        if (function == Aggregators.NONE) {
            throw new IllegalArgumentException("cannot use the NONE aggregator for downsampling");
        }
        this.interval = interval;
        this.function = function;
        this.fill_policy = fill_policy;
        this.string_interval = null;
        this.use_calendar = false;
        this.timezone = DateTime.timezones.get("UTC");
    }

    public DownsamplingSpecification(String specification) {
        if (null == specification) {
            throw new IllegalArgumentException("Downsampling specifier cannot be null");
        }
        String[] parts = specification.split("-");
        if (parts.length < 2) {
            throw new IllegalArgumentException("Invalid downsampling specifier '" + specification + "': must provide at least interval and function");
        }
        if (parts.length > 3) {
            throw new IllegalArgumentException("Invalid downsampling specifier '" + specification + "': must consist of interval, function, and optional fill policy");
        }
        if (parts[0].contains("all")) {
            this.interval = 0L;
            this.use_calendar = false;
            this.string_interval = parts[0];
        } else if (parts[0].charAt(parts[0].length() - 1) == 'c') {
            String duration = parts[0].substring(0, parts[0].length() - 1);
            this.interval = DateTime.parseDuration(duration);
            this.string_interval = duration;
            this.use_calendar = true;
        } else {
            this.interval = DateTime.parseDuration(parts[0]);
            this.use_calendar = false;
            this.string_interval = parts[0];
        }
        try {
            this.function = Aggregators.get(parts[1]);
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException("No such downsampling function: " + parts[1]);
        }
        if (this.function == Aggregators.NONE) {
            throw new IllegalArgumentException("cannot use the NONE aggregator for downsampling");
        }
        if (3 == parts.length) {
            this.fill_policy = FillPolicy.fromString(parts[2]);
            if (null == this.fill_policy) {
                StringBuilder oss = new StringBuilder();
                oss.append("No such fill policy: '").append(parts[2]).append("': must be one of:");
                for (FillPolicy policy : FillPolicy.values()) {
                    oss.append(" ").append(policy.getName());
                }
                throw new IllegalArgumentException(oss.toString());
            }
        } else {
            this.fill_policy = FillPolicy.NONE;
        }
        this.timezone = DateTime.timezones.get("UTC");
    }

    public void setUseCalendar(boolean use_calendar) {
        this.use_calendar = use_calendar;
    }

    public void setTimezone(TimeZone timezone) {
        if (timezone == null) {
            throw new IllegalArgumentException("Timezone cannot be null");
        }
        this.timezone = timezone;
    }

    public long getInterval() {
        return this.interval;
    }

    public String getStringInterval() {
        return this.string_interval;
    }

    public Aggregator getFunction() {
        return this.function;
    }

    public FillPolicy getFillPolicy() {
        return this.fill_policy;
    }

    public boolean useCalendar() {
        return this.use_calendar;
    }

    public TimeZone getTimezone() {
        return this.timezone;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("interval", this.getInterval()).add("function", (Object)this.getFunction()).add("fillPolicy", (Object)this.getFillPolicy()).add("stringInterval", (Object)this.string_interval).add("useCalendar", this.useCalendar()).add("timeZone", this.getTimezone() != null ? this.getTimezone().getID() : null).toString();
    }
}

