/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.core;

import java.util.Calendar;
import java.util.NoSuchElementException;
import net.opentsdb.core.Aggregator;
import net.opentsdb.core.DataPoint;
import net.opentsdb.core.Downsampler;
import net.opentsdb.core.DownsamplingSpecification;
import net.opentsdb.core.FillPolicy;
import net.opentsdb.core.SeekableView;
import net.opentsdb.utils.DateTime;

public class FillingDownsampler
extends Downsampler {
    protected long end_timestamp;
    private final Calendar previous_calendar;
    private final Calendar next_calendar;

    FillingDownsampler(SeekableView source, long start_time, long end_time, long interval_ms, Aggregator downsampler, FillPolicy fill_policy) {
        this(source, start_time, end_time, new DownsamplingSpecification(interval_ms, downsampler, fill_policy), 0L, 0L);
    }

    FillingDownsampler(SeekableView source, long start_time, long end_time, DownsamplingSpecification specification, long query_start, long end_start) {
        super(source, specification, query_start, end_start);
        if (FillPolicy.NONE == specification.getFillPolicy()) {
            throw new IllegalArgumentException("Cannot instantiate this class with linear-interpolation fill policy");
        }
        if (this.run_all) {
            this.timestamp = start_time;
            this.end_timestamp = end_time;
            this.next_calendar = null;
            this.previous_calendar = null;
        } else if (specification.useCalendar()) {
            this.previous_calendar = DateTime.previousInterval(start_time, this.interval, this.unit, specification.getTimezone());
            if (this.unit == WEEK_UNIT) {
                this.previous_calendar.add(DAY_UNIT, -(this.interval * 7));
            } else {
                this.previous_calendar.add(this.unit, -this.interval);
            }
            this.next_calendar = DateTime.previousInterval(start_time, this.interval, this.unit, specification.getTimezone());
            Calendar end_calendar = DateTime.previousInterval(end_time, this.interval, this.unit, specification.getTimezone());
            if (end_calendar.getTimeInMillis() == this.next_calendar.getTimeInMillis()) {
                if (this.unit == WEEK_UNIT) {
                    end_calendar.add(DAY_UNIT, this.interval * 7);
                } else {
                    end_calendar.add(this.unit, this.interval);
                }
            }
            this.timestamp = this.next_calendar.getTimeInMillis();
            this.end_timestamp = end_calendar.getTimeInMillis();
        } else {
            this.timestamp = this.values_in_interval.alignTimestamp(start_time);
            this.end_timestamp = this.values_in_interval.alignTimestamp(end_time);
            this.next_calendar = null;
            this.previous_calendar = null;
        }
    }

    @Override
    public boolean hasNext() {
        if (this.run_all) {
            return this.values_in_interval.hasNextValue();
        }
        return this.timestamp < this.end_timestamp;
    }

    @Override
    public DataPoint next() {
        if (this.hasNext()) {
            long actual;
            this.values_in_interval.initializeIfNotDone();
            long l = actual = this.values_in_interval.hasNextValue() ? this.values_in_interval.getIntervalTimestamp() : Long.MAX_VALUE;
            while (!this.run_all && this.values_in_interval.hasNextValue() && actual < this.timestamp) {
                this.specification.getFunction().runDouble(this.values_in_interval);
                this.values_in_interval.moveToNextInterval();
                actual = this.values_in_interval.getIntervalTimestamp();
            }
            if (this.run_all || actual == this.timestamp) {
                this.value = this.specification.getFunction().runDouble(this.values_in_interval);
                this.values_in_interval.moveToNextInterval();
            } else {
                switch (this.specification.getFillPolicy()) {
                    case NOT_A_NUMBER: 
                    case NULL: {
                        this.value = Double.NaN;
                        break;
                    }
                    case ZERO: {
                        this.value = 0.0;
                        break;
                    }
                    default: {
                        throw new RuntimeException("unhandled fill policy");
                    }
                }
            }
            if (!this.run_all) {
                if (this.specification.useCalendar()) {
                    if (this.unit == WEEK_UNIT) {
                        this.previous_calendar.add(DAY_UNIT, this.interval * 7);
                        this.next_calendar.add(DAY_UNIT, this.interval * 7);
                    } else {
                        this.previous_calendar.add(this.unit, this.interval);
                        this.next_calendar.add(this.unit, this.interval);
                    }
                    this.timestamp = this.next_calendar.getTimeInMillis();
                } else {
                    this.timestamp += this.specification.getInterval();
                }
            }
            return this;
        }
        throw new NoSuchElementException("no more data points in " + this);
    }

    @Override
    public long timestamp() {
        if (this.run_all) {
            return this.query_start;
        }
        if (this.specification.useCalendar()) {
            return this.previous_calendar.getTimeInMillis();
        }
        return this.timestamp - this.specification.getInterval();
    }
}

