/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.core;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class IncomingDataPoint {
    private String metric;
    private long timestamp;
    private String value;
    private HashMap<String, String> tags;
    private String tsuid;

    public IncomingDataPoint() {
    }

    public IncomingDataPoint(String metric, long timestamp, String value, HashMap<String, String> tags) {
        this.metric = metric;
        this.timestamp = timestamp;
        this.value = value;
        this.tags = tags;
    }

    public IncomingDataPoint(String tsuid, long timestamp, String value) {
        this.tsuid = tsuid;
        this.timestamp = timestamp;
        this.value = value;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("metric=").append(this.metric);
        buf.append(" ts=").append(this.timestamp);
        buf.append(" value=").append(this.value);
        if (this.tags != null) {
            for (Map.Entry<String, String> entry : this.tags.entrySet()) {
                buf.append(" ").append(entry.getKey()).append("=").append(entry.getValue());
            }
        }
        return buf.toString();
    }

    public final String getMetric() {
        return this.metric;
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    public final String getValue() {
        return this.value;
    }

    public final HashMap<String, String> getTags() {
        return this.tags;
    }

    public final String getTSUID() {
        return this.tsuid;
    }

    public final void setMetric(String metric) {
        this.metric = metric;
    }

    public final void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public final void setValue(String value) {
        this.value = value;
    }

    public final void setTags(HashMap<String, String> tags) {
        this.tags = tags;
    }

    public final void setTSUID(String tsuid) {
        this.tsuid = tsuid;
    }
}

