/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.core;

import com.stumbleupon.async.Callback;
import com.stumbleupon.async.Deferred;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.opentsdb.core.AppendDataPoints;
import net.opentsdb.core.Const;
import net.opentsdb.core.DataPointsIterator;
import net.opentsdb.core.Internal;
import net.opentsdb.core.RowKey;
import net.opentsdb.core.SeekableView;
import net.opentsdb.core.TSDB;
import net.opentsdb.core.Tags;
import net.opentsdb.core.WritableDataPoints;
import net.opentsdb.meta.Annotation;
import net.opentsdb.stats.Histogram;
import org.hbase.async.AppendRequest;
import org.hbase.async.Bytes;
import org.hbase.async.PutRequest;

final class IncomingDataPoints
implements WritableDataPoints {
    private static final short DEFAULT_BATCH_IMPORT_BUFFER_INTERVAL = 5000;
    static final Histogram putlatency = new Histogram(16000, 2, 100);
    private final TSDB tsdb;
    private final boolean allow_out_of_order_data;
    private byte[] row;
    private short[] qualifiers;
    private long[] values;
    private long last_ts;
    private short size;
    private boolean batch_import;
    private String metric;
    private Map<String, String> tags;

    IncomingDataPoints(TSDB tsdb) {
        this.tsdb = tsdb;
        this.allow_out_of_order_data = tsdb.getConfig().getBoolean("tsd.core.bulk.allow_out_of_order_timestamps");
    }

    static void checkMetricAndTags(String metric, Map<String, String> tags) {
        if (tags.size() <= 0) {
            throw new IllegalArgumentException("Need at least one tag (metric=" + metric + ", tags=" + tags + ')');
        }
        if (tags.size() > Const.MAX_NUM_TAGS()) {
            throw new IllegalArgumentException("Too many tags: " + tags.size() + " maximum allowed: " + Const.MAX_NUM_TAGS() + ", tags: " + tags);
        }
        Tags.validateString("metric name", metric);
        for (Map.Entry<String, String> tag : tags.entrySet()) {
            Tags.validateString("tag name", tag.getKey());
            Tags.validateString("tag value", tag.getValue());
        }
    }

    static byte[] rowKeyTemplate(TSDB tsdb, String metric, Map<String, String> tags) {
        short metric_width = tsdb.metrics.width();
        short tag_name_width = tsdb.tag_names.width();
        short tag_value_width = tsdb.tag_values.width();
        short num_tags = (short)tags.size();
        int row_size = Const.SALT_WIDTH() + metric_width + 4 + tag_name_width * num_tags + tag_value_width * num_tags;
        byte[] row = new byte[row_size];
        short pos = (short)Const.SALT_WIDTH();
        IncomingDataPoints.copyInRowKey(row, pos, tsdb.config.auto_metric() ? tsdb.metrics.getOrCreateId(metric) : tsdb.metrics.getId(metric));
        pos = (short)(pos + metric_width);
        pos = (short)(pos + 4);
        for (byte[] tag : Tags.resolveOrCreateAll(tsdb, tags)) {
            IncomingDataPoints.copyInRowKey(row, pos, tag);
            pos = (short)(pos + tag.length);
        }
        return row;
    }

    static Deferred<byte[]> rowKeyTemplateAsync(TSDB tsdb, String metric, Map<String, String> tags) {
        final short metric_width = tsdb.metrics.width();
        short tag_name_width = tsdb.tag_names.width();
        short tag_value_width = tsdb.tag_values.width();
        short num_tags = (short)tags.size();
        int row_size = Const.SALT_WIDTH() + metric_width + 4 + tag_name_width * num_tags + tag_value_width * num_tags;
        final byte[] row = new byte[row_size];
        final Deferred<byte[]> metric_id = tsdb.config.auto_metric() ? tsdb.metrics.getOrCreateIdAsync(metric, metric, tags) : tsdb.metrics.getIdAsync(metric);
        class CopyTagsInRowKeyCB
        implements Callback<Deferred<byte[]>, ArrayList<byte[]>> {
            CopyTagsInRowKeyCB() {
            }

            public Deferred<byte[]> call(ArrayList<byte[]> tags) {
                short pos = (short)(Const.SALT_WIDTH() + metric_width);
                pos = (short)(pos + 4);
                for (byte[] tag : tags) {
                    IncomingDataPoints.copyInRowKey(row, pos, tag);
                    pos = (short)(pos + tag.length);
                }
                class CopyMetricInRowKeyCB
                implements Callback<byte[], byte[]> {
                    final /* synthetic */ byte[] val$row;

                    CopyMetricInRowKeyCB(byte[] byArray) {
                        this.val$row = byArray;
                    }

                    public byte[] call(byte[] metricid) {
                        IncomingDataPoints.copyInRowKey(this.val$row, (short)Const.SALT_WIDTH(), metricid);
                        return this.val$row;
                    }
                }
                return metric_id.addCallback((Callback)new CopyMetricInRowKeyCB(row));
            }
        }
        return Tags.resolveOrCreateAllAsync(tsdb, metric, tags).addCallbackDeferring((Callback)new CopyTagsInRowKeyCB());
    }

    @Override
    public void setSeries(String metric, Map<String, String> tags) {
        IncomingDataPoints.checkMetricAndTags(metric, tags);
        try {
            this.row = IncomingDataPoints.rowKeyTemplate(this.tsdb, metric, tags);
            RowKey.prefixKeyWithSalt(this.row);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Should never happen", e);
        }
        this.metric = metric;
        this.tags = tags;
        this.size = 0;
    }

    private static void copyInRowKey(byte[] row, short offset, byte[] bytes) {
        System.arraycopy(bytes, 0, row, offset, bytes.length);
    }

    private long updateBaseTime(long timestamp) {
        long base_time = timestamp - timestamp % 3600L;
        this.row = Arrays.copyOf(this.row, this.row.length);
        Bytes.setInt((byte[])this.row, (int)((int)base_time), (int)(Const.SALT_WIDTH() + this.tsdb.metrics.width()));
        RowKey.prefixKeyWithSalt(this.row);
        this.tsdb.scheduleForCompaction(this.row, (int)base_time);
        return base_time;
    }

    private Deferred<Object> addPointInternal(final long timestamp, final byte[] value, final short flags) {
        final class WriteCB
        implements Callback<Deferred<Object>, Boolean> {
            WriteCB() {
            }

            public Deferred<Object> call(Boolean allowed) throws Exception {
                if (!allowed.booleanValue()) {
                    return Deferred.fromResult(null);
                }
                IncomingDataPoints.this.last_ts = ms_timestamp ? timestamp : timestamp * 1000L;
                long base_time = IncomingDataPoints.this.baseTime();
                long incoming_base_time = ms_timestamp ? timestamp / 1000L - timestamp / 1000L % 3600L : timestamp - timestamp % 3600L;
                if (incoming_base_time - base_time >= 3600L) {
                    base_time = IncomingDataPoints.this.updateBaseTime(ms_timestamp ? timestamp / 1000L : timestamp);
                }
                byte[] qualifier = Internal.buildQualifier(timestamp, flags);
                if (IncomingDataPoints.this.tsdb.getConfig().enable_appends()) {
                    AppendDataPoints kv = new AppendDataPoints(qualifier, value);
                    AppendRequest point = new AppendRequest(((IncomingDataPoints)IncomingDataPoints.this).tsdb.table, IncomingDataPoints.this.row, TSDB.FAMILY, AppendDataPoints.APPEND_COLUMN_QUALIFIER, kv.getBytes());
                    point.setDurable(!IncomingDataPoints.this.batch_import);
                    return ((IncomingDataPoints)IncomingDataPoints.this).tsdb.client.append(point);
                }
                PutRequest point = new PutRequest(((IncomingDataPoints)IncomingDataPoints.this).tsdb.table, IncomingDataPoints.this.row, TSDB.FAMILY, qualifier, value);
                point.setDurable(!IncomingDataPoints.this.batch_import);
                return ((IncomingDataPoints)IncomingDataPoints.this).tsdb.client.put(point);
            }

            public String toString() {
                return "IncomingDataPoints.addPointInternal Write Callback";
            }
        }
        boolean ms_timestamp;
        if (this.row == null) {
            throw new IllegalStateException("setSeries() never called!");
        }
        boolean bl = ms_timestamp = (timestamp & 0xFFFFFFFF00000000L) != 0L;
        if (timestamp < 0L || ms_timestamp && timestamp > 9999999999999L) {
            throw new IllegalArgumentException((timestamp < 0L ? "negative " : "bad") + " timestamp=" + timestamp + " when trying to add value=" + Arrays.toString(value) + " to " + this);
        }
        if ((ms_timestamp ? timestamp : timestamp * 1000L) <= this.last_ts) {
            if (this.allow_out_of_order_data) {
                return this.tsdb.addPointInternal(this.metric, timestamp, value, this.tags, flags);
            }
            throw new IllegalArgumentException("New timestamp=" + timestamp + " is less than or equal to previous=" + this.last_ts + " when trying to add value=" + Arrays.toString(value) + " to " + this);
        }
        if (this.tsdb.getTSfilter() != null && this.tsdb.getTSfilter().filterDataPoints()) {
            return this.tsdb.getTSfilter().allowDataPoint(this.metric, timestamp, value, this.tags, flags).addCallbackDeferring((Callback)new WriteCB());
        }
        return Deferred.fromResult((Object)true).addCallbackDeferring((Callback)new WriteCB());
    }

    private void grow() {
        int new_size = Math.min(this.size * 2, 3600);
        if (new_size == this.size) {
            throw new AssertionError((Object)("Can't grow " + this + " larger than " + this.size));
        }
        this.values = Arrays.copyOf(this.values, new_size);
        this.qualifiers = Arrays.copyOf(this.qualifiers, new_size);
    }

    private long baseTime() {
        return Bytes.getUnsignedInt((byte[])this.row, (int)(Const.SALT_WIDTH() + this.tsdb.metrics.width()));
    }

    @Override
    public Deferred<Object> addPoint(long timestamp, long value) {
        byte[] v = -128L <= value && value <= 127L ? new byte[]{(byte)value} : (-32768L <= value && value <= 32767L ? Bytes.fromShort((short)((short)value)) : (Integer.MIN_VALUE <= value && value <= Integer.MAX_VALUE ? Bytes.fromInt((int)((int)value)) : Bytes.fromLong((long)value)));
        short flags = (short)(v.length - 1);
        return this.addPointInternal(timestamp, v, flags);
    }

    @Override
    public Deferred<Object> addPoint(long timestamp, float value) {
        if (Float.isNaN(value) || Float.isInfinite(value)) {
            throw new IllegalArgumentException("value is NaN or Infinite: " + value + " for timestamp=" + timestamp);
        }
        int flags = 11;
        return this.addPointInternal(timestamp, Bytes.fromInt((int)Float.floatToRawIntBits(value)), (short)11);
    }

    @Override
    public void setBufferingTime(short time) {
        if (time < 0) {
            throw new IllegalArgumentException("negative time: " + time);
        }
        this.tsdb.client.setFlushInterval(time);
    }

    @Override
    public void setBatchImport(boolean batchornot) {
        if (this.batch_import == batchornot) {
            return;
        }
        long current_interval = this.tsdb.client.getFlushInterval();
        if (batchornot) {
            this.batch_import = true;
            if (5000L > current_interval) {
                this.setBufferingTime((short)5000);
            }
        } else {
            this.batch_import = false;
            if (current_interval == 5000L) {
                this.setBufferingTime((short)0);
            }
        }
    }

    @Override
    public String metricName() {
        try {
            return (String)this.metricNameAsync().joinUninterruptibly();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Should never be here", e);
        }
    }

    @Override
    public Deferred<String> metricNameAsync() {
        if (this.row == null) {
            throw new IllegalStateException("The row key was null, setSeries was not called.");
        }
        byte[] id = Arrays.copyOfRange(this.row, Const.SALT_WIDTH(), this.tsdb.metrics.width() + Const.SALT_WIDTH());
        return this.tsdb.metrics.getNameAsync(id);
    }

    @Override
    public byte[] metricUID() {
        return Arrays.copyOfRange(this.row, Const.SALT_WIDTH(), Const.SALT_WIDTH() + TSDB.metrics_width());
    }

    @Override
    public Map<String, String> getTags() {
        try {
            return (Map)this.getTagsAsync().joinUninterruptibly();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Should never be here", e);
        }
    }

    @Override
    public Bytes.ByteMap<byte[]> getTagUids() {
        return Tags.getTagUids(this.row);
    }

    @Override
    public Deferred<Map<String, String>> getTagsAsync() {
        return Tags.getTagsAsync(this.tsdb, this.row);
    }

    @Override
    public List<String> getAggregatedTags() {
        return Collections.emptyList();
    }

    @Override
    public Deferred<List<String>> getAggregatedTagsAsync() {
        List empty = Collections.emptyList();
        return Deferred.fromResult(empty);
    }

    @Override
    public List<byte[]> getAggregatedTagUids() {
        return Collections.emptyList();
    }

    @Override
    public List<String> getTSUIDs() {
        return Collections.emptyList();
    }

    @Override
    public List<Annotation> getAnnotations() {
        return null;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int aggregatedSize() {
        return 0;
    }

    @Override
    public SeekableView iterator() {
        return new DataPointsIterator(this);
    }

    private void checkIndex(int i) {
        if (i > this.size) {
            throw new IndexOutOfBoundsException("index " + i + " > " + this.size + " for this=" + this);
        }
        if (i < 0) {
            throw new IndexOutOfBoundsException("negative index " + i + " for this=" + this);
        }
    }

    private static short delta(short qualifier) {
        return (short)((qualifier & 0xFFFF) >>> 4);
    }

    @Override
    public long timestamp(int i) {
        this.checkIndex(i);
        return this.baseTime() + (long)(IncomingDataPoints.delta(this.qualifiers[i]) & 0xFFFF);
    }

    @Override
    public boolean isInteger(int i) {
        this.checkIndex(i);
        return (this.qualifiers[i] & 8) == 0;
    }

    @Override
    public long longValue(int i) {
        if (this.isInteger(i)) {
            return this.values[i];
        }
        throw new ClassCastException("value #" + i + " is not a long in " + this);
    }

    @Override
    public double doubleValue(int i) {
        if (!this.isInteger(i)) {
            return Float.intBitsToFloat((int)this.values[i]);
        }
        throw new ClassCastException("value #" + i + " is not a float in " + this);
    }

    public String toString() {
        String metric = this.metricName();
        StringBuilder buf = new StringBuilder(80 + metric.length() + this.row.length * 4 + this.size * 16);
        long base_time = this.baseTime();
        buf.append("IncomingDataPoints(").append(this.row == null ? "<null>" : Arrays.toString(this.row)).append(" (metric=").append(metric).append("), base_time=").append(base_time).append(" (").append(base_time > 0L ? new Date(base_time * 1000L) : "no date").append("), [");
        for (short i = 0; i < this.size; i = (short)(i + 1)) {
            buf.append('+').append(IncomingDataPoints.delta(this.qualifiers[i]));
            if (this.isInteger(i)) {
                buf.append(":long(").append(this.longValue(i));
            } else {
                buf.append(":float(").append(this.doubleValue(i));
            }
            buf.append(')');
            if (i == this.size - 1) continue;
            buf.append(", ");
        }
        buf.append("])");
        return buf.toString();
    }

    @Override
    public Deferred<Object> persist() {
        return Deferred.fromResult(null);
    }

    @Override
    public int getQueryIndex() {
        throw new UnsupportedOperationException("Not mapped to a query");
    }
}

