/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.core;

import com.stumbleupon.async.Callback;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.opentsdb.core.Const;
import net.opentsdb.core.IllegalDataException;
import net.opentsdb.core.IncomingDataPoint;
import net.opentsdb.core.Query;
import net.opentsdb.core.RowKey;
import net.opentsdb.core.RowSeq;
import net.opentsdb.core.TSDB;
import net.opentsdb.core.Tags;
import net.opentsdb.core.TsdbQuery;
import net.opentsdb.uid.UniqueId;
import org.hbase.async.Bytes;
import org.hbase.async.KeyValue;
import org.hbase.async.Scanner;

public final class Internal {
    public static final short FLAG_BITS = 4;
    public static final short LENGTH_MASK = 7;
    public static final short FLAGS_MASK = 15;

    private Internal() {
    }

    public static Scanner getScanner(Query query) {
        return ((TsdbQuery)query).getScanner();
    }

    public static List<Scanner> getScanners(Query query) {
        ArrayList<Scanner> scanners = new ArrayList<Scanner>(Const.SALT_WIDTH() > 0 ? Const.SALT_BUCKETS() : 1);
        if (Const.SALT_WIDTH() > 0) {
            for (int i = 0; i < Const.SALT_BUCKETS(); ++i) {
                scanners.add(((TsdbQuery)query).getScanner(i));
            }
        } else {
            scanners.add(((TsdbQuery)query).getScanner());
        }
        return scanners;
    }

    public static String metricName(TSDB tsdb, byte[] id) {
        return RowKey.metricName(tsdb, id);
    }

    public static long baseTime(TSDB tsdb, byte[] row) {
        return Bytes.getUnsignedInt((byte[])row, (int)(Const.SALT_WIDTH() + TSDB.metrics_width()));
    }

    public static long baseTime(long timestamp) {
        if ((timestamp & 0xFFFFFFFF00000000L) != 0L) {
            return timestamp / 1000L - timestamp / 1000L % 3600L;
        }
        return timestamp - timestamp % 3600L;
    }

    public static void setBaseTime(byte[] row, int base_time) {
        Bytes.setInt((byte[])row, (int)base_time, (int)(Const.SALT_WIDTH() + TSDB.metrics_width()));
    }

    public static Map<String, String> getTags(TSDB tsdb, byte[] row) {
        return Tags.getTags(tsdb, row);
    }

    public static long extractIntegerValue(byte[] values, int value_idx, byte flags) {
        return RowSeq.extractIntegerValue(values, value_idx, flags);
    }

    public static double extractFloatingPointValue(byte[] values, int value_idx, byte flags) {
        return RowSeq.extractFloatingPointValue(values, value_idx, flags);
    }

    public static short metricWidth(TSDB tsdb) {
        return tsdb.metrics.width();
    }

    public static Cell parseSingleValue(KeyValue column) {
        if (column.qualifier().length == 2 || column.qualifier().length == 4 && Internal.inMilliseconds(column.qualifier())) {
            ArrayList<KeyValue> row = new ArrayList<KeyValue>(1);
            row.add(column);
            ArrayList<Cell> cells = Internal.extractDataPoints(row, 1);
            if (cells.isEmpty()) {
                return null;
            }
            return cells.get(0);
        }
        throw new IllegalDataException("Qualifier does not appear to be a single data point: " + column);
    }

    public static ArrayList<Cell> extractDataPoints(KeyValue column) {
        ArrayList<KeyValue> row = new ArrayList<KeyValue>(1);
        row.add(column);
        return Internal.extractDataPoints(row, column.qualifier().length / 2);
    }

    public static ArrayList<Cell> extractDataPoints(ArrayList<KeyValue> row, int estimated_nvalues) {
        ArrayList<Cell> cells = new ArrayList<Cell>(estimated_nvalues);
        for (KeyValue kv : row) {
            byte[] qual = kv.qualifier();
            int len = qual.length;
            byte[] val = kv.value();
            if (len % 2 != 0) continue;
            if (len == 2) {
                byte[] actual_val = Internal.fixFloatingPointValue(qual[1], val);
                byte q = Internal.fixQualifierFlags(qual[1], actual_val.length);
                byte[] actual_qual = q != qual[1] ? new byte[]{qual[0], q} : qual;
                Cell cell = new Cell(actual_qual, actual_val);
                cells.add(cell);
                continue;
            }
            if (len == 4 && Internal.inMilliseconds(qual[0])) {
                Cell cell = new Cell(qual, val);
                cells.add(cell);
                continue;
            }
            int val_idx = 0;
            try {
                for (int i = 0; i < len; i += 2) {
                    byte[] q = Internal.extractQualifier(qual, i);
                    byte vlen = Internal.getValueLengthFromQualifier(qual, i);
                    if (Internal.inMilliseconds(qual[i])) {
                        i += 2;
                    }
                    byte[] v = new byte[vlen];
                    System.arraycopy(val, val_idx, v, 0, vlen);
                    val_idx += vlen;
                    Cell cell = new Cell(q, v);
                    cells.add(cell);
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IllegalDataException("Corrupted value: couldn't break down into individual values (consumed " + val_idx + " bytes, but was expecting to consume " + (val.length - 1) + "): " + kv + ", cells so far: " + cells);
            }
            if (val_idx == val.length - 1) continue;
            throw new IllegalDataException("Corrupted value: couldn't break down into individual values (consumed " + val_idx + " bytes, but was expecting to consume " + (val.length - 1) + "): " + kv + ", cells so far: " + cells);
        }
        Collections.sort(cells);
        return cells;
    }

    public static int compareQualifiers(byte[] a, int offset_a, byte[] b, int offset_b) {
        long right;
        long left = Internal.getOffsetFromQualifier(a, offset_a);
        if (left == (right = (long)Internal.getOffsetFromQualifier(b, offset_b))) {
            return 0;
        }
        return left < right ? -1 : 1;
    }

    public static byte fixQualifierFlags(byte flags, int val_len) {
        return (byte)(flags & 0xFFFFFFF8 | val_len - 1);
    }

    public static boolean floatingPointValueToFix(byte flags, byte[] value) {
        return (flags & 8) != 0 && (flags & 7) == 3 && value.length == 8;
    }

    public static byte[] fixFloatingPointValue(byte flags, byte[] value) {
        if (Internal.floatingPointValueToFix(flags, value)) {
            if (value[0] == 0 && value[1] == 0 && value[2] == 0 && value[3] == 0) {
                return new byte[]{value[4], value[5], value[6], value[7]};
            }
            throw new IllegalDataException("Corrupted floating point value: " + Arrays.toString(value) + " flags=0x" + Integer.toHexString(flags) + " -- first 4 bytes are expected to be zeros.");
        }
        return value;
    }

    public static boolean inMilliseconds(byte[] qualifier, int offset) {
        return Internal.inMilliseconds(qualifier[offset]);
    }

    public static boolean inMilliseconds(byte[] qualifier) {
        return Internal.inMilliseconds(qualifier[0]);
    }

    public static boolean inMilliseconds(byte qualifier) {
        return (qualifier & 0xFFFFFFF0) == -16;
    }

    public static int getOffsetFromQualifier(byte[] qualifier) {
        return Internal.getOffsetFromQualifier(qualifier, 0);
    }

    public static int getOffsetFromQualifier(byte[] qualifier, int offset) {
        Internal.validateQualifier(qualifier, offset);
        if ((qualifier[offset] & 0xFFFFFFF0) == -16) {
            return (int)(Bytes.getUnsignedInt((byte[])qualifier, (int)offset) & 0xFFFFFC0L) >>> 6;
        }
        int seconds = (Bytes.getUnsignedShort((byte[])qualifier, (int)offset) & 0xFFFF) >>> 4;
        return seconds * 1000;
    }

    public static byte getValueLengthFromQualifier(byte[] qualifier) {
        return Internal.getValueLengthFromQualifier(qualifier, 0);
    }

    public static byte getValueLengthFromQualifier(byte[] qualifier, int offset) {
        Internal.validateQualifier(qualifier, offset);
        short length = (qualifier[offset] & 0xFFFFFFF0) == -16 ? (short)(qualifier[offset + 3] & 7) : (short)(qualifier[offset + 1] & 7);
        return (byte)(length + 1);
    }

    public static short getQualifierLength(byte[] qualifier) {
        return Internal.getQualifierLength(qualifier, 0);
    }

    public static short getQualifierLength(byte[] qualifier, int offset) {
        Internal.validateQualifier(qualifier, offset);
        if ((qualifier[offset] & 0xFFFFFFF0) == -16) {
            if (offset + 4 > qualifier.length) {
                throw new IllegalArgumentException("Detected a millisecond flag but qualifier length is too short");
            }
            return 4;
        }
        if (offset + 2 > qualifier.length) {
            throw new IllegalArgumentException("Qualifier length is too short");
        }
        return 2;
    }

    public static long getTimestampFromQualifier(byte[] qualifier, long base_time) {
        return base_time * 1000L + (long)Internal.getOffsetFromQualifier(qualifier);
    }

    public static long getTimestampFromQualifier(byte[] qualifier, long base_time, int offset) {
        return base_time * 1000L + (long)Internal.getOffsetFromQualifier(qualifier, offset);
    }

    public static short getFlagsFromQualifier(byte[] qualifier) {
        return Internal.getFlagsFromQualifier(qualifier, 0);
    }

    public static short getFlagsFromQualifier(byte[] qualifier, int offset) {
        Internal.validateQualifier(qualifier, offset);
        if ((qualifier[offset] & 0xFFFFFFF0) == -16) {
            return (short)(qualifier[offset + 3] & 0xF);
        }
        return (short)(qualifier[offset + 1] & 0xF);
    }

    public static boolean isFloat(byte[] qualifier) {
        return Internal.isFloat(qualifier, 0);
    }

    public static boolean isFloat(byte[] qualifier, int offset) {
        Internal.validateQualifier(qualifier, offset);
        if ((qualifier[offset] & 0xFFFFFFF0) == -16) {
            return (qualifier[offset + 3] & 8) == 8;
        }
        return (qualifier[offset + 1] & 8) == 8;
    }

    public static byte[] extractQualifier(byte[] qualifier, int offset) {
        Internal.validateQualifier(qualifier, offset);
        if ((qualifier[offset] & 0xFFFFFFF0) == -16) {
            return new byte[]{qualifier[offset], qualifier[offset + 1], qualifier[offset + 2], qualifier[offset + 3]};
        }
        return new byte[]{qualifier[offset], qualifier[offset + 1]};
    }

    public static byte[] buildQualifier(long timestamp, short flags) {
        if ((timestamp & 0xFFFFFFFF00000000L) != 0L) {
            long base_time = timestamp / 1000L - timestamp / 1000L % 3600L;
            int qual = (int)(timestamp - base_time * 1000L << 6 | (long)flags | 0xFFFFFFFFF0000000L);
            return Bytes.fromInt((int)qual);
        }
        long base_time = timestamp - timestamp % 3600L;
        short qual = (short)(timestamp - base_time << 4 | (long)flags);
        return Bytes.fromShort((short)qual);
    }

    private static void validateQualifier(byte[] qualifier, int offset) {
        if (offset < 0 || offset >= qualifier.length - 1) {
            throw new IllegalDataException("Offset of [" + offset + "] is out of bounds for the qualifier length of [" + qualifier.length + "]");
        }
    }

    public static void createAndSetTSUIDFilter(Scanner scanner, List<String> tsuids) {
        Object tags;
        Collections.sort(tsuids);
        short metric_width = TSDB.metrics_width();
        int tags_length = 0;
        ArrayList<byte[]> uids = new ArrayList<byte[]>(tsuids.size());
        for (String tsuid : tsuids) {
            tags = tsuid.substring(metric_width * 2);
            byte[] tag_bytes = UniqueId.stringToUid((String)tags);
            tags_length += tag_bytes.length;
            uids.add(tag_bytes);
        }
        StringBuilder buf = new StringBuilder(13 + tsuids.size() * 11 + tags_length);
        buf.append("(?s)^.{").append(Const.SALT_WIDTH() + metric_width + 4).append("}(");
        Iterator iterator = uids.iterator();
        while (iterator.hasNext()) {
            tags = (byte[])iterator.next();
            buf.append("\\Q");
            UniqueId.addIdToRegexp(buf, (byte[])tags);
            buf.append('|');
        }
        buf.setCharAt(buf.length() - 1, ')');
        buf.append("$");
        scanner.setKeyRegexp(buf.toString(), Charset.forName("ISO-8859-1"));
    }

    public static long getMaxUnsignedValueOnBytes(int width) {
        if (width < 0 || width > 8) {
            throw new IllegalArgumentException("Width must be from 1 to 8 bytes: " + width);
        }
        if (width < 8) {
            return (1L << width * 8) - 1L;
        }
        return Long.MAX_VALUE;
    }

    public static class GetLastDataPointCB
    implements Callback<IncomingDataPoint, ArrayList<KeyValue>> {
        final TSDB tsdb;

        public GetLastDataPointCB(TSDB tsdb) {
            this.tsdb = tsdb;
        }

        public IncomingDataPoint call(ArrayList<KeyValue> row) throws Exception {
            if (row == null || row.size() < 1) {
                return null;
            }
            ArrayList<Cell> cells = Internal.extractDataPoints(row, row.size());
            if (cells.isEmpty()) {
                return null;
            }
            Cell cell = cells.get(cells.size() - 1);
            IncomingDataPoint dp = new IncomingDataPoint();
            long base_time = Internal.baseTime(this.tsdb, row.get(0).key());
            dp.setTimestamp(Internal.getTimestampFromQualifier(cell.qualifier(), base_time));
            dp.setValue(cell.parseValue().toString());
            return dp;
        }
    }

    public static final class KeyValueComparator
    implements Comparator<KeyValue> {
        @Override
        public int compare(KeyValue a, KeyValue b) {
            return Internal.compareQualifiers(a.qualifier(), 0, b.qualifier(), 0);
        }
    }

    public static final class Cell
    implements Comparable<Cell> {
        public static final Cell SKIP = new Cell(null, null);
        final byte[] qualifier;
        final byte[] value;

        public Cell(byte[] qualifier, byte[] value) {
            this.qualifier = qualifier;
            this.value = value;
        }

        @Override
        public int compareTo(Cell other) {
            return Internal.compareQualifiers(this.qualifier, 0, other.qualifier, 0);
        }

        public boolean equals(Object o) {
            return o != null && o instanceof Cell && this.compareTo((Cell)o) == 0;
        }

        public int hashCode() {
            return Arrays.hashCode(this.qualifier);
        }

        public String toString() {
            return "Cell(" + Arrays.toString(this.qualifier) + ", " + Arrays.toString(this.value) + ')';
        }

        public byte[] qualifier() {
            return this.qualifier;
        }

        public byte[] value() {
            return this.value;
        }

        public Number parseValue() {
            if (this.isInteger()) {
                return Internal.extractIntegerValue(this.value, 0, (byte)Internal.getFlagsFromQualifier(this.qualifier));
            }
            return Internal.extractFloatingPointValue(this.value, 0, (byte)Internal.getFlagsFromQualifier(this.qualifier));
        }

        public long timestamp(long base_time) {
            return Internal.getTimestampFromQualifier(this.qualifier, base_time);
        }

        public long absoluteTimestamp(long base_time) {
            long timestamp = Internal.getTimestampFromQualifier(this.qualifier, base_time);
            if (Internal.inMilliseconds(this.qualifier)) {
                return timestamp;
            }
            return timestamp / 1000L;
        }

        public boolean isInteger() {
            return (Internal.getFlagsFromQualifier(this.qualifier) & 8) == 0;
        }
    }
}

