/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.core;

import net.opentsdb.core.DataPoint;

public final class MutableDataPoint
implements DataPoint {
    private long timestamp = Long.MAX_VALUE;
    private boolean is_integer = true;
    private long value = 0L;

    public void reset(long timestamp, double value) {
        this.timestamp = timestamp;
        this.is_integer = false;
        this.value = Double.doubleToRawLongBits(value);
    }

    public void reset(long timestamp, long value) {
        this.timestamp = timestamp;
        this.is_integer = true;
        this.value = value;
    }

    public void reset(DataPoint dp) {
        this.timestamp = dp.timestamp();
        this.is_integer = dp.isInteger();
        this.value = this.is_integer ? dp.longValue() : Double.doubleToRawLongBits(dp.doubleValue());
    }

    public static MutableDataPoint ofDoubleValue(long timestamp, double value) {
        MutableDataPoint dp = new MutableDataPoint();
        dp.reset(timestamp, value);
        return dp;
    }

    public static MutableDataPoint ofLongValue(long timestamp, long value) {
        MutableDataPoint dp = new MutableDataPoint();
        dp.reset(timestamp, value);
        return dp;
    }

    public static MutableDataPoint fromPoint(DataPoint value) {
        if (value.isInteger()) {
            return MutableDataPoint.ofLongValue(value.timestamp(), value.longValue());
        }
        return MutableDataPoint.ofDoubleValue(value.timestamp(), value.doubleValue());
    }

    @Override
    public long timestamp() {
        return this.timestamp;
    }

    @Override
    public boolean isInteger() {
        return this.is_integer;
    }

    @Override
    public long longValue() {
        if (this.is_integer) {
            return this.value;
        }
        throw new ClassCastException("Not a long in " + this.toString());
    }

    @Override
    public double doubleValue() {
        if (!this.is_integer) {
            return Double.longBitsToDouble(this.value);
        }
        throw new ClassCastException("Not a double in " + this.toString());
    }

    @Override
    public double toDouble() {
        if (this.is_integer) {
            return this.value;
        }
        return Double.longBitsToDouble(this.value);
    }

    public String toString() {
        return "MutableDataPoint(timestamp=" + this.timestamp + ", is_integer=" + this.is_integer + ", value=" + (this.is_integer ? (double)this.value : Double.longBitsToDouble(this.value)) + ")";
    }
}

