/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.core;

import com.google.common.base.Objects;

public class RateOptions {
    public static final long DEFAULT_RESET_VALUE = 0L;
    private boolean counter;
    private boolean drop_resets;
    private long counter_max;
    private long reset_value;

    public RateOptions() {
        this.counter = false;
        this.counter_max = Long.MAX_VALUE;
        this.reset_value = 0L;
        this.drop_resets = false;
    }

    public RateOptions(boolean counter, long counter_max, long reset_value) {
        this(counter, counter_max, reset_value, false);
    }

    public RateOptions(boolean counter, long counter_max, long reset_value, boolean drop_resets) {
        this.counter = counter;
        this.counter_max = counter_max;
        this.reset_value = reset_value;
        this.drop_resets = drop_resets;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.counter, this.counter_max, this.reset_value, this.drop_resets});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RateOptions)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        RateOptions options = (RateOptions)obj;
        return Objects.equal((Object)this.counter, (Object)options.counter) && Objects.equal((Object)this.counter_max, (Object)options.counter_max) && Objects.equal((Object)this.reset_value, (Object)options.reset_value) && Objects.equal((Object)this.drop_resets, (Object)options.drop_resets);
    }

    public boolean isCounter() {
        return this.counter;
    }

    public long getCounterMax() {
        return this.counter_max;
    }

    public long getResetValue() {
        return this.reset_value;
    }

    public boolean getDropResets() {
        return this.drop_resets;
    }

    public void setIsCounter(boolean counter) {
        this.counter = counter;
    }

    public void setCounterMax(long counter_max) {
        this.counter_max = counter_max;
    }

    public void setResetValue(long reset_value) {
        this.reset_value = reset_value;
    }

    public void setDropResets(boolean drop_resets) {
        this.drop_resets = drop_resets;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('{');
        buf.append(this.counter);
        buf.append(',').append(this.counter_max);
        buf.append(',').append(this.reset_value);
        buf.append('}');
        return buf.toString();
    }
}

