/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.core;

import java.util.NoSuchElementException;
import net.opentsdb.core.DataPoint;
import net.opentsdb.core.MutableDataPoint;
import net.opentsdb.core.RateOptions;
import net.opentsdb.core.SeekableView;

public class RateSpan
implements SeekableView {
    private static long INVALID_TIMESTAMP = Long.MAX_VALUE;
    private final SeekableView source;
    private final RateOptions options;
    private final MutableDataPoint next_data = new MutableDataPoint();
    private final MutableDataPoint next_rate = new MutableDataPoint();
    private final MutableDataPoint prev_rate = new MutableDataPoint();
    private boolean initialized = false;

    RateSpan(SeekableView source, RateOptions options) {
        this.source = source;
        this.options = options;
    }

    @Override
    public boolean hasNext() {
        this.initializeIfNotDone();
        return this.next_rate.timestamp() != INVALID_TIMESTAMP;
    }

    @Override
    public DataPoint next() {
        this.initializeIfNotDone();
        if (this.hasNext()) {
            this.prev_rate.reset(this.next_rate);
            this.populateNextRate();
            return this.prev_rate;
        }
        throw new NoSuchElementException("no more values for " + this.toString());
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void seek(long timestamp) {
        this.source.seek(timestamp);
        this.initialized = false;
    }

    private void initializeIfNotDone() {
        if (!this.initialized) {
            this.initialized = true;
            this.next_data.reset(0L, 0L);
            this.populateNextRate();
        }
    }

    private void populateNextRate() {
        MutableDataPoint prev_data = new MutableDataPoint();
        if (this.source.hasNext()) {
            prev_data.reset(this.next_data);
            this.next_data.reset(this.source.next());
            long t0 = prev_data.timestamp();
            long t1 = this.next_data.timestamp();
            if (t1 <= t0) {
                throw new IllegalStateException("Next timestamp (" + t1 + ") is supposed to be  strictly greater than the previous one (" + t0 + "), but it's not.  this=" + this);
            }
            double time_delta_secs = (double)(t1 - t0) / 1000.0;
            double difference = prev_data.isInteger() && this.next_data.isInteger() ? (double)(this.next_data.longValue() - prev_data.longValue()) : this.next_data.toDouble() - prev_data.toDouble();
            if (this.options.isCounter() && difference < 0.0) {
                if (this.options.getDropResets()) {
                    this.populateNextRate();
                    return;
                }
                difference = prev_data.isInteger() && this.next_data.isInteger() ? (double)(this.options.getCounterMax() - prev_data.longValue() + this.next_data.longValue()) : (double)this.options.getCounterMax() - prev_data.toDouble() + this.next_data.toDouble();
                double rate = difference / time_delta_secs;
                if (this.options.getResetValue() > 0L && rate > (double)this.options.getResetValue()) {
                    this.next_rate.reset(this.next_data.timestamp(), 0.0);
                } else {
                    this.next_rate.reset(this.next_data.timestamp(), rate);
                }
            } else {
                this.next_rate.reset(this.next_data.timestamp(), difference / time_delta_secs);
            }
        } else {
            this.next_rate.reset(INVALID_TIMESTAMP, 0L);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("RateSpan: ").append(", options=").append(this.options).append(", next_data=[").append(this.next_data).append("], next_rate=[").append(this.next_rate).append("], prev_rate=[").append(this.prev_rate).append("], source=[").append(this.source).append("]");
        return buf.toString();
    }
}

