/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.core;

import com.stumbleupon.async.Deferred;
import java.util.Arrays;
import java.util.Comparator;
import net.opentsdb.core.Const;
import net.opentsdb.core.TSDB;
import org.hbase.async.Bytes;

public final class RowKey {
    private RowKey() {
    }

    static String metricName(TSDB tsdb, byte[] row) {
        try {
            return (String)RowKey.metricNameAsync(tsdb, row).joinUninterruptibly();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Should never be here", e);
        }
    }

    public static Deferred<String> metricNameAsync(TSDB tsdb, byte[] row) {
        if (row == null || row.length < 1) {
            throw new IllegalArgumentException("Row key cannot be null or empty");
        }
        if (row.length < Const.SALT_WIDTH() + tsdb.metrics.width()) {
            throw new IllegalArgumentException("Row key is too short");
        }
        byte[] id = Arrays.copyOfRange(row, Const.SALT_WIDTH(), tsdb.metrics.width() + Const.SALT_WIDTH());
        return tsdb.metrics.getNameAsync(id);
    }

    public static byte[] rowKeyFromTSUID(TSDB tsdb, byte[] tsuid, long timestamp) {
        if (tsuid.length < tsdb.metrics.width()) {
            throw new IllegalArgumentException("TSUID appears to be missing the metric");
        }
        long base_time = (timestamp & 0xFFFFFFFF00000000L) != 0L ? timestamp / 1000L - timestamp / 1000L % 3600L : timestamp - timestamp % 3600L;
        byte[] row = new byte[Const.SALT_WIDTH() + tsuid.length + 4];
        System.arraycopy(tsuid, 0, row, Const.SALT_WIDTH(), tsdb.metrics.width());
        Bytes.setInt((byte[])row, (int)((int)base_time), (int)(Const.SALT_WIDTH() + tsdb.metrics.width()));
        System.arraycopy(tsuid, tsdb.metrics.width(), row, Const.SALT_WIDTH() + tsdb.metrics.width() + 4, tsuid.length - tsdb.metrics.width());
        RowKey.prefixKeyWithSalt(row);
        return row;
    }

    public static byte[] getSaltBytes(int bucket) {
        byte[] bytes = new byte[Const.SALT_WIDTH()];
        int shift = 0;
        for (int i = 1; i <= Const.SALT_WIDTH(); ++i) {
            bytes[Const.SALT_WIDTH() - i] = (byte)(bucket >>> shift);
            shift += 8;
        }
        return bytes;
    }

    public static void prefixKeyWithSalt(byte[] row_key) {
        if (Const.SALT_WIDTH() > 0) {
            if (row_key.length < Const.SALT_WIDTH() + TSDB.metrics_width() || Bytes.memcmp((byte[])row_key, (byte[])new byte[Const.SALT_WIDTH() + TSDB.metrics_width()], (int)Const.SALT_WIDTH(), (int)TSDB.metrics_width()) == 0) {
                return;
            }
            int tags_start = Const.SALT_WIDTH() + TSDB.metrics_width() + 4;
            byte[] salt_base = new byte[row_key.length - Const.SALT_WIDTH() - 4];
            System.arraycopy(row_key, Const.SALT_WIDTH(), salt_base, 0, TSDB.metrics_width());
            System.arraycopy(row_key, tags_start, salt_base, TSDB.metrics_width(), row_key.length - tags_start);
            int modulo = Arrays.hashCode(salt_base) % Const.SALT_BUCKETS();
            if (modulo < 0) {
                modulo *= -1;
            }
            byte[] salt = RowKey.getSaltBytes(modulo);
            System.arraycopy(salt, 0, row_key, 0, Const.SALT_WIDTH());
        }
    }

    public static int rowKeyContainsMetric(byte[] metric, byte[] row_key) {
        int idx = Const.SALT_WIDTH();
        int i = 0;
        while (i < metric.length) {
            if (metric[i] != row_key[idx]) {
                return (metric[i] & 0xFF) - (row_key[idx] & 0xFF);
            }
            ++i;
            ++idx;
        }
        return 0;
    }

    public static class SaltCmp
    implements Comparator<byte[]> {
        @Override
        public int compare(byte[] a, byte[] b) {
            int length = Math.min(a.length, b.length);
            if (a == b) {
                return 0;
            }
            for (int i = Const.SALT_WIDTH(); i < length; ++i) {
                if (a[i] == b[i]) continue;
                return (a[i] & 0xFF) - (b[i] & 0xFF);
            }
            return a.length - b.length;
        }
    }
}

