/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.core;

import com.stumbleupon.async.Deferred;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import net.opentsdb.core.Const;
import net.opentsdb.core.DataPoint;
import net.opentsdb.core.DataPoints;
import net.opentsdb.core.IllegalDataException;
import net.opentsdb.core.Internal;
import net.opentsdb.core.RowKey;
import net.opentsdb.core.SeekableView;
import net.opentsdb.core.TSDB;
import net.opentsdb.core.Tags;
import net.opentsdb.meta.Annotation;
import org.hbase.async.Bytes;
import org.hbase.async.KeyValue;

final class RowSeq
implements DataPoints {
    private final TSDB tsdb;
    byte[] key;
    private byte[] qualifiers;
    private byte[] values;

    RowSeq(TSDB tsdb) {
        this.tsdb = tsdb;
    }

    void setRow(KeyValue row) {
        if (this.key != null) {
            throw new IllegalStateException("setRow was already called on " + this);
        }
        this.key = row.key();
        this.qualifiers = row.qualifier();
        this.values = row.value();
    }

    void addRow(KeyValue row) {
        if (this.key == null) {
            throw new IllegalStateException("setRow was never called on " + this);
        }
        byte[] key = row.key();
        if (Bytes.memcmp((byte[])this.key, (byte[])key, (int)Const.SALT_WIDTH(), (int)(key.length - Const.SALT_WIDTH())) != 0) {
            throw new IllegalDataException("Attempt to add a different row=" + row + ", this=" + this);
        }
        byte[] remote_qual = row.qualifier();
        byte[] remote_val = row.value();
        byte[] merged_qualifiers = new byte[this.qualifiers.length + remote_qual.length];
        byte[] merged_values = new byte[this.values.length + remote_val.length];
        int remote_q_index = 0;
        int local_q_index = 0;
        int merged_q_index = 0;
        int remote_v_index = 0;
        int local_v_index = 0;
        int merged_v_index = 0;
        while (remote_q_index < remote_qual.length || local_q_index < this.qualifiers.length) {
            short q_length;
            short v_length;
            if (remote_q_index >= remote_qual.length) {
                v_length = Internal.getValueLengthFromQualifier(this.qualifiers, local_q_index);
                System.arraycopy(this.values, local_v_index, merged_values, merged_v_index, v_length);
                local_v_index += v_length;
                merged_v_index += v_length;
                q_length = Internal.getQualifierLength(this.qualifiers, local_q_index);
                System.arraycopy(this.qualifiers, local_q_index, merged_qualifiers, merged_q_index, q_length);
                local_q_index += q_length;
                merged_q_index += q_length;
                continue;
            }
            if (local_q_index >= this.qualifiers.length) {
                v_length = Internal.getValueLengthFromQualifier(remote_qual, remote_q_index);
                System.arraycopy(remote_val, remote_v_index, merged_values, merged_v_index, v_length);
                remote_v_index += v_length;
                merged_v_index += v_length;
                q_length = Internal.getQualifierLength(remote_qual, remote_q_index);
                System.arraycopy(remote_qual, remote_q_index, merged_qualifiers, merged_q_index, q_length);
                remote_q_index += q_length;
                merged_q_index += q_length;
                continue;
            }
            int sort = Internal.compareQualifiers(remote_qual, remote_q_index, this.qualifiers, local_q_index);
            if (sort == 0) {
                v_length = Internal.getValueLengthFromQualifier(remote_qual, remote_q_index);
                remote_v_index += v_length;
                q_length = Internal.getQualifierLength(remote_qual, remote_q_index);
                remote_q_index += q_length;
                continue;
            }
            if (sort < 0) {
                v_length = Internal.getValueLengthFromQualifier(remote_qual, remote_q_index);
                System.arraycopy(remote_val, remote_v_index, merged_values, merged_v_index, v_length);
                remote_v_index += v_length;
                merged_v_index += v_length;
                q_length = Internal.getQualifierLength(remote_qual, remote_q_index);
                System.arraycopy(remote_qual, remote_q_index, merged_qualifiers, merged_q_index, q_length);
                remote_q_index += q_length;
                merged_q_index += q_length;
                continue;
            }
            v_length = Internal.getValueLengthFromQualifier(this.qualifiers, local_q_index);
            System.arraycopy(this.values, local_v_index, merged_values, merged_v_index, v_length);
            local_v_index += v_length;
            merged_v_index += v_length;
            q_length = Internal.getQualifierLength(this.qualifiers, local_q_index);
            System.arraycopy(this.qualifiers, local_q_index, merged_qualifiers, merged_q_index, q_length);
            local_q_index += q_length;
            merged_q_index += q_length;
        }
        this.qualifiers = merged_q_index == merged_qualifiers.length ? merged_qualifiers : Arrays.copyOfRange(merged_qualifiers, 0, merged_q_index);
        byte meta = 0;
        if ((this.values[this.values.length - 1] & 1) == 1 || (remote_val[remote_val.length - 1] & 1) == 1) {
            meta = 1;
        }
        this.values = Arrays.copyOfRange(merged_values, 0, merged_v_index + 1);
        this.values[this.values.length - 1] = meta;
    }

    static long extractIntegerValue(byte[] values, int value_idx, byte flags) {
        switch (flags & 7) {
            case 7: {
                return Bytes.getLong((byte[])values, (int)value_idx);
            }
            case 3: {
                return Bytes.getInt((byte[])values, (int)value_idx);
            }
            case 1: {
                return Bytes.getShort((byte[])values, (int)value_idx);
            }
            case 0: {
                return values[value_idx];
            }
        }
        throw new IllegalDataException("Integer value @ " + value_idx + " not on 8/4/2/1 bytes in " + Arrays.toString(values));
    }

    static double extractFloatingPointValue(byte[] values, int value_idx, byte flags) {
        switch (flags & 7) {
            case 7: {
                return Double.longBitsToDouble(Bytes.getLong((byte[])values, (int)value_idx));
            }
            case 3: {
                return Float.intBitsToFloat(Bytes.getInt((byte[])values, (int)value_idx));
            }
        }
        throw new IllegalDataException("Floating point value @ " + value_idx + " not on 8 or 4 bytes in " + Arrays.toString(values));
    }

    @Override
    public String metricName() {
        try {
            return (String)this.metricNameAsync().joinUninterruptibly();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Should never be here", e);
        }
    }

    @Override
    public Deferred<String> metricNameAsync() {
        if (this.key == null) {
            throw new IllegalStateException("the row key is null!");
        }
        return RowKey.metricNameAsync(this.tsdb, this.key);
    }

    @Override
    public byte[] metricUID() {
        return Arrays.copyOfRange(this.key, Const.SALT_WIDTH(), Const.SALT_WIDTH() + TSDB.metrics_width());
    }

    @Override
    public Map<String, String> getTags() {
        try {
            return (Map)this.getTagsAsync().joinUninterruptibly();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Should never be here", e);
        }
    }

    @Override
    public Bytes.ByteMap<byte[]> getTagUids() {
        return Tags.getTagUids(this.key);
    }

    @Override
    public Deferred<Map<String, String>> getTagsAsync() {
        return Tags.getTagsAsync(this.tsdb, this.key);
    }

    @Override
    public List<String> getAggregatedTags() {
        return Collections.emptyList();
    }

    @Override
    public Deferred<List<String>> getAggregatedTagsAsync() {
        List empty = Collections.emptyList();
        return Deferred.fromResult(empty);
    }

    @Override
    public List<byte[]> getAggregatedTagUids() {
        return Collections.emptyList();
    }

    @Override
    public List<String> getTSUIDs() {
        return Collections.emptyList();
    }

    @Override
    public List<Annotation> getAnnotations() {
        return Collections.emptyList();
    }

    @Override
    public int size() {
        if ((this.values[this.values.length - 1] & 1) == 1) {
            int size = 0;
            for (int i = 0; i < this.qualifiers.length; i += 2) {
                if ((this.qualifiers[i] & 0xFFFFFFF0) == -16) {
                    i += 2;
                }
                ++size;
            }
            return size;
        }
        if ((this.qualifiers[0] & 0xFFFFFFF0) == -16) {
            return this.qualifiers.length / 4;
        }
        return this.qualifiers.length / 2;
    }

    @Override
    public int aggregatedSize() {
        return 0;
    }

    @Override
    public SeekableView iterator() {
        return this.internalIterator();
    }

    Iterator internalIterator() {
        return new Iterator();
    }

    long baseTime() {
        return Bytes.getUnsignedInt((byte[])this.key, (int)(Const.SALT_WIDTH() + this.tsdb.metrics.width()));
    }

    private void checkIndex(int i) {
        if (i >= this.size()) {
            throw new IndexOutOfBoundsException("index " + i + " >= " + this.size() + " for this=" + this);
        }
        if (i < 0) {
            throw new IndexOutOfBoundsException("negative index " + i + " for this=" + this);
        }
    }

    @Override
    public long timestamp(int i) {
        this.checkIndex(i);
        if ((this.values[this.values.length - 1] & 1) == 1) {
            int index = 0;
            for (int idx = 0; idx < this.qualifiers.length; idx += 2) {
                if (i == index) {
                    return Internal.getTimestampFromQualifier(this.qualifiers, this.baseTime(), idx);
                }
                if (Internal.inMilliseconds(this.qualifiers[idx])) {
                    idx += 2;
                }
                ++index;
            }
        } else {
            if ((this.qualifiers[0] & 0xFFFFFFF0) == -16) {
                return Internal.getTimestampFromQualifier(this.qualifiers, this.baseTime(), i * 4);
            }
            return Internal.getTimestampFromQualifier(this.qualifiers, this.baseTime(), i * 2);
        }
        throw new RuntimeException("WTF timestamp for index: " + i + " on " + this);
    }

    @Override
    public boolean isInteger(int i) {
        this.checkIndex(i);
        return (Internal.getFlagsFromQualifier(this.qualifiers, i) & 8) == 0;
    }

    @Override
    public long longValue(int i) {
        if (!this.isInteger(i)) {
            throw new ClassCastException("value #" + i + " is not a long in " + this);
        }
        Iterator it = new Iterator();
        while (i-- >= 0) {
            it.next();
        }
        return it.longValue();
    }

    @Override
    public double doubleValue(int i) {
        if (this.isInteger(i)) {
            throw new ClassCastException("value #" + i + " is not a float in " + this);
        }
        Iterator it = new Iterator();
        while (i-- >= 0) {
            it.next();
        }
        return it.doubleValue();
    }

    double toDouble(int i) {
        if (this.isInteger(i)) {
            return this.longValue(i);
        }
        return this.doubleValue(i);
    }

    public String toString() {
        String metric = this.metricName();
        int size = this.size();
        StringBuilder buf = new StringBuilder(80 + metric.length() + this.key.length * 4 + size * 16);
        long base_time = this.baseTime();
        buf.append("RowSeq(").append(this.key == null ? "<null>" : Arrays.toString(this.key)).append(" (metric=").append(metric).append("), base_time=").append(base_time).append(" (").append(base_time > 0L ? new Date(base_time * 1000L) : "no date").append(")");
        buf.append("(datapoints=").append(size);
        buf.append("), (qualifier=[").append(Arrays.toString(this.qualifiers));
        buf.append("]), (values=[").append(Arrays.toString(this.values));
        buf.append("])");
        return buf.toString();
    }

    @Override
    public int getQueryIndex() {
        throw new UnsupportedOperationException("Not mapped to a query");
    }

    final class Iterator
    implements SeekableView,
    DataPoint {
        private int qualifier;
        private int qual_index;
        private int value_index;
        private final long base_time;

        Iterator() {
            this.base_time = RowSeq.this.baseTime();
        }

        @Override
        public boolean hasNext() {
            return this.qual_index < RowSeq.this.qualifiers.length;
        }

        @Override
        public DataPoint next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("no more elements");
            }
            if (Internal.inMilliseconds(RowSeq.this.qualifiers[this.qual_index])) {
                this.qualifier = Bytes.getInt((byte[])RowSeq.this.qualifiers, (int)this.qual_index);
                this.qual_index += 4;
            } else {
                this.qualifier = Bytes.getUnsignedShort((byte[])RowSeq.this.qualifiers, (int)this.qual_index);
                this.qual_index += 2;
            }
            byte flags = (byte)this.qualifier;
            this.value_index += (flags & 7) + 1;
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void seek(long timestamp) {
            if ((timestamp & 0xFFFFF00000000000L) != 0L) {
                throw new IllegalArgumentException("invalid timestamp: " + timestamp);
            }
            this.qual_index = 0;
            this.value_index = 0;
            int len = RowSeq.this.qualifiers.length;
            while (this.qual_index < len && this.peekNextTimestamp() < timestamp) {
                if (Internal.inMilliseconds(RowSeq.this.qualifiers[this.qual_index])) {
                    this.qualifier = Bytes.getInt((byte[])RowSeq.this.qualifiers, (int)this.qual_index);
                    this.qual_index += 4;
                } else {
                    this.qualifier = Bytes.getUnsignedShort((byte[])RowSeq.this.qualifiers, (int)this.qual_index);
                    this.qual_index += 2;
                }
                byte flags = (byte)this.qualifier;
                this.value_index += (flags & 7) + 1;
            }
        }

        @Override
        public long timestamp() {
            assert (this.qual_index > 0) : "not initialized: " + this;
            if ((this.qualifier & 0xF0000000) == -268435456) {
                long ms = (this.qualifier & 0xFFFFFC0) >>> 6;
                return this.base_time * 1000L + ms;
            }
            long seconds = (this.qualifier & 0xFFFF) >>> 4;
            return (this.base_time + seconds) * 1000L;
        }

        @Override
        public boolean isInteger() {
            assert (this.qual_index > 0) : "not initialized: " + this;
            return (this.qualifier & 8) == 0;
        }

        @Override
        public long longValue() {
            if (!this.isInteger()) {
                throw new ClassCastException("value @" + this.qual_index + " is not a long in " + this);
            }
            byte flags = (byte)this.qualifier;
            byte vlen = (byte)((flags & 7) + 1);
            return RowSeq.extractIntegerValue(RowSeq.this.values, this.value_index - vlen, flags);
        }

        @Override
        public double doubleValue() {
            if (this.isInteger()) {
                throw new ClassCastException("value @" + this.qual_index + " is not a float in " + this);
            }
            byte flags = (byte)this.qualifier;
            byte vlen = (byte)((flags & 7) + 1);
            return RowSeq.extractFloatingPointValue(RowSeq.this.values, this.value_index - vlen, flags);
        }

        @Override
        public double toDouble() {
            return this.isInteger() ? (double)this.longValue() : this.doubleValue();
        }

        long saveState() {
            return (long)this.qual_index << 32 | (long)this.value_index & 0xFFFFFFFFFFFFFFFFL;
        }

        void restoreState(long state) {
            this.value_index = (int)state & 0xFFFFFFFF;
            this.qual_index = (int)(state >>>= 32);
            this.qualifier = 0;
        }

        long peekNextTimestamp() {
            return Internal.getTimestampFromQualifier(RowSeq.this.qualifiers, this.base_time, this.qual_index);
        }

        String toStringSummary() {
            return "RowSeq.Iterator(qual_index=" + this.qual_index + ", value_index=" + this.value_index;
        }

        public String toString() {
            return this.toStringSummary() + ", seq=" + RowSeq.this + ')';
        }
    }

    public static final class RowSeqComparator
    implements Comparator<RowSeq> {
        @Override
        public int compare(RowSeq a, RowSeq b) {
            if (a.baseTime() == b.baseTime()) {
                return 0;
            }
            return a.baseTime() < b.baseTime() ? -1 : 1;
        }
    }
}

