/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.core;

import com.google.common.collect.Lists;
import com.stumbleupon.async.Callback;
import com.stumbleupon.async.Deferred;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.opentsdb.core.Const;
import net.opentsdb.core.IllegalDataException;
import net.opentsdb.core.Internal;
import net.opentsdb.core.RowKey;
import net.opentsdb.core.Span;
import net.opentsdb.core.TSDB;
import net.opentsdb.core.Tags;
import net.opentsdb.core.TsdbQuery;
import net.opentsdb.meta.Annotation;
import net.opentsdb.query.filter.TagVFilter;
import net.opentsdb.stats.QueryStats;
import net.opentsdb.uid.UniqueId;
import net.opentsdb.utils.DateTime;
import org.hbase.async.Bytes;
import org.hbase.async.DeleteRequest;
import org.hbase.async.KeyValue;
import org.hbase.async.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaltScanner {
    private static final Logger LOG = LoggerFactory.getLogger(SaltScanner.class);
    private final TreeMap<byte[], Span> spans;
    private final List<Scanner> scanners;
    private final Map<Integer, List<KeyValue>> kv_map = new ConcurrentHashMap<Integer, List<KeyValue>>();
    private final Map<byte[], List<Annotation>> annotation_map = Collections.synchronizedMap(new TreeMap(new RowKey.SaltCmp()));
    private final Deferred<TreeMap<byte[], Span>> results = new Deferred();
    private final byte[] metric;
    private final TSDB tsdb;
    private final QueryStats query_stats;
    private final int query_index;
    private AtomicInteger completed_tasks = new AtomicInteger();
    private long start_time;
    private final boolean delete;
    private final List<TagVFilter> filters;
    private volatile Exception exception;

    public SaltScanner(TSDB tsdb, byte[] metric, List<Scanner> scanners, TreeMap<byte[], Span> spans, List<TagVFilter> filters) {
        this(tsdb, metric, scanners, spans, filters, false, null, 0);
    }

    public SaltScanner(TSDB tsdb, byte[] metric, List<Scanner> scanners, TreeMap<byte[], Span> spans, List<TagVFilter> filters, boolean delete, QueryStats query_stats, int query_index) {
        if (Const.SALT_WIDTH() < 1) {
            throw new IllegalArgumentException("Salting is disabled. Use the regular scanner");
        }
        if (tsdb == null) {
            throw new IllegalArgumentException("The TSDB argument was null.");
        }
        if (spans == null) {
            throw new IllegalArgumentException("Span map cannot be null.");
        }
        if (!spans.isEmpty()) {
            throw new IllegalArgumentException("The span map should be empty.");
        }
        if (scanners == null || scanners.isEmpty()) {
            throw new IllegalArgumentException("Missing or empty scanners list. Please provide a list of scanners for each salt.");
        }
        if (scanners.size() != Const.SALT_BUCKETS()) {
            throw new IllegalArgumentException("Not enough or too many scanners " + scanners.size() + " when the salt bucket count is " + Const.SALT_BUCKETS());
        }
        if (metric == null) {
            throw new IllegalArgumentException("The metric array was null.");
        }
        if (metric.length != TSDB.metrics_width()) {
            throw new IllegalArgumentException("The metric was too short. It must be " + TSDB.metrics_width() + "bytes wide.");
        }
        this.scanners = scanners;
        this.spans = spans;
        this.metric = metric;
        this.tsdb = tsdb;
        this.filters = filters;
        this.delete = delete;
        this.query_stats = query_stats;
        this.query_index = query_index;
    }

    public Deferred<TreeMap<byte[], Span>> scan() {
        this.start_time = System.currentTimeMillis();
        int i = 0;
        for (Scanner scanner : this.scanners) {
            new ScannerCB(scanner, i++).scan();
        }
        return this.results;
    }

    private void mergeAndReturnResults() {
        long hbase_time = System.currentTimeMillis();
        TsdbQuery.scanlatency.add((int)(hbase_time - this.start_time));
        long rows = 0L;
        if (this.exception != null) {
            LOG.error("After all of the scanners finished, at least one threw an exception", (Throwable)this.exception);
            this.results.callback((Object)this.exception);
            return;
        }
        long merge_start = DateTime.nanoTime();
        for (List<KeyValue> kvs : this.kv_map.values()) {
            if (kvs == null || kvs.isEmpty()) {
                LOG.warn("Found a key value list that was null or empty");
                continue;
            }
            for (KeyValue kv : kvs) {
                if (kv == null) {
                    LOG.warn("Found a key value item that was null");
                    continue;
                }
                if (kv.key() == null) {
                    LOG.warn("A key for a kv was null");
                    continue;
                }
                Span datapoints = this.spans.get(kv.key());
                if (datapoints == null) {
                    datapoints = new Span(this.tsdb);
                    this.spans.put(kv.key(), datapoints);
                }
                if (this.annotation_map.containsKey(kv.key())) {
                    for (Annotation note : this.annotation_map.get(kv.key())) {
                        datapoints.getAnnotations().add(note);
                    }
                    this.annotation_map.remove(kv.key());
                }
                try {
                    datapoints.addRow(kv);
                    ++rows;
                }
                catch (RuntimeException e) {
                    LOG.error("Exception adding row to span", (Throwable)e);
                    throw e;
                }
            }
        }
        this.kv_map.clear();
        for (byte[] key : this.annotation_map.keySet()) {
            Span datapoints = this.spans.get(key);
            if (datapoints == null) {
                datapoints = new Span(this.tsdb);
                this.spans.put(key, datapoints);
            }
            for (Annotation note : this.annotation_map.get(key)) {
                datapoints.getAnnotations().add(note);
            }
        }
        if (this.query_stats != null) {
            this.query_stats.addStat(this.query_index, QueryStats.QueryStat.SCANNER_MERGE_TIME, DateTime.nanoTime() - merge_start);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Scanning completed in " + (hbase_time - this.start_time) + " ms, " + rows + " rows, and stored in " + this.spans.size() + " spans");
            LOG.debug("It took " + (System.currentTimeMillis() - hbase_time) + " ms,  to merge and sort the rows into a tree map");
        }
        this.results.callback(this.spans);
    }

    private void validateAndTriggerCallback(List<KeyValue> kvs, Map<byte[], List<Annotation>> annotations) {
        int tasks = this.completed_tasks.incrementAndGet();
        if (kvs.size() > 0) {
            this.kv_map.put(tasks, kvs);
        }
        for (byte[] key : annotations.keySet()) {
            List<Annotation> notes = annotations.get(key);
            if (notes.size() <= 0) continue;
            this.annotation_map.put(key, notes);
        }
        if (tasks >= Const.SALT_BUCKETS()) {
            try {
                this.mergeAndReturnResults();
            }
            catch (Exception ex) {
                this.results.callback((Object)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleException(Exception e) {
        this.completed_tasks.incrementAndGet();
        if (this.exception == null) {
            SaltScanner saltScanner = this;
            synchronized (saltScanner) {
                if (this.exception == null) {
                    this.exception = e;
                    try {
                        this.mergeAndReturnResults();
                    }
                    catch (Exception ex) {
                        LOG.error("Failed merging and returning results, calling back with exception", (Throwable)ex);
                        this.results.callback((Object)ex);
                    }
                } else {
                    LOG.error("Another scanner threw an exception", (Throwable)e);
                }
            }
        }
    }

    final class ScannerCB
    implements Callback<Object, ArrayList<ArrayList<KeyValue>>> {
        private final Scanner scanner;
        private final int index;
        private final List<KeyValue> kvs = new ArrayList<KeyValue>();
        private final Bytes.ByteMap<List<Annotation>> annotations = new Bytes.ByteMap();
        private final Set<String> skips = Collections.newSetFromMap(new ConcurrentHashMap());
        private final Set<String> keepers = Collections.newSetFromMap(new ConcurrentHashMap());
        private long scanner_start = -1L;
        private long fetch_start = 0L;
        private long fetch_time = 0L;
        private long uid_resolve_time = 0L;
        private long uids_resolved = 0L;
        private long compaction_time = 0L;
        private long dps_pre_filter = 0L;
        private long rows_pre_filter = 0L;
        private long dps_post_filter = 0L;
        private long rows_post_filter = 0L;

        public ScannerCB(Scanner scanner, int index) {
            this.scanner = scanner;
            this.index = index;
            if (SaltScanner.this.query_stats != null) {
                SaltScanner.this.query_stats.addScannerId(SaltScanner.this.query_index, index, scanner.toString());
            }
        }

        public Object scan() {
            if (this.scanner_start < 0L) {
                this.scanner_start = DateTime.nanoTime();
            }
            this.fetch_start = DateTime.nanoTime();
            return this.scanner.nextRows().addCallback((Callback)this).addErrback((Callback)new ErrorCb());
        }

        public Object call(ArrayList<ArrayList<KeyValue>> rows) throws Exception {
            try {
                this.fetch_time += DateTime.nanoTime() - this.fetch_start;
                if (rows == null) {
                    this.close(true);
                    return null;
                }
                if (SaltScanner.this.exception != null) {
                    this.close(false);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Closing scanner as there was an exception: " + this.scanner);
                    }
                    return null;
                }
                ArrayList<Deferred> lookups = SaltScanner.this.filters != null && !SaltScanner.this.filters.isEmpty() ? new ArrayList<Deferred>(rows.size()) : null;
                this.rows_pre_filter += (long)rows.size();
                for (final ArrayList<KeyValue> row : rows) {
                    final byte[] key = row.get(0).key();
                    if (RowKey.rowKeyContainsMetric(SaltScanner.this.metric, key) != 0) {
                        this.close(false);
                        SaltScanner.this.handleException(new IllegalDataException("HBase returned a row that doesn't match our scanner (" + this.scanner + ")! " + row + " does not start with " + Arrays.toString(SaltScanner.this.metric) + " on scanner " + this));
                        return null;
                    }
                    for (KeyValue kv : row) {
                        if (kv.qualifier().length % 2 == 0) {
                            if (kv.qualifier().length == 2 || kv.qualifier().length == 4) {
                                ++this.dps_pre_filter;
                                continue;
                            }
                            if (Internal.inMilliseconds(kv.qualifier())) {
                                this.dps_pre_filter += (long)(kv.qualifier().length / 4);
                                continue;
                            }
                            this.dps_pre_filter += (long)(kv.qualifier().length / 2);
                            continue;
                        }
                        if (kv.qualifier()[0] != 5) continue;
                        int idx = 0;
                        short qlength = 0;
                        while (idx < kv.value().length) {
                            qlength = Internal.getQualifierLength(kv.value(), idx);
                            idx += qlength + Internal.getValueLengthFromQualifier(kv.value(), idx);
                            ++this.dps_pre_filter;
                        }
                    }
                    if (SaltScanner.this.filters != null && !SaltScanner.this.filters.isEmpty()) {
                        lookups.clear();
                        final String tsuid = UniqueId.uidToString(UniqueId.getTSUIDFromKey(key, TSDB.metrics_width(), (short)4));
                        if (this.skips.contains(tsuid)) continue;
                        if (!this.keepers.contains(tsuid)) {
                            final long uid_start = DateTime.nanoTime();
                            class GetTagsCB
                            implements Callback<Deferred<ArrayList<Boolean>>, Map<String, String>> {
                                GetTagsCB() {
                                }

                                public Deferred<ArrayList<Boolean>> call(Map<String, String> tags) throws Exception {
                                    ScannerCB.this.uid_resolve_time = ScannerCB.this.uid_resolve_time + (DateTime.nanoTime() - uid_start);
                                    ScannerCB.this.uids_resolved = ScannerCB.this.uids_resolved + (long)tags.size();
                                    ArrayList<Deferred<Boolean>> matches = new ArrayList<Deferred<Boolean>>(SaltScanner.this.filters.size());
                                    for (TagVFilter filter : SaltScanner.this.filters) {
                                        matches.add(filter.match(tags));
                                    }
                                    return Deferred.group(matches);
                                }
                            }
                            class MatchCB
                            implements Callback<Object, ArrayList<Boolean>> {
                                MatchCB() {
                                }

                                public Object call(ArrayList<Boolean> matches) throws Exception {
                                    for (boolean matched : matches) {
                                        if (matched) continue;
                                        ScannerCB.this.skips.add(tsuid);
                                        return null;
                                    }
                                    ScannerCB.this.keepers.add(tsuid);
                                    ScannerCB.this.processRow(key, row);
                                    return null;
                                }
                            }
                            lookups.add(Tags.getTagsAsync(SaltScanner.this.tsdb, key).addCallbackDeferring((Callback)new GetTagsCB()).addBoth((Callback)new MatchCB()));
                            continue;
                        }
                        this.processRow(key, row);
                        continue;
                    }
                    this.processRow(key, row);
                }
                if (lookups != null && lookups.size() > 0) {
                    class GroupCB
                    implements Callback<Object, ArrayList<Object>> {
                        GroupCB() {
                        }

                        public Object call(ArrayList<Object> group) throws Exception {
                            return ScannerCB.this.scan();
                        }
                    }
                    return Deferred.group(lookups).addCallback((Callback)new GroupCB());
                }
                return this.scan();
            }
            catch (RuntimeException e) {
                LOG.error("Unexpected exception on scanner " + this, (Throwable)e);
                this.close(false);
                SaltScanner.this.handleException(e);
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void processRow(byte[] key, ArrayList<KeyValue> row) {
            KeyValue compacted;
            long compaction_start;
            block14: {
                ++this.rows_post_filter;
                if (SaltScanner.this.delete) {
                    DeleteRequest del = new DeleteRequest(SaltScanner.this.tsdb.dataTable(), key);
                    SaltScanner.this.tsdb.getClient().delete(del);
                }
                for (KeyValue kv : row) {
                    if (kv.qualifier().length % 2 == 0) {
                        if (kv.qualifier().length == 2 || kv.qualifier().length == 4) {
                            ++this.dps_post_filter;
                            continue;
                        }
                        if (Internal.inMilliseconds(kv.qualifier())) {
                            this.dps_post_filter += (long)(kv.qualifier().length / 4);
                            continue;
                        }
                        this.dps_post_filter += (long)(kv.qualifier().length / 2);
                        continue;
                    }
                    if (kv.qualifier()[0] != 5) continue;
                    int idx = 0;
                    short qlength = 0;
                    while (idx < kv.value().length) {
                        qlength = Internal.getQualifierLength(kv.value(), idx);
                        idx += qlength + Internal.getValueLengthFromQualifier(kv.value(), idx);
                        ++this.dps_post_filter;
                    }
                }
                compaction_start = DateTime.nanoTime();
                try {
                    ArrayList notes = Lists.newArrayList();
                    compacted = SaltScanner.this.tsdb.compact(row, notes);
                    if (notes.isEmpty()) break block14;
                    Bytes.ByteMap<List<Annotation>> byteMap = this.annotations;
                    synchronized (byteMap) {
                        List map_notes = (List)this.annotations.get((Object)key);
                        if (map_notes == null) {
                            this.annotations.put((Object)key, (Object)notes);
                        } else {
                            map_notes.addAll(notes);
                        }
                    }
                }
                catch (IllegalDataException idex) {
                    this.compaction_time += DateTime.nanoTime() - compaction_start;
                    this.close(false);
                    SaltScanner.this.handleException(idex);
                    return;
                }
            }
            this.compaction_time += DateTime.nanoTime() - compaction_start;
            if (compacted != null) {
                this.kvs.add(compacted);
            }
        }

        void close(boolean ok) {
            this.scanner.close();
            if (SaltScanner.this.query_stats != null) {
                SaltScanner.this.query_stats.addScannerStat(SaltScanner.this.query_index, this.index, QueryStats.QueryStat.SCANNER_TIME, DateTime.nanoTime() - this.scanner_start);
                SaltScanner.this.query_stats.addScannerStat(SaltScanner.this.query_index, this.index, QueryStats.QueryStat.HBASE_TIME, this.fetch_time);
                SaltScanner.this.query_stats.addScannerStat(SaltScanner.this.query_index, this.index, QueryStats.QueryStat.SUCCESSFUL_SCAN, ok ? 1L : 0L);
                SaltScanner.this.query_stats.addScannerStat(SaltScanner.this.query_index, this.index, QueryStats.QueryStat.ROWS_PRE_FILTER, this.rows_pre_filter);
                SaltScanner.this.query_stats.addScannerStat(SaltScanner.this.query_index, this.index, QueryStats.QueryStat.DPS_PRE_FILTER, this.dps_pre_filter);
                SaltScanner.this.query_stats.addScannerStat(SaltScanner.this.query_index, this.index, QueryStats.QueryStat.ROWS_POST_FILTER, this.rows_post_filter);
                SaltScanner.this.query_stats.addScannerStat(SaltScanner.this.query_index, this.index, QueryStats.QueryStat.DPS_POST_FILTER, this.dps_post_filter);
                SaltScanner.this.query_stats.addScannerStat(SaltScanner.this.query_index, this.index, QueryStats.QueryStat.SCANNER_UID_TO_STRING_TIME, this.uid_resolve_time);
                SaltScanner.this.query_stats.addScannerStat(SaltScanner.this.query_index, this.index, QueryStats.QueryStat.UID_PAIRS_RESOLVED, this.uids_resolved);
                SaltScanner.this.query_stats.addScannerStat(SaltScanner.this.query_index, this.index, QueryStats.QueryStat.COMPACTION_TIME, this.compaction_time);
            }
            if (ok && SaltScanner.this.exception == null) {
                SaltScanner.this.validateAndTriggerCallback(this.kvs, this.annotations);
            } else {
                SaltScanner.this.completed_tasks.incrementAndGet();
            }
        }

        class ErrorCb
        implements Callback<Object, Exception> {
            ErrorCb() {
            }

            public Object call(Exception e) throws Exception {
                LOG.error("Scanner " + ScannerCB.this.scanner + " threw an exception", (Throwable)e);
                ScannerCB.this.close(false);
                SaltScanner.this.handleException(e);
                return null;
            }
        }
    }
}

