/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.core;

import com.stumbleupon.async.Deferred;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import net.opentsdb.core.Aggregator;
import net.opentsdb.core.Const;
import net.opentsdb.core.DataPoint;
import net.opentsdb.core.DataPoints;
import net.opentsdb.core.Downsampler;
import net.opentsdb.core.DownsamplingSpecification;
import net.opentsdb.core.FillPolicy;
import net.opentsdb.core.FillingDownsampler;
import net.opentsdb.core.Internal;
import net.opentsdb.core.RowSeq;
import net.opentsdb.core.SeekableView;
import net.opentsdb.core.TSDB;
import net.opentsdb.meta.Annotation;
import net.opentsdb.uid.UniqueId;
import org.hbase.async.Bytes;
import org.hbase.async.KeyValue;

final class Span
implements DataPoints {
    private final TSDB tsdb;
    private final ArrayList<RowSeq> rows = new ArrayList();
    private final ArrayList<Annotation> annotations = new ArrayList(0);
    private boolean sorted;

    Span(TSDB tsdb) {
        this.tsdb = tsdb;
    }

    private void checkNotEmpty() {
        if (this.rows.size() == 0) {
            throw new IllegalStateException("empty Span");
        }
    }

    @Override
    public String metricName() {
        try {
            return (String)this.metricNameAsync().joinUninterruptibly();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Should never be here", e);
        }
    }

    @Override
    public Deferred<String> metricNameAsync() {
        this.checkNotEmpty();
        return this.rows.get(0).metricNameAsync();
    }

    @Override
    public byte[] metricUID() {
        this.checkNotEmpty();
        return this.rows.get(0).metricUID();
    }

    @Override
    public Map<String, String> getTags() {
        try {
            return (Map)this.getTagsAsync().joinUninterruptibly();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Should never be here", e);
        }
    }

    @Override
    public Deferred<Map<String, String>> getTagsAsync() {
        this.checkNotEmpty();
        return this.rows.get(0).getTagsAsync();
    }

    @Override
    public Bytes.ByteMap<byte[]> getTagUids() {
        this.checkNotEmpty();
        return this.rows.get(0).getTagUids();
    }

    @Override
    public List<String> getAggregatedTags() {
        return Collections.emptyList();
    }

    @Override
    public Deferred<List<String>> getAggregatedTagsAsync() {
        List empty = Collections.emptyList();
        return Deferred.fromResult(empty);
    }

    @Override
    public List<byte[]> getAggregatedTagUids() {
        return Collections.emptyList();
    }

    @Override
    public int size() {
        int size = 0;
        for (RowSeq row : this.rows) {
            size += row.size();
        }
        return size;
    }

    @Override
    public int aggregatedSize() {
        return 0;
    }

    @Override
    public List<String> getTSUIDs() {
        if (this.rows.size() < 1) {
            return null;
        }
        byte[] tsuid = UniqueId.getTSUIDFromKey(this.rows.get((int)0).key, TSDB.metrics_width(), (short)4);
        ArrayList<String> tsuids = new ArrayList<String>(1);
        tsuids.add(UniqueId.uidToString(tsuid));
        return tsuids;
    }

    @Override
    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    void addRow(KeyValue row) {
        long last_ts = 0L;
        if (this.rows.size() != 0) {
            byte[] key = row.key();
            RowSeq last = this.rows.get(this.rows.size() - 1);
            short metric_width = this.tsdb.metrics.width();
            short tags_offset = (short)(Const.SALT_WIDTH() + metric_width + 4);
            short tags_bytes = (short)(key.length - tags_offset);
            String error = null;
            if (key.length != last.key.length) {
                error = "row key length mismatch";
            } else if (Bytes.memcmp((byte[])key, (byte[])last.key, (int)Const.SALT_WIDTH(), (int)metric_width) != 0) {
                error = "metric ID mismatch";
            } else if (Bytes.memcmp((byte[])key, (byte[])last.key, (int)tags_offset, (int)tags_bytes) != 0) {
                error = "tags mismatch";
            }
            if (error != null) {
                throw new IllegalArgumentException(error + ". This Span's last row key is " + Arrays.toString(last.key) + " whereas the row key being added is " + Arrays.toString(key) + " and metric_width=" + metric_width);
            }
            last_ts = last.timestamp(last.size() - 1);
        }
        RowSeq rowseq = new RowSeq(this.tsdb);
        rowseq.setRow(row);
        this.sorted = false;
        if (last_ts >= rowseq.timestamp(0)) {
            for (RowSeq rs : this.rows) {
                if (Bytes.memcmp((byte[])rs.key, (byte[])row.key(), (int)Const.SALT_WIDTH(), (int)(rs.key.length - Const.SALT_WIDTH())) != 0) continue;
                rs.addRow(row);
                return;
            }
        }
        this.rows.add(rowseq);
    }

    static long lastTimestampInRow(short metric_width, KeyValue row) {
        long base_time = Bytes.getUnsignedInt((byte[])row.key(), (int)metric_width);
        byte[] qual = row.qualifier();
        if (qual.length >= 4 && Internal.inMilliseconds(qual[qual.length - 4])) {
            return base_time * 1000L + ((Bytes.getUnsignedInt((byte[])qual, (int)(qual.length - 4)) & 0xFFFFFC0L) >>> 6);
        }
        short last_delta = (short)(Bytes.getUnsignedShort((byte[])qual, (int)(qual.length - 2)) >>> 4);
        return base_time + (long)last_delta;
    }

    @Override
    public SeekableView iterator() {
        this.checkRowOrder();
        return this.spanIterator();
    }

    private long getIdxOffsetFor(int i) {
        RowSeq row;
        int sz;
        this.checkRowOrder();
        int idx = 0;
        int offset = 0;
        java.util.Iterator<RowSeq> iterator = this.rows.iterator();
        while (iterator.hasNext() && offset + (sz = (row = iterator.next()).size()) <= i) {
            offset += sz;
            ++idx;
        }
        return (long)idx << 32 | (long)(i - offset);
    }

    @Override
    public long timestamp(int i) {
        this.checkRowOrder();
        long idxoffset = this.getIdxOffsetFor(i);
        int idx = (int)(idxoffset >>> 32);
        int offset = (int)(idxoffset & 0xFFFFFFFFFFFFFFFFL);
        return this.rows.get(idx).timestamp(offset);
    }

    @Override
    public boolean isInteger(int i) {
        this.checkRowOrder();
        long idxoffset = this.getIdxOffsetFor(i);
        int idx = (int)(idxoffset >>> 32);
        int offset = (int)(idxoffset & 0xFFFFFFFFFFFFFFFFL);
        return this.rows.get(idx).isInteger(offset);
    }

    @Override
    public long longValue(int i) {
        this.checkRowOrder();
        long idxoffset = this.getIdxOffsetFor(i);
        int idx = (int)(idxoffset >>> 32);
        int offset = (int)(idxoffset & 0xFFFFFFFFFFFFFFFFL);
        return this.rows.get(idx).longValue(offset);
    }

    @Override
    public double doubleValue(int i) {
        this.checkRowOrder();
        long idxoffset = this.getIdxOffsetFor(i);
        int idx = (int)(idxoffset >>> 32);
        int offset = (int)(idxoffset & 0xFFFFFFFFFFFFFFFFL);
        return this.rows.get(idx).doubleValue(offset);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Span(").append(this.rows.size()).append(" rows, [");
        for (int i = 0; i < this.rows.size(); ++i) {
            if (i != 0) {
                buf.append(", ");
            }
            buf.append(this.rows.get(i).toString());
        }
        buf.append("])");
        return buf.toString();
    }

    private int seekRow(long timestamp) {
        int sz;
        this.checkRowOrder();
        int row_index = 0;
        RowSeq row = null;
        int nrows = this.rows.size();
        for (int i = 0; i < nrows && (row = this.rows.get(i)).timestamp((sz = row.size()) - 1) < timestamp; ++i) {
            ++row_index;
        }
        if (row_index == nrows) {
            --row_index;
        }
        return row_index;
    }

    private void checkRowOrder() {
        if (!this.sorted) {
            Collections.sort(this.rows, new RowSeq.RowSeqComparator());
            this.sorted = true;
        }
    }

    Iterator spanIterator() {
        if (!this.sorted) {
            Collections.sort(this.rows, new RowSeq.RowSeqComparator());
            this.sorted = true;
        }
        return new Iterator();
    }

    Downsampler downsampler(long start_time, long end_time, long interval_ms, Aggregator downsampler, FillPolicy fill_policy) {
        if (FillPolicy.NONE == fill_policy) {
            return new Downsampler(this.spanIterator(), interval_ms, downsampler);
        }
        return new FillingDownsampler((SeekableView)this.spanIterator(), start_time, end_time, interval_ms, downsampler, fill_policy);
    }

    Downsampler downsampler(long start_time, long end_time, DownsamplingSpecification downsampler, long query_start, long query_end) {
        if (downsampler == null) {
            return null;
        }
        if (FillPolicy.NONE == downsampler.getFillPolicy()) {
            return new Downsampler(this.spanIterator(), downsampler, query_start, query_end);
        }
        return new FillingDownsampler((SeekableView)this.spanIterator(), start_time, end_time, downsampler, query_start, query_end);
    }

    @Override
    public int getQueryIndex() {
        throw new UnsupportedOperationException("Not mapped to a query");
    }

    final class Iterator
    implements SeekableView {
        private int row_index;
        private RowSeq.Iterator current_row;

        Iterator() {
            this.current_row = ((RowSeq)Span.this.rows.get(0)).internalIterator();
        }

        @Override
        public boolean hasNext() {
            return this.current_row.hasNext() || this.row_index < Span.this.rows.size() - 1;
        }

        @Override
        public DataPoint next() {
            if (this.current_row.hasNext()) {
                return this.current_row.next();
            }
            if (this.row_index < Span.this.rows.size() - 1) {
                ++this.row_index;
                this.current_row = ((RowSeq)Span.this.rows.get(this.row_index)).internalIterator();
                return this.current_row.next();
            }
            throw new NoSuchElementException("no more elements");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void seek(long timestamp) {
            int row_index = Span.this.seekRow(timestamp);
            if (row_index != this.row_index) {
                this.row_index = row_index;
                this.current_row = ((RowSeq)Span.this.rows.get(row_index)).internalIterator();
            }
            this.current_row.seek(timestamp);
        }

        public String toString() {
            return "Span.Iterator(row_index=" + this.row_index + ", current_row=" + this.current_row + ", span=" + Span.this + ')';
        }
    }
}

