/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.core;

import com.stumbleupon.async.Callback;
import com.stumbleupon.async.Deferred;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.opentsdb.core.AggregationIterator;
import net.opentsdb.core.Aggregator;
import net.opentsdb.core.DataPoint;
import net.opentsdb.core.DataPoints;
import net.opentsdb.core.DownsamplingSpecification;
import net.opentsdb.core.FillPolicy;
import net.opentsdb.core.RateOptions;
import net.opentsdb.core.SeekableView;
import net.opentsdb.core.Span;
import net.opentsdb.core.TSDB;
import net.opentsdb.meta.Annotation;
import org.hbase.async.Bytes;

final class SpanGroup
implements DataPoints {
    private final ArrayList<Annotation> annotations;
    private final long start_time;
    private final long end_time;
    private Map<String, String> tags;
    private Bytes.ByteMap<byte[]> tag_uids;
    private List<String> aggregated_tags;
    private Set<byte[]> aggregated_tag_uids;
    private final ArrayList<Span> spans = new ArrayList();
    private final boolean rate;
    private RateOptions rate_options;
    private final Aggregator aggregator;
    private DownsamplingSpecification downsampler;
    private final long query_start;
    private final long query_end;
    private final int query_index;
    private final TSDB tsdb;

    SpanGroup(TSDB tsdb, long start_time, long end_time, Iterable<Span> spans, boolean rate, Aggregator aggregator, long interval, Aggregator downsampler) {
        this(tsdb, start_time, end_time, spans, rate, new RateOptions(false, Long.MAX_VALUE, 0L), aggregator, interval, downsampler);
    }

    SpanGroup(TSDB tsdb, long start_time, long end_time, Iterable<Span> spans, boolean rate, RateOptions rate_options, Aggregator aggregator, long interval, Aggregator downsampler) {
        this(tsdb, start_time, end_time, spans, rate, rate_options, aggregator, interval, downsampler, -1, FillPolicy.NONE);
    }

    SpanGroup(TSDB tsdb, long start_time, long end_time, Iterable<Span> spans, boolean rate, RateOptions rate_options, Aggregator aggregator, long interval, Aggregator downsampler, int query_index, FillPolicy fill_policy) {
        this(tsdb, start_time, end_time, spans, rate, rate_options, aggregator, downsampler != null ? new DownsamplingSpecification(interval, downsampler, fill_policy) : null, 0L, 0L, query_index);
    }

    SpanGroup(TSDB tsdb, long start_time, long end_time, Iterable<Span> spans, boolean rate, RateOptions rate_options, Aggregator aggregator, DownsamplingSpecification downsampler, long query_start, long query_end, int query_index) {
        this.annotations = new ArrayList();
        this.start_time = (start_time & 0xFFFFFFFF00000000L) == 0L ? start_time * 1000L : start_time;
        long l = this.end_time = (end_time & 0xFFFFFFFF00000000L) == 0L ? end_time * 1000L : end_time;
        if (spans != null) {
            for (Span span : spans) {
                this.add(span);
            }
        }
        this.rate = rate;
        this.rate_options = rate_options;
        this.aggregator = aggregator;
        this.downsampler = downsampler;
        this.query_start = query_start;
        this.query_end = query_end;
        this.query_index = query_index;
        this.tsdb = tsdb;
    }

    void add(Span span) {
        long end;
        if (this.tags != null) {
            throw new AssertionError((Object)("The set of tags has already been computed, you can't add more Spans to " + this));
        }
        long start = (this.start_time & 0xFFFFFFFF00000000L) == 0L ? this.start_time * 1000L : this.start_time;
        long l = end = (this.end_time & 0xFFFFFFFF00000000L) == 0L ? this.end_time * 1000L : this.end_time;
        if (span.size() == 0) {
            for (Annotation annot : span.getAnnotations()) {
                long annot_end;
                long annot_start = annot.getStartTime();
                if ((annot_start & 0xFFFFFFFF00000000L) == 0L) {
                    annot_start *= 1000L;
                }
                if (((annot_end = annot.getStartTime()) & 0xFFFFFFFF00000000L) == 0L) {
                    annot_end *= 1000L;
                }
                if (annot_end < start || annot_start > end) continue;
                this.annotations.add(annot);
            }
        } else {
            long last_dp;
            long first_dp = span.timestamp(0);
            if ((first_dp & 0xFFFFFFFF00000000L) == 0L) {
                first_dp *= 1000L;
            }
            if (((last_dp = span.timestamp(span.size() - 1)) & 0xFFFFFFFF00000000L) == 0L) {
                last_dp *= 1000L;
            }
            if (first_dp <= end && last_dp >= start) {
                this.spans.add(span);
                this.annotations.addAll(span.getAnnotations());
            }
        }
    }

    private void computeTags() {
        if (this.tag_uids != null && this.aggregated_tag_uids != null) {
            return;
        }
        if (this.spans.isEmpty()) {
            this.tag_uids = new Bytes.ByteMap();
            this.aggregated_tag_uids = new HashSet<byte[]>();
            return;
        }
        Bytes.ByteMap tag_set = new Bytes.ByteMap();
        Bytes.ByteMap discards = new Bytes.ByteMap();
        for (Span span : this.spans) {
            Bytes.ByteMap<byte[]> uids = span.getTagUids();
            for (Map.Entry tag_pair : uids.entrySet()) {
                if (discards.containsKey(tag_pair.getKey())) continue;
                byte[] tag_value = (byte[])tag_set.get(tag_pair.getKey());
                if (tag_value == null) {
                    tag_set.put(tag_pair.getKey(), tag_pair.getValue());
                    continue;
                }
                if (Bytes.memcmp((byte[])tag_value, (byte[])((byte[])tag_pair.getValue())) == 0) continue;
                discards.put(tag_pair.getKey(), null);
                tag_set.remove(tag_pair.getKey());
            }
        }
        this.aggregated_tag_uids = discards.keySet();
        this.tag_uids = tag_set;
    }

    @Override
    public String metricName() {
        try {
            return (String)this.metricNameAsync().joinUninterruptibly();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Should never be here", e);
        }
    }

    @Override
    public Deferred<String> metricNameAsync() {
        return this.spans.isEmpty() ? Deferred.fromResult((Object)"") : this.spans.get(0).metricNameAsync();
    }

    @Override
    public byte[] metricUID() {
        return this.spans.isEmpty() ? new byte[]{} : this.spans.get(0).metricUID();
    }

    @Override
    public Map<String, String> getTags() {
        try {
            return (Map)this.getTagsAsync().joinUninterruptibly();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Should never be here", e);
        }
    }

    @Override
    public Deferred<Map<String, String>> getTagsAsync() {
        if (this.tags != null) {
            return Deferred.fromResult(this.tags);
        }
        if (this.spans.isEmpty()) {
            this.tags = new HashMap<String, String>(0);
            return Deferred.fromResult(this.tags);
        }
        if (this.tag_uids == null) {
            this.computeTags();
        }
        return this.resolveTags(this.tag_uids);
    }

    @Override
    public Bytes.ByteMap<byte[]> getTagUids() {
        if (this.tag_uids == null) {
            this.computeTags();
        }
        return this.tag_uids;
    }

    @Override
    public List<String> getAggregatedTags() {
        try {
            return (List)this.getAggregatedTagsAsync().joinUninterruptibly();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Should never be here", e);
        }
    }

    @Override
    public Deferred<List<String>> getAggregatedTagsAsync() {
        if (this.aggregated_tags != null) {
            return Deferred.fromResult(this.aggregated_tags);
        }
        if (this.spans.isEmpty()) {
            this.aggregated_tags = new ArrayList<String>(0);
            return Deferred.fromResult(this.aggregated_tags);
        }
        if (this.aggregated_tag_uids == null) {
            this.computeTags();
        }
        return this.resolveAggTags(this.aggregated_tag_uids);
    }

    @Override
    public List<byte[]> getAggregatedTagUids() {
        if (this.aggregated_tag_uids != null) {
            return new ArrayList<byte[]>(this.aggregated_tag_uids);
        }
        if (this.spans.isEmpty()) {
            return Collections.emptyList();
        }
        if (this.aggregated_tag_uids == null) {
            this.computeTags();
        }
        return new ArrayList<byte[]>(this.aggregated_tag_uids);
    }

    @Override
    public List<String> getTSUIDs() {
        ArrayList<String> tsuids = new ArrayList<String>(this.spans.size());
        for (Span sp : this.spans) {
            tsuids.addAll(sp.getTSUIDs());
        }
        return tsuids;
    }

    @Override
    public List<Annotation> getAnnotations() {
        return this.annotations.isEmpty() ? null : this.annotations;
    }

    @Override
    public int size() {
        SeekableView it = this.iterator();
        int size = 0;
        while (it.hasNext()) {
            it.next();
            ++size;
        }
        return size;
    }

    @Override
    public int aggregatedSize() {
        int size = 0;
        for (Span span : this.spans) {
            size += span.size();
        }
        return size;
    }

    @Override
    public SeekableView iterator() {
        return AggregationIterator.create(this.spans, this.start_time, this.end_time, this.aggregator, this.aggregator.interpolationMethod(), this.downsampler, this.query_start, this.query_end, this.rate, this.rate_options);
    }

    private DataPoint getDataPoint(int i) {
        if (i < 0) {
            throw new IndexOutOfBoundsException("negative index: " + i);
        }
        int saved_i = i;
        SeekableView it = this.iterator();
        DataPoint dp = null;
        while (it.hasNext() && i >= 0) {
            dp = it.next();
            --i;
        }
        if (i != -1 || dp == null) {
            throw new IndexOutOfBoundsException("index " + saved_i + " too large (it's >= " + this.size() + ") for " + this);
        }
        return dp;
    }

    @Override
    public long timestamp(int i) {
        return this.getDataPoint(i).timestamp();
    }

    @Override
    public boolean isInteger(int i) {
        return this.getDataPoint(i).isInteger();
    }

    @Override
    public double doubleValue(int i) {
        return this.getDataPoint(i).doubleValue();
    }

    @Override
    public long longValue(int i) {
        return this.getDataPoint(i).longValue();
    }

    public String toString() {
        return "SpanGroup(" + this.toStringSharedAttributes() + ", spans=" + this.spans + ')';
    }

    private String toStringSharedAttributes() {
        return "start_time=" + this.start_time + ", end_time=" + this.end_time + ", tags=" + this.tags + ", aggregated_tags=" + this.aggregated_tags + ", rate=" + this.rate + ", aggregator=" + this.aggregator + ", downsampler=" + this.downsampler + ", query_start=" + this.query_start + ", query_end" + this.query_end + ')';
    }

    @Override
    public int getQueryIndex() {
        return this.query_index;
    }

    private Deferred<List<String>> resolveAggTags(Set<byte[]> tagks) {
        if (this.aggregated_tags != null) {
            return Deferred.fromResult(null);
        }
        this.aggregated_tags = new ArrayList<String>(tagks.size());
        ArrayList<Deferred<String>> names = new ArrayList<Deferred<String>>(tagks.size());
        for (byte[] tagk : tagks) {
            names.add(this.tsdb.tag_names.getNameAsync(tagk));
        }
        final class ResolveCB
        implements Callback<List<String>, ArrayList<String>> {
            ResolveCB() {
            }

            public List<String> call(ArrayList<String> names) throws Exception {
                for (String name : names) {
                    SpanGroup.this.aggregated_tags.add(name);
                }
                return SpanGroup.this.aggregated_tags;
            }
        }
        return Deferred.group(names).addCallback((Callback)new ResolveCB());
    }

    private Deferred<Map<String, String>> resolveTags(Bytes.ByteMap<byte[]> tag_uids) {
        if (this.tags != null) {
            return Deferred.fromResult(null);
        }
        this.tags = new HashMap<String, String>(tag_uids.size());
        ArrayList<Deferred> deferreds = new ArrayList<Deferred>(tag_uids.size());
        for (Map.Entry tag_pair : tag_uids.entrySet()) {
            ArrayList<Deferred<String>> resolve_pair = new ArrayList<Deferred<String>>(2);
            resolve_pair.add(this.tsdb.tag_names.getNameAsync((byte[])tag_pair.getKey()));
            resolve_pair.add(this.tsdb.tag_values.getNameAsync((byte[])tag_pair.getValue()));
            final class PairCB
            implements Callback<Object, ArrayList<String>> {
                PairCB() {
                }

                public Object call(ArrayList<String> pair) throws Exception {
                    SpanGroup.this.tags.put(pair.get(0), pair.get(1));
                    return null;
                }
            }
            deferreds.add(Deferred.groupInOrder(resolve_pair).addCallback((Callback)new PairCB()));
        }
        final class GroupCB
        implements Callback<Map<String, String>, ArrayList<Object>> {
            GroupCB() {
            }

            public Map<String, String> call(ArrayList<Object> group) throws Exception {
                return SpanGroup.this.tags;
            }
        }
        return Deferred.group(deferreds).addCallback((Callback)new GroupCB());
    }
}

